/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.buildServer.util.Disposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedThreadUtil {
    private static final String tc_prefix = "TC: ";
    private static final Map<Thread, long[]> ourInitialThreadStats = new ConcurrentHashMap<Thread, long[]>();
    private static final int ALLOC_MEM_POS = 0;
    private static final int USED_CPU_POS = 1;
    private static Method ourThreadAllocatedSizeMethod;

    @NotNull
    public static ThreadNameCookie updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadUtil", "updateThreadName"));
        }
        ThreadNameCookie threadNameCookie = new ThreadNameCookie(false).setNewName(newDetails);
        if (threadNameCookie == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil", "updateThreadName"));
        }
        return threadNameCookie;
    }

    @NotNull
    public static Disposable updateThreadName(@NotNull String newDetails, boolean rememberThreadStatistics) {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadUtil", "updateThreadName"));
        }
        ThreadNameCookie threadNameCookie = new ThreadNameCookie(rememberThreadStatistics).setNewName(newDetails);
        if (threadNameCookie == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil", "updateThreadName"));
        }
        return threadNameCookie;
    }

    public static String getTcThreadPrefix() {
        return tc_prefix + NamedThreadUtil.time_prefix();
    }

    @NotNull
    private static String time_prefix() {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour).append(':');
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min).append(':');
        if (sec < 10) {
            sb.append('0');
        }
        sb.append(sec).append(' ');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil", "time_prefix"));
        }
        return string;
    }

    @Nullable
    public static long[] getThreadStatistics(@NotNull Thread thread, @Nullable ThreadMXBean threadMXBean) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "jetbrains/buildServer/util/NamedThreadUtil", "getThreadStatistics"));
        }
        long[] initial = ourInitialThreadStats.get(thread);
        if (initial == null) {
            return null;
        }
        long[] current = NamedThreadUtil.getCurrentStats(thread, threadMXBean);
        return new long[]{current[0] - initial[0], current[1] - initial[1]};
    }

    private static void initThreadStatistics(Thread thread) {
        long[] stats = NamedThreadUtil.getCurrentStats(thread, NamedThreadUtil.getThreadsBean());
        ourInitialThreadStats.put(thread, stats);
    }

    private static long[] getCurrentStats(@NotNull Thread thread, @Nullable ThreadMXBean threadMXBean) {
        long cpuTime;
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "jetbrains/buildServer/util/NamedThreadUtil", "getCurrentStats"));
        }
        long[] stats = new long[]{-1L, -1L};
        Long allocated = NamedThreadUtil.getThreadAllocatedBytes(thread, threadMXBean);
        if (allocated != null) {
            stats[0] = allocated;
        }
        stats[1] = cpuTime = threadMXBean != null && threadMXBean.isThreadCpuTimeSupported() ? threadMXBean.getThreadCpuTime(thread.getId()) : -1L;
        return stats;
    }

    private static void resetThreadStatistics(Thread thread) {
        ourInitialThreadStats.remove(thread);
    }

    @Nullable
    public static Long getThreadAllocatedBytes(@NotNull Thread thread, @Nullable ThreadMXBean threadMXBean) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "jetbrains/buildServer/util/NamedThreadUtil", "getThreadAllocatedBytes"));
        }
        try {
            return threadMXBean == null ? null : (Long)ourThreadAllocatedSizeMethod.invoke((Object)threadMXBean, thread.getId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static ThreadMXBean getThreadsBean() {
        try {
            return ManagementFactory.getThreadMXBean();
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        ThreadMXBean bean = NamedThreadUtil.getThreadsBean();
        if (bean != null) {
            try {
                ourThreadAllocatedSizeMethod = bean.getClass().getMethod("getThreadAllocatedBytes", Long.TYPE);
                ourThreadAllocatedSizeMethod.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static final class ThreadNameCookie
    implements Disposable {
        private final Thread myThread = Thread.currentThread();
        private final String myOldName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ThreadNameCookie(boolean rememberThreadStatistics) {
            try {
                String name = this.myThread.getName();
                if (name == null) {
                    name = "";
                }
                this.myOldName = name;
            }
            finally {
                if (rememberThreadStatistics) {
                    NamedThreadUtil.initThreadStatistics(this.myThread);
                }
            }
        }

        @NotNull
        public String getOldName() {
            String string = this.myOldName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie", "getOldName"));
            }
            return string;
        }

        @NotNull
        public ThreadNameCookie setNewName(@NotNull String newDetails) {
            if (newDetails == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie", "setNewName"));
            }
            String currentName = this.getOldName();
            String namePrefix = NamedThreadUtil.getTcThreadPrefix() + newDetails + "; ";
            if (currentName.startsWith(NamedThreadUtil.tc_prefix)) {
                this.myThread.setName(namePrefix + currentName.substring(NamedThreadUtil.tc_prefix.length()));
            } else {
                this.myThread.setName(namePrefix + currentName);
            }
            ThreadNameCookie threadNameCookie = this;
            if (threadNameCookie == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie", "setNewName"));
            }
            return threadNameCookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            try {
                this.myThread.setName(this.myOldName);
            }
            finally {
                NamedThreadUtil.resetThreadStatistics(this.myThread);
            }
        }
    }
}

