/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<Type> {
    private static final Map<String, Option> ourOptions = new HashMap<String, Option>();
    private final String myKey;
    private final Type myDefaultValue;

    public Option(@NonNls @NotNull String key, @NotNull Type defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/Option", "<init>"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "jetbrains/buildServer/util/Option", "<init>"));
        }
        this.myKey = key;
        this.myDefaultValue = defaultValue;
        ourOptions.put(key, this);
    }

    public abstract Type fromString(String var1);

    public abstract String toString(Type var1);

    @Nullable
    public static Option fromKey(String key) {
        return ourOptions.get(key);
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Option", "getKey"));
        }
        return string;
    }

    @NotNull
    public Type getDefaultValue() {
        Type Type2 = this.myDefaultValue;
        if (Type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Option", "getDefaultValue"));
        }
        return Type2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return !(this.myKey == null ? option.myKey != null : !this.myKey.equals(option.myKey));
    }

    public int hashCode() {
        return this.myKey != null ? this.myKey.hashCode() : 0;
    }

    public String toString() {
        return this.myKey;
    }
}

