/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;
import jetbrains.buildServer.util.PEReader.InvalidSignatureException;

public class PEVsFixedFileInfo {
    public static final long CORRECT_SIGNATURE = 4277077181L;
    private long mySignature;
    private long myStructVersion;
    private int myFileVersion1;
    private int myFileVersion2;
    private int myFileVersion3;
    private int myFileVersion4;
    private int myProductVersion1;
    private int myProductVersion2;
    private int myProductVersion3;
    private int myProductVersion4;
    private long myFileFlagsMask;
    private long myFileFlags;
    private long myFileOS;
    private long myFileType;
    private long myFileSubtype;
    private long myFileDateMS;
    private long myFileDateLS;

    private PEVsFixedFileInfo() {
    }

    public static PEVsFixedFileInfo read(RandomAccessFile raf) throws IOException {
        PEVsFixedFileInfo res = new PEVsFixedFileInfo();
        res.mySignature = BinaryUtils.readUInt32(raf);
        if (res.mySignature != 4277077181L) {
            throw new InvalidSignatureException("Incorrect signature on PEVsFixedFileInfo");
        }
        res.myStructVersion = BinaryUtils.readUInt32(raf);
        res.myFileVersion2 = BinaryUtils.readUInt16(raf);
        res.myFileVersion1 = BinaryUtils.readUInt16(raf);
        res.myFileVersion4 = BinaryUtils.readUInt16(raf);
        res.myFileVersion3 = BinaryUtils.readUInt16(raf);
        res.myProductVersion2 = BinaryUtils.readUInt16(raf);
        res.myProductVersion1 = BinaryUtils.readUInt16(raf);
        res.myProductVersion4 = BinaryUtils.readUInt16(raf);
        res.myProductVersion3 = BinaryUtils.readUInt16(raf);
        res.myFileFlagsMask = BinaryUtils.readUInt32(raf);
        res.myFileFlags = BinaryUtils.readUInt32(raf);
        res.myFileOS = BinaryUtils.readUInt32(raf);
        res.myFileType = BinaryUtils.readUInt32(raf);
        res.myFileSubtype = BinaryUtils.readUInt32(raf);
        res.myFileDateMS = BinaryUtils.readUInt32(raf);
        res.myFileDateLS = BinaryUtils.readUInt32(raf);
        return res;
    }

    public long getSignature() {
        return this.mySignature;
    }

    public long getStructVersion() {
        return this.myStructVersion;
    }

    public int getFileVersion1() {
        return this.myFileVersion1;
    }

    public int getFileVersion2() {
        return this.myFileVersion2;
    }

    public int getFileVersion3() {
        return this.myFileVersion3;
    }

    public int getFileVersion4() {
        return this.myFileVersion4;
    }

    public int getProductVersion1() {
        return this.myProductVersion1;
    }

    public int getProductVersion2() {
        return this.myProductVersion2;
    }

    public int getProductVersion3() {
        return this.myProductVersion3;
    }

    public int getProductVersion4() {
        return this.myProductVersion4;
    }

    public long getFileFlagsMask() {
        return this.myFileFlagsMask;
    }

    public long getFileFlags() {
        return this.myFileFlags;
    }

    public long getFileOS() {
        return this.myFileOS;
    }

    public long getFileType() {
        return this.myFileType;
    }

    public long getFileSubtype() {
        return this.myFileSubtype;
    }

    public long getFileDateMS() {
        return this.myFileDateMS;
    }

    public long getFileDateLS() {
        return this.myFileDateLS;
    }
}

