/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.text.LineReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    private PropertiesUtil() {
    }

    @Contract(value="null -> false")
    public static boolean getBoolean(@Nullable String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    @Contract(value="null -> true")
    public static boolean isEmptyOrNull(@Nullable String value) {
        return value == null || value.trim().length() == 0;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Integer parseInt(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Contract(value="null -> null")
    @Nullable
    public static Long parseLong(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int compareProperties(@NotNull Map<String, String> props1, @NotNull Map<String, String> props2) {
        if (props1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props1", "jetbrains/buildServer/util/PropertiesUtil", "compareProperties"));
        }
        if (props2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props2", "jetbrains/buildServer/util/PropertiesUtil", "compareProperties"));
        }
        int commonProps = 0;
        for (String name : props1.keySet()) {
            if (!props1.get(name).equals(props2.get(name))) continue;
            ++commonProps;
        }
        if (props1.size() == commonProps) {
            return props2.size() - commonProps;
        }
        if (props2.size() == commonProps) {
            return commonProps - props1.size();
        }
        return 0;
    }

    @NotNull
    public static Properties loadProperties(File propertiesFile) throws IOException {
        if (propertiesFile == null) {
            Properties properties = new Properties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadProperties"));
            }
            return properties;
        }
        Properties properties = PropertiesUtil.loadProperties(new FileInputStream(propertiesFile));
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadProperties"));
        }
        return properties;
    }

    @NotNull
    public static Properties loadPropertiesZipped(File propertiesFile) throws IOException {
        if (propertiesFile == null) {
            Properties properties = new Properties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadPropertiesZipped"));
            }
            return properties;
        }
        Properties properties = PropertiesUtil.loadProperties(new GZIPInputStream(new BufferedInputStream(new FileInputStream(propertiesFile))));
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadPropertiesZipped"));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Properties loadProperties(@Nullable InputStream inputStream) throws IOException {
        Properties properties;
        if (inputStream == null) {
            Properties properties2 = new Properties();
            if (properties2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadProperties"));
            }
            return properties2;
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(inputStream);
            Properties properties3 = new Properties();
            properties3.load(inStream);
            properties = properties3;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        Properties properties4 = properties;
        if (properties4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadProperties"));
        }
        return properties4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Properties loadPropertiesXml(File propertiesFile) throws IOException {
        Properties properties;
        if (propertiesFile == null) {
            Properties properties2 = new Properties();
            if (properties2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadPropertiesXml"));
            }
            return properties2;
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(propertiesFile));
            Properties properties3 = new Properties();
            properties3.loadFromXML(inStream);
            properties = properties3;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        Properties properties4 = properties;
        if (properties4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "loadPropertiesXml"));
        }
        return properties4;
    }

    @NotNull
    public static Map<String, String> toMap(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/util/PropertiesUtil", "toMap"));
        }
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "toMap"));
        }
        return hashMap;
    }

    public static void storeProperties(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/util/PropertiesUtil", "storeProperties"));
        }
        if (propertiesFile == null) {
            return;
        }
        PropertiesUtil.storeProperties(properties, new FileOutputStream(propertiesFile), comment);
    }

    public static void storePropertiesZipped(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/util/PropertiesUtil", "storePropertiesZipped"));
        }
        if (propertiesFile == null) {
            return;
        }
        PropertiesUtil.storeProperties(properties, new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(propertiesFile))), comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(@NotNull Properties properties, @Nullable OutputStream stream, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/util/PropertiesUtil", "storeProperties"));
        }
        if (stream == null) {
            return;
        }
        BufferedOutputStream fos = new BufferedOutputStream(stream);
        try {
            properties.store(fos, comment);
        }
        finally {
            PropertiesUtil.close(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePropertiesXml(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/util/PropertiesUtil", "storePropertiesXml"));
        }
        if (propertiesFile == null) {
            return;
        }
        BufferedOutputStream fos = null;
        try {
            FileUtil.createParentDirs((File)propertiesFile);
            fos = new BufferedOutputStream(new FileOutputStream(propertiesFile));
            properties.storeToXML((OutputStream)fos, comment, "utf-8");
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(fos);
            throw throwable;
        }
        PropertiesUtil.close(fos);
    }

    public static boolean isDifferent(@NotNull Properties p1, @NotNull Properties p2) {
        if (p1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p1", "jetbrains/buildServer/util/PropertiesUtil", "isDifferent"));
        }
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p2", "jetbrains/buildServer/util/PropertiesUtil", "isDifferent"));
        }
        return !p1.equals(p2);
    }

    private static byte[] getLineForKey(@NotNull String key, @NotNull String value) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/PropertiesUtil", "getLineForKey"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/util/PropertiesUtil", "getLineForKey"));
        }
        Properties ps = new Properties();
        ps.setProperty(key, value);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ps.store(bos, null);
        bos.close();
        List newLines = new LineReader((InputStream)new ByteArrayInputStream(bos.toByteArray())).readLines();
        Iterator iterator = newLines.iterator();
        while (iterator.hasNext()) {
            byte[] line = (byte[])iterator.next();
            if (line.length != 0 && line[0] != 35) continue;
            iterator.remove();
        }
        assert (newLines.size() == 1);
        return (byte[])newLines.get(0);
    }

    @NotNull
    public static Set<String> getPropertyNames(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/util/PropertiesUtil", "getPropertyNames"));
        }
        HashSet<String> names = new HashSet<String>();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            names.add((String)o);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/PropertiesUtil", "getPropertyNames"));
        }
        return hashSet;
    }

    @Nullable
    private static Pair<String, String> getPairFromLine(@NotNull byte[] line) throws IOException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "jetbrains/buildServer/util/PropertiesUtil", "getPairFromLine"));
        }
        Properties ps = new Properties();
        ps.load(new ByteArrayInputStream(line));
        assert (ps.size() <= 1);
        if (ps.size() == 0) {
            return null;
        }
        String key = (String)ps.keys().nextElement();
        return Pair.create((Object)key, (Object)ps.getProperty(key));
    }

    public static boolean updatePropertiesFromFile(@NotNull File propertiesFile, @NotNull Map<String, String> propertiesToUpdate, @NotNull Set<String> toRemove) throws IOException {
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "jetbrains/buildServer/util/PropertiesUtil", "updatePropertiesFromFile"));
        }
        if (propertiesToUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesToUpdate", "jetbrains/buildServer/util/PropertiesUtil", "updatePropertiesFromFile"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "jetbrains/buildServer/util/PropertiesUtil", "updatePropertiesFromFile"));
        }
        if (propertiesToUpdate.isEmpty() && toRemove.isEmpty()) {
            return true;
        }
        Properties properties = PropertiesUtil.loadProperties(propertiesFile);
        for (Map.Entry<String, String> entry : propertiesToUpdate.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        for (String key : toRemove) {
            properties.remove(key);
        }
        return PropertiesUtil.updateProperties(propertiesFile, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateProperties(@NotNull File propertiesFile, @NotNull Properties newProperties, @Nullable String commentIfFileIsRecreated) throws IOException {
        List lines;
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "jetbrains/buildServer/util/PropertiesUtil", "updateProperties"));
        }
        if (newProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProperties", "jetbrains/buildServer/util/PropertiesUtil", "updateProperties"));
        }
        if (!propertiesFile.exists()) {
            PropertiesUtil.storeProperties(newProperties, propertiesFile, commentIfFileIsRecreated);
            return true;
        }
        Properties oldProperties = PropertiesUtil.loadProperties(propertiesFile);
        if (!PropertiesUtil.isDifferent(oldProperties, newProperties)) {
            return false;
        }
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(propertiesFile));
        try {
            lines = new LineReader((InputStream)fis).readLines();
        }
        finally {
            ((InputStream)fis).close();
        }
        Set<String> oldNames = PropertiesUtil.getPropertyNames(oldProperties);
        Set<String> newNames = PropertiesUtil.getPropertyNames(newProperties);
        ArrayList<byte[]> newLines = new ArrayList<byte[]>();
        boolean isMultiline = false;
        boolean isKeepMultiline = false;
        for (byte[] line : lines) {
            Pair<String, String> pair = PropertiesUtil.getPairFromLine(line);
            if (isMultiline && pair != null && StringUtil.isNotEmpty((String)((String)pair.first)) && StringUtil.isEmpty((String)((String)pair.second)) && line[line.length - 1] != 61) {
                if (!isKeepMultiline) continue;
                newLines.add(line);
                continue;
            }
            if (pair == null) {
                if (isMultiline && !isKeepMultiline) continue;
                newLines.add(line);
                continue;
            }
            String key = (String)pair.first;
            boolean bl = isMultiline = !((String)pair.second).equals(oldProperties.getProperty(key));
            if (newProperties.containsKey(key)) {
                if (newProperties.getProperty(key).equals(oldProperties.getProperty(key))) {
                    newLines.add(line);
                    isKeepMultiline = true;
                    continue;
                }
                newLines.add(PropertiesUtil.getLineForKey(key, newProperties.getProperty(key)));
                isKeepMultiline = false;
                continue;
            }
            isKeepMultiline = false;
            byte[] commented = new byte[line.length + 2];
            commented[0] = 35;
            commented[1] = 32;
            for (byte commented[i + 2] : line) {
            }
            newLines.add(commented);
        }
        for (String newName : newNames) {
            if (oldNames.contains(newName)) continue;
            newLines.add(PropertiesUtil.getLineForKey(newName, newProperties.getProperty(newName)));
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(propertiesFile));
        try {
            byte[] endLine = System.getProperty("line.separator").getBytes("ISO-8859-1");
            for (byte[] newLine : newLines) {
                ((OutputStream)fos).write(newLine);
                ((OutputStream)fos).write(endLine);
            }
        }
        finally {
            PropertiesUtil.close(fos);
        }
        return true;
    }

    private static void close(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

