/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentEntriesCache<K, V> {
    private final Map<K, Value<V>> myEntries;
    private boolean myRememberNullValues;
    private long myAccesses;
    private long myHits;
    private final String myCacheName;
    private final Value<V> myNullValue;

    public RecentEntriesCache(int maxEntries) {
        this("", maxEntries, false);
    }

    public RecentEntriesCache(int maxEntries, boolean rememberNullValues) {
        this("", maxEntries, rememberNullValues);
    }

    public RecentEntriesCache(@NotNull String cacheName, int maxEntries) {
        if (cacheName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheName", "jetbrains/buildServer/util/RecentEntriesCache", "<init>"));
        }
        this(cacheName, maxEntries, false);
    }

    public RecentEntriesCache(@NotNull String cacheName, int maxEntries, boolean rememberNullValues) {
        if (cacheName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheName", "jetbrains/buildServer/util/RecentEntriesCache", "<init>"));
        }
        this.myRememberNullValues = false;
        this.myAccesses = 0L;
        this.myHits = 0L;
        this.myNullValue = new Value(null);
        this.myCacheName = cacheName;
        this.myEntries = this.createCacheStorage(maxEntries);
        this.myRememberNullValues = rememberNullValues;
    }

    @NotNull
    protected Map<K, Value<V>> createCacheStorage(final int maxEntries) {
        LinkedHashMap linkedHashMap = new LinkedHashMap<K, Value<V>>(maxEntries, 0.8f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Value<V>> eldest) {
                return this.size() > maxEntries;
            }
        };
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/RecentEntriesCache", "createCacheStorage"));
        }
        return linkedHashMap;
    }

    public synchronized int size() {
        return this.myEntries.size();
    }

    public synchronized boolean isEmpty() {
        return this.myEntries.isEmpty();
    }

    @Nullable
    public synchronized V get(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/RecentEntriesCache", "get"));
        }
        Value<V> val = this.myEntries.get(key);
        ++this.myAccesses;
        if (val == null) {
            return null;
        }
        ++this.myHits;
        return val.get();
    }

    public synchronized void put(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/RecentEntriesCache", "put"));
        }
        if (!this.myRememberNullValues && value == null) {
            throw new NullPointerException("Null values are not accepted by this cache");
        }
        this.myEntries.put(key, value == null ? this.myNullValue : new Value(value));
    }

    @NotNull
    public synchronized Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>(this.myEntries.keySet());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/RecentEntriesCache", "keySet"));
        }
        return hashSet;
    }

    public synchronized void clear() {
        this.myEntries.clear();
    }

    public synchronized void remove(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/RecentEntriesCache", "remove"));
        }
        this.myEntries.remove(key);
    }

    public synchronized void removeValues(@NotNull Filter<V> valueFilter) {
        if (valueFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueFilter", "jetbrains/buildServer/util/RecentEntriesCache", "removeValues"));
        }
        Iterator<Map.Entry<K, Value<V>>> entryIt = this.myEntries.entrySet().iterator();
        while (entryIt.hasNext()) {
            Value<V> value = entryIt.next().getValue();
            if (!valueFilter.accept(value.get())) continue;
            entryIt.remove();
        }
    }

    public synchronized void forEach(@NotNull ItemProcessor<V> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/util/RecentEntriesCache", "forEach"));
        }
        for (Value<V> value : this.myEntries.values()) {
            if (processor.processItem(value.get())) continue;
            return;
        }
    }

    public synchronized V lookupOrCompute(@NotNull K key, @NotNull Function<K, V> compute) {
        V v;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/RecentEntriesCache", "lookupOrCompute"));
        }
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "jetbrains/buildServer/util/RecentEntriesCache", "lookupOrCompute"));
        }
        Value<V> val = this.myEntries.get(key);
        if (val != null && val == this.myNullValue) {
            return null;
        }
        V v2 = v = val == null ? null : (V)val.get();
        if (v != null) {
            return v;
        }
        v = compute.fun(key);
        if (v == null && this.myRememberNullValues) {
            this.put(key, v);
        } else if (v == null && !this.myRememberNullValues) {
            return null;
        }
        this.put(key, v);
        return v;
    }

    public synchronized float getHitRate() {
        return 1.0f * (float)this.myHits / (float)this.myAccesses;
    }

    public synchronized String toString() {
        StringBuilder descr = new StringBuilder();
        descr.append("Cache \"").append(this.myCacheName).append("\" ");
        descr.append("[size: ").append(this.myEntries.size()).append(", hit rate: ").append(this.getHitRate() * 100.0f).append("%]");
        return descr.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Value<V> {
        private final V myValue;

        private Value(V value) {
            this.myValue = value;
        }

        V get() {
            return this.myValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<K, V> {
        public V fun(@NotNull K var1);
    }
}

