/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.util.TCStreamUtil;
import org.jetbrains.annotations.NotNull;

public class RunCommand {
    @NotNull
    private static String streamToString(@NotNull InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "jetbrains/buildServer/util/RunCommand", "streamToString"));
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            TCStreamUtil.writeBinary(stream, bos);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            bos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = bos.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/RunCommand", "streamToString"));
        }
        return string;
    }

    public void runCommand(@NotNull String command, @NotNull OutputProcessor processor) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "jetbrains/buildServer/util/RunCommand", "runCommand"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/util/RunCommand", "runCommand"));
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            int exitCode = process.waitFor();
            processor.processExitCode(exitCode);
            processor.processOutput(RunCommand.streamToString(process.getInputStream()), RunCommand.streamToString(process.getErrorStream()));
        }
        catch (Exception e) {
            processor.processError(e);
        }
    }

    public static class LoggerOutputProcessor
    implements OutputProcessor {
        private final Logger myLogger;
        private final String myCommandTitle;

        public LoggerOutputProcessor(Logger logger, String commandTitle) {
            this.myLogger = logger;
            this.myCommandTitle = commandTitle;
        }

        public void processOutput(@NotNull String stdout, @NotNull String stderr) {
            if (stdout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdout", "jetbrains/buildServer/util/RunCommand$LoggerOutputProcessor", "processOutput"));
            }
            if (stderr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stderr", "jetbrains/buildServer/util/RunCommand$LoggerOutputProcessor", "processOutput"));
            }
            this.myLogger.info(this.myCommandTitle + " call: \n" + stdout + "\n" + stderr);
        }

        public void processError(@NotNull Exception e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "jetbrains/buildServer/util/RunCommand$LoggerOutputProcessor", "processError"));
            }
            this.myLogger.warn("Failed to start " + this.myCommandTitle + " command." + e.getMessage());
            this.myLogger.debug("Failed to start " + this.myCommandTitle + " command." + e.getMessage(), (Throwable)e);
        }

        public void processExitCode(int code) {
            this.myLogger.info(this.myCommandTitle + " exit code:" + code);
        }
    }

    public static interface OutputProcessor {
        public void processOutput(@NotNull String var1, @NotNull String var2);

        public void processError(@NotNull Exception var1);

        public void processExitCode(int var1);
    }
}

