/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionComparatorUtil {
    private static final Pattern myWordsSplitter = Pattern.compile("\\d+|[^\\d]+");

    static Vector<String> splitVersionString(String ver) {
        StringTokenizer st = new StringTokenizer(ver.trim(), "()._-;:/, +~");
        Vector<String> result = new Vector<String>();
        while (st.hasMoreTokens()) {
            Matcher matcher = myWordsSplitter.matcher(st.nextToken());
            while (matcher.find()) {
                result.add(matcher.group());
            }
        }
        return result;
    }

    public static int compare(String ver1, String ver2) {
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        ver1 = ver1.toLowerCase();
        ver2 = ver2.toLowerCase();
        Vector<String> s1 = VersionComparatorUtil.splitVersionString(ver1);
        Vector<String> s2 = VersionComparatorUtil.splitVersionString(ver2);
        VersionComparatorUtil.padWithNulls(s1, s2);
        int res = 0;
        for (int i = 0; i < s1.size(); ++i) {
            VersionTokenType t2;
            String e1 = s1.elementAt(i);
            String e2 = s2.elementAt(i);
            VersionTokenType t1 = VersionTokenType.lookup(e1);
            if (!t1.equals((Object)(t2 = VersionTokenType.lookup(e2)))) {
                res = VersionComparatorUtil.comparePriorities(t1, t2);
            } else if (t1 == VersionTokenType._WORD) {
                res = e1.compareTo(e2);
            } else if (t1 == VersionTokenType._DIGITS) {
                res = VersionComparatorUtil.compareNumbers(e1, e2);
            }
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    private static int comparePriorities(VersionTokenType t1, VersionTokenType t2) {
        int p2;
        int p1 = t1.getPriority();
        if (p1 == (p2 = t2.getPriority())) {
            return 0;
        }
        return p1 > p2 ? 1 : -1;
    }

    private static int compareNumbers(String n1, String n2) {
        int n2len;
        while (n1.length() > 0 && n2.length() > 0 && n1.charAt(0) == '0' && n2.charAt(0) == '0') {
            n1 = n1.substring(1);
            n2 = n2.substring(1);
        }
        if (n1.length() > 0 && n1.charAt(0) == '0') {
            return -1;
        }
        if (n2.length() > 0 && n2.charAt(0) == '0') {
            return 1;
        }
        int n1len = n1.length();
        if (n1len > (n2len = n2.length())) {
            n2 = StringUtil.repeatSymbol((char)'0', (int)(n1len - n2len)) + n2;
        } else if (n2len > n1len) {
            n1 = StringUtil.repeatSymbol((char)'0', (int)(n2len - n1len)) + n1;
        }
        return n1.compareTo(n2);
    }

    private static void padWithNulls(Collection<String> s1, Collection<String> s2) {
        if (s1.size() != s2.size()) {
            while (s1.size() < s2.size()) {
                s1.add(null);
            }
            while (s1.size() > s2.size()) {
                s2.add(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VersionTokenType {
        SNAP(10),
        SNAPSHOT(10),
        M(20),
        EAP(25),
        ALPHA(30),
        A(30),
        BETA(40),
        BETTA(40),
        B(40),
        RC(50),
        _WS(60),
        SP(70),
        REL(80),
        RELEASE(80),
        R(80),
        FINAL(80),
        _WORD(90),
        _DIGITS(100);

        private final int myPriority;

        private VersionTokenType(int priority) {
            this.myPriority = priority;
        }

        @NotNull
        public static VersionTokenType lookup(String str) {
            if (str == null) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/VersionComparatorUtil$VersionTokenType", "lookup"));
                }
                return versionTokenType;
            }
            if ((str = str.trim()).length() == 0) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/VersionComparatorUtil$VersionTokenType", "lookup"));
                }
                return versionTokenType;
            }
            for (VersionTokenType token : VersionTokenType.values()) {
                String name = token.name();
                if (name.charAt(0) == '_' || !name.equalsIgnoreCase(str)) continue;
                VersionTokenType versionTokenType = token;
                if (versionTokenType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/VersionComparatorUtil$VersionTokenType", "lookup"));
                }
                return versionTokenType;
            }
            if (str.matches("\\d+")) {
                VersionTokenType versionTokenType = _DIGITS;
                if (versionTokenType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/VersionComparatorUtil$VersionTokenType", "lookup"));
                }
                return versionTokenType;
            }
            VersionTokenType versionTokenType = _WORD;
            if (versionTokenType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/VersionComparatorUtil$VersionTokenType", "lookup"));
            }
            return versionTokenType;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }
}

