/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.positioning.PluginAwareComparison;
import jetbrains.buildServer.util.positioning.PositionAware;
import jetbrains.buildServer.util.positioning.PositionAwareSortedCollection;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionAwareCollection<T> {
    private final Object LOCK;
    private final PluginAwareComparison myComparison;
    private final AtomicReference<List<T>> mySortedExtensions;
    private final PositionAwareSortedCollection<T> myPositions;

    public PositionAwareCollection() {
        this(PluginAwareComparison.BY_REF);
    }

    public PositionAwareCollection(@NotNull PluginAwareComparison comparison) {
        if (comparison == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparison", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "<init>"));
        }
        this.LOCK = new Object();
        this.mySortedExtensions = new AtomicReference();
        this.myPositions = new PositionAwareSortedCollection();
        this.myComparison = comparison;
    }

    private void resetCache() {
        this.mySortedExtensions.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myPositions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myPositions.clear();
            this.resetCache();
        }
    }

    public void add(@NotNull T item, @NotNull PositionAware positionAware) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "add"));
        }
        if (positionAware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positionAware", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "add"));
        }
        this.add(item, positionAware.getOrderId(), positionAware.getConstraint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull T item, @NotNull String id, @NotNull PositionConstraint constraint) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "add"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "add"));
        }
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "add"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.remove(item);
            this.myPositions.add(item, id, constraint);
            this.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(final @NotNull T item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "remove"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean result = this.myPositions.removeWhere(new Filter<T>(){

                @Override
                public boolean accept(@NotNull T data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/positioning/PositionAwareCollection$1", "accept"));
                    }
                    return PositionAwareCollection.this.myComparison.equal(data, item);
                }
            });
            this.resetCache();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<T> getAllSorted() {
        List<T> result = this.mySortedExtensions.get();
        if (result == null) {
            Object object = this.LOCK;
            synchronized (object) {
                result = this.mySortedExtensions.get();
                if (result == null) {
                    List<T> resort = this.myPositions.getSorted();
                    this.mySortedExtensions.set(resort);
                    result = resort;
                }
            }
        }
        List<T> list = Collections.unmodifiableList(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionAwareCollection", "getAllSorted"));
        }
        return list;
    }
}

