/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsUtil;
import jetbrains.vcs.api.VcsSettings;
import org.jetbrains.annotations.NotNull;

public class VcsRootEntry
extends VcsSettings {
    private CheckoutRules myCheckoutRules;

    public VcsRootEntry(@NotNull VcsRoot vcsRoot, @NotNull CheckoutRules checkoutRules) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "jetbrains/buildServer/vcs/VcsRootEntry", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/buildServer/vcs/VcsRootEntry", "<init>"));
        }
        super(vcsRoot, checkoutRules.getAsString());
    }

    @NotNull
    public CheckoutRules getCheckoutRules() {
        if (this.myCheckoutRules == null) {
            this.myCheckoutRules = CheckoutRules.createOn(this.getCheckoutRulesSpecification());
        }
        CheckoutRules checkoutRules = this.myCheckoutRules;
        if (checkoutRules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsRootEntry", "getCheckoutRules"));
        }
        return checkoutRules;
    }

    @NotNull
    public String getSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getVcsRoot().getId());
        builder.append('_');
        builder.append(this.getVcsRoot().getVcsName());
        builder.append('_');
        builder.append(VcsUtil.getVcsRootPropertiesHash(this.getVcsRoot()));
        builder.append('_');
        builder.append(this.getCheckoutRules().hashCode());
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsRootEntry", "getSignature"));
        }
        return string;
    }

    public String toString() {
        return "VcsRootEntry[" + super.toString() + ']';
    }
}

