/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsRootImpl
implements VcsRoot {
    public static final String UNKNOWN_ROOT_NAME = "unknown";
    private final long myId;
    private volatile String myName;
    private volatile String myVcsName;
    protected final Map<String, String> myProperties;
    @Deprecated
    @NonNls
    public static final String VCS_NAME_PROP = "vcs";
    @Deprecated
    @NonNls
    public static final String VCS_ROOT_NAME_PROP = "teamcity:vcsRootName";
    @Deprecated
    @NonNls
    public static final String BRANCH_SPEC_PROP = "teamcity:branchSpec";
    @Deprecated
    @NonNls
    protected static final String CHECKOUT_ROOT = "checkout-root";

    /*
     * WARNING - void declaration
     */
    public VcsRootImpl(long id, @NotNull String vcsName, @NotNull Map<String, String> map) {
        void properties;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "<init>"));
        }
        this.myId = id;
        this.myVcsName = vcsName;
        this.myName = (String)properties.get(VCS_ROOT_NAME_PROP);
        if (this.myName == null) {
            this.myName = UNKNOWN_ROOT_NAME;
        }
        HashMap<String, String> propsCopy = new HashMap<String, String>((Map<String, String>)properties);
        propsCopy.remove(CHECKOUT_ROOT);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(VCS_NAME_PROP);
        this.myProperties = propsCopy;
    }

    public VcsRootImpl(long id, String vcsName) {
        this(id, vcsName, Collections.emptyMap());
        this.myName = UNKNOWN_ROOT_NAME;
    }

    public VcsRootImpl(long id, Map<String, String> properties) {
        this(id, properties.get(VCS_NAME_PROP) == null ? UNKNOWN_ROOT_NAME : properties.get(VCS_NAME_PROP), properties);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getName"));
        }
        return string;
    }

    @Override
    public long getId() {
        return this.myId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String propertyName, String propertyValue) {
        Map<String, String> map = this.myProperties;
        synchronized (map) {
            this.myProperties.put(propertyName, propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(@NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "setProperties"));
        }
        Map<String, String> map2 = this.myProperties;
        synchronized (map2) {
            this.myProperties.clear();
            this.myProperties.putAll(map);
        }
    }

    @Override
    @NotNull
    public String getVcsName() {
        String string = this.myVcsName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getVcsName"));
        }
        return string;
    }

    @Override
    public String getProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getProperty"));
        }
        return this.getProperties().get(propertyName);
    }

    @Override
    public String getProperty(@NotNull String propertyName, String defaultValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getProperty"));
        }
        String result = this.getProperty(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map = this.myProperties;
        // MONITORENTER : map
        TreeMap<String, String> treeMap = new TreeMap<String, String>(this.myProperties);
        // MONITOREXIT : map
        if (treeMap != null) return treeMap;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getProperties"));
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String basicDescriptionStart = "\"" + this.getName() + "\"" + " {internal id=" + this.getId();
        if (verbose) {
            String string = basicDescriptionStart + ", properties: [" + VcsUtil.getVcsRootPropertiesAsPresentableString(this) + "]}";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "describe"));
            }
            return string;
        }
        String string = basicDescriptionStart + "}";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "describe"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "setName"));
        }
        this.myName = name;
    }

    public void setVcsName(@NotNull String vcsName) {
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "setVcsName"));
        }
        this.myVcsName = vcsName;
    }

    @Deprecated
    public static boolean isEquivalentRoots(VcsRoot root1, VcsRoot root2) {
        return VcsUtil.areEquivalentRoots(root1, root2);
    }

    public String toString() {
        return this.getName() + " {internal id=" + this.getId() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRootImpl vcsRoot = (VcsRootImpl)o;
        return this.myId == vcsRoot.myId;
    }

    public int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }
}

