/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc;

import java.util.Arrays;
import java.util.Vector;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import org.apache.xmlrpc.XmlRpcClient;

public abstract class AbstractXmlRpcTarget
implements XmlRpcTarget {
    private final String myServerUrl;
    private final String myUserAgent;

    protected AbstractXmlRpcTarget(String serverUrl, String userAgent) {
        if (serverUrl == null) {
            throw new NullPointerException("Null serverUrl is passed to XmlRpcTarget");
        }
        if (userAgent == null) {
            throw new NullPointerException("Null userAgent is passed to XmlRpcTarget");
        }
        this.myServerUrl = serverUrl;
        this.myUserAgent = userAgent;
    }

    public String getServerURL() {
        return this.myServerUrl;
    }

    public String getUserAgent() {
        return this.myUserAgent;
    }

    public abstract XmlRpcClient getClient();

    public void disposeConnections() {
    }

    public Object call(String method, Object[] parameters, XmlRpcTarget.Cancelable cancelable) throws RemoteCallException, XmlRpcTarget.ProcessCanceledException {
        if (cancelable == null) {
            return this.call(method, parameters);
        }
        Object[] result = new Object[]{null};
        try {
            this.callWithCancelable(method, parameters, result, cancelable);
        }
        catch (XmlRpcTarget.ProcessCanceledException e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RemoteCallException("Call " + this.getClient().getURL() + ' ' + method, e);
        }
        if (result[0] instanceof Throwable) {
            throw new RemoteCallException("Call " + this.getClient().getURL() + ' ' + method, (Throwable)result[0]);
        }
        return result[0];
    }

    public Object call(String method, Object[] parameters) throws RemoteCallException {
        Object result;
        try {
            result = this.getClient().execute(method, new Vector<Object>(Arrays.asList(parameters)));
            if (result instanceof Throwable) {
                throw new RemoteCallException("Call " + this.getClient().getURL() + ' ' + method, (Throwable)result);
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RemoteCallException("Call " + this.getClient().getURL() + ' ' + method, e);
        }
        if (result == null) {
            throw new IllegalStateException("XML-RPC library returned null as result");
        }
        return result;
    }

    public String describeMe() {
        return this.myServerUrl;
    }

    protected void callWithCancelable(String method, Object[] parameters, Object[] result, XmlRpcTarget.Cancelable cancelable) throws XmlRpcTarget.ProcessCanceledException {
        result[0] = this.call(method, parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractXmlRpcTarget that = (AbstractXmlRpcTarget)o;
        return this.myServerUrl.equals(that.myServerUrl);
    }

    public int hashCode() {
        return this.myServerUrl.hashCode();
    }

    public String toString() {
        return "Target: " + this.myServerUrl + ", User-Agent: " + this.myUserAgent;
    }
}

