/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.buildServer.messages.XStreamHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamWrapper {
    private XStreamWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deserializeObjects(@NotNull Collection objectsXml, @NotNull XStreamHolder holder) {
        if (objectsXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectsXml", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjects"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjects"));
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        XStream xStream = holder.getXStream();
        try {
            for (Object nodeObj : objectsXml) {
                if (!(nodeObj instanceof String)) continue;
                String messageXml = (String)nodeObj;
                try {
                    messages.add(XStreamWrapper.fromXML(xStream, messageXml));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deserializeObjects(@NotNull Class<T> clazz, @NotNull ClassLoader classLoader, @NotNull Collection objectsXml, @NotNull XStreamHolder holder) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjects"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjects"));
        }
        if (objectsXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectsXml", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjects"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjects"));
        }
        ArrayList<T> messages = new ArrayList<T>();
        XStream xStream = holder.getXStream(classLoader);
        try {
            for (Object nodeObj : objectsXml) {
                if (!(nodeObj instanceof String)) continue;
                String messageXml = (String)nodeObj;
                try {
                    messages.add(clazz.cast(XStreamWrapper.fromXML(xStream, messageXml)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return messages;
    }

    private static Object fromXML(@NotNull XStream xStream, @NotNull String messageXml) {
        if (xStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xStream", "jetbrains/buildServer/xstream/XStreamWrapper", "fromXML"));
        }
        if (messageXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageXml", "jetbrains/buildServer/xstream/XStreamWrapper", "fromXML"));
        }
        return xStream.fromXML(messageXml);
    }

    public static <T> Vector serializeObjects(@NotNull List<T> list, @NotNull XStreamHolder holder) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObjects"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObjects"));
        }
        return XStreamWrapper.serializeObjectsInternal(list, holder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Vector serializeObjectsInternal(@NotNull List<T> list, @NotNull XStreamHolder holder, @Nullable ClassLoader classLoader) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObjectsInternal"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObjectsInternal"));
        }
        Vector<String> result = new Vector<String>();
        XStream xStream = holder.getXStream(classLoader);
        try {
            for (T buildMessage : list) {
                result.add(XStreamWrapper.toXML(buildMessage, xStream));
            }
        }
        finally {
            holder.releaseXStream(xStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String serializeObject(@Nullable Object obj, @NotNull XStreamHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObject"));
        }
        if (obj != null) {
            XStream xStream = holder.getXStream(obj.getClass().getClassLoader());
            String string = XStreamWrapper.toXML(obj, xStream);
            String string2 = string;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObject"));
            }
            return string2;
            finally {
                holder.releaseXStream(xStream);
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeObject"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toXML(@NotNull Object obj, @NotNull XStream xStream) {
        String string;
        block9: {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "jetbrains/buildServer/xstream/XStreamWrapper", "toXML"));
            }
            if (xStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xStream", "jetbrains/buildServer/xstream/XStreamWrapper", "toXML"));
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    xStream.toXML(obj, (OutputStream)out);
                }
                finally {
                    out.close();
                }
                string = new String(out.toByteArray(), "UTF-8");
                if (string != null) break block9;
            }
            catch (IOException e) {
                e.printStackTrace();
                String string2 = xStream.toXML(obj);
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/xstream/XStreamWrapper", "toXML"));
                }
                return string2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/xstream/XStreamWrapper", "toXML"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] serializeAndZipObject(@Nullable Object obj, @NotNull XStreamHolder holder) throws IOException {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeAndZipObject"));
        }
        if (obj != null) {
            byte[] byArray;
            XStream xStream;
            block10: {
                xStream = holder.getXStream(obj.getClass().getClassLoader());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new GZIPOutputStream(buffer), "UTF-8");
                try {
                    xStream.toXML(obj, (Writer)out);
                }
                finally {
                    ((Writer)out).close();
                }
                byArray = buffer.toByteArray();
                if (byArray != null) break block10;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeAndZipObject"));
            }
            return byArray;
            finally {
                holder.releaseXStream(xStream);
            }
        }
        byte[] byArray = new byte[]{};
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/xstream/XStreamWrapper", "serializeAndZipObject"));
        }
        return byArray;
    }

    @Nullable
    public static <T> T deserializeObject(@Nullable String xml, @NotNull XStreamHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObject"));
        }
        return XStreamWrapper.deserializeObjectInternal(xml, holder, null);
    }

    @Nullable
    public static <T> T deserializeObject(@NotNull ClassLoader classLoader, @Nullable String xml, @NotNull XStreamHolder holder) {
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObject"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObject"));
        }
        return XStreamWrapper.deserializeObjectInternal(xml, holder, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T deserializeObjectInternal(@Nullable String xml, @NotNull XStreamHolder holder, @Nullable ClassLoader classloader) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "deserializeObjectInternal"));
        }
        if (xml != null && xml.length() > 0) {
            XStream xStream = holder.getXStream(classloader);
            try {
                Object object = XStreamWrapper.fromXML(xStream, xml);
                return (T)object;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        return null;
    }

    @Nullable
    public static <T> T unzipAndDeserializeObject(@Nullable byte[] zipped, @NotNull XStreamHolder holder) throws IOException {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "unzipAndDeserializeObject"));
        }
        return XStreamWrapper.unzipAndDeserializedObjectInternal(zipped, holder, null);
    }

    @Nullable
    public static <T> T unzipAndDeserializeObject(@NotNull ClassLoader classLoader, @Nullable byte[] zipped, @NotNull XStreamHolder holder) throws IOException {
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "jetbrains/buildServer/xstream/XStreamWrapper", "unzipAndDeserializeObject"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "unzipAndDeserializeObject"));
        }
        return XStreamWrapper.unzipAndDeserializedObjectInternal(zipped, holder, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T unzipAndDeserializedObjectInternal(@Nullable byte[] zipped, @NotNull XStreamHolder holder, @Nullable ClassLoader classLoader) throws IOException {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "jetbrains/buildServer/xstream/XStreamWrapper", "unzipAndDeserializedObjectInternal"));
        }
        if (zipped != null && zipped.length > 0) {
            XStream xStream = holder.getXStream(classLoader);
            try {
                Object object;
                ByteArrayInputStream inBuffer = new ByteArrayInputStream(zipped);
                GZIPInputStream zipIn = new GZIPInputStream(inBuffer);
                InputStreamReader reader = new InputStreamReader((InputStream)zipIn, "UTF-8");
                try {
                    object = xStream.fromXML((Reader)reader);
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return (T)object;
            }
            finally {
                holder.releaseXStream(xStream);
            }
        }
        return null;
    }
}

