/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.ProcessTimeoutException;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.TimedExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineExecutor {
    @NotNull
    private static final TimedExecutor ourExecutor = TimedExecutor.withCachedThreadPool("CommandLineExecutor pooled thread", 0L);
    @NotNull
    private final ExecResult myRetVal;
    @NotNull
    private final GeneralCommandLine myCommandLine;
    private Process myProc;
    private StreamGobbler myErrorGobbler;
    private StreamGobbler myOutputGobbler;
    private OutputStream myOutputStream;
    private static final int TIMEOUT_DEF = 90;
    private static final int TIMEOUT_SECONDS = CommandLineExecutor.getTimeOutValue();
    private static final Logger LOG = Logger.getInstance((String)CommandLineExecutor.class.getName());

    private static int getTimeOutValue() {
        return TeamCityProperties.getInteger("teamcity.execution.timeout", 90);
    }

    public CommandLineExecutor(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "jetbrains/buildServer/CommandLineExecutor", "<init>"));
        }
        this.myRetVal = new ExecResult();
        this.myCommandLine = commandLine;
    }

    @Nullable
    public ExecResult runProcess(int executionTimeoutSeconds) throws ExecutionException {
        return ourExecutor.execute((long)executionTimeoutSeconds * 1000L, new Callable<ExecResult>(){

            @Override
            public ExecResult call() throws Exception {
                return CommandLineExecutor.this.runProcess();
            }
        });
    }

    @NotNull
    public ExecResult runProcess() throws ExecutionException {
        this.myProc = this.myCommandLine.createProcess();
        this.myErrorGobbler = new StreamGobbler(this.myProc.getErrorStream());
        this.myOutputGobbler = new StreamGobbler(this.myProc.getInputStream());
        this.myErrorGobbler.start();
        this.myOutputGobbler.start();
        ExecResult execResult = this.waitFor();
        if (execResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/CommandLineExecutor", "runProcess"));
        }
        return execResult;
    }

    public OutputStream getOutputStream() {
        if (this.myOutputStream == null) {
            this.myOutputStream = this.myProc.getOutputStream();
        }
        return this.myOutputStream;
    }

    @NotNull
    public ExecResult waitFor() {
        try {
            this.myRetVal.setExitCode(CommandLineExecutor.waitForProcess(this.myProc, this.myErrorGobbler, this.myOutputGobbler));
            this.myRetVal.setOutputGobbler(this.myOutputGobbler);
            this.myRetVal.setErrorGobbler(this.myErrorGobbler);
        }
        catch (Throwable e) {
            if (e instanceof ProcessTimeoutException) {
                ((ProcessTimeoutException)e).setProcessName(this.myCommandLine.getCommandLineString());
            }
            this.myRetVal.setException(e);
        }
        ExecResult execResult = this.myRetVal;
        if (execResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/CommandLineExecutor", "waitFor"));
        }
        return execResult;
    }

    public Process getProcess() {
        return this.myProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProcess() {
        this.myOutputGobbler.notifyProcessExit();
        this.myErrorGobbler.notifyProcessExit();
        try {
            FileUtil.closeAll(this.myProc.getInputStream(), this.myProc.getErrorStream(), this.myProc.getOutputStream());
        }
        finally {
            CommandLineExecutor.destroySilently(this.myProc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeAll(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        errorGobbler.notifyProcessExit();
        outputGobbler.notifyProcessExit();
        try {
            try {
                FileUtil.close(proc.getOutputStream());
                CommandLineExecutor.shutdownGobbler(outputGobbler, "stdout", proc.getInputStream());
            }
            finally {
                CommandLineExecutor.shutdownGobbler(errorGobbler, "stderr", proc.getErrorStream());
            }
        }
        finally {
            CommandLineExecutor.destroySilently(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownGobbler(StreamGobbler gobbler, String name, Closeable stream) throws InterruptedException {
        try {
            LOG.debug("Start waiting for " + name + " collector thread");
            gobbler.join();
            LOG.debug("Finished waiting for " + name + " collector thread");
        }
        finally {
            FileUtil.close(stream);
        }
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler) throws InterruptedException {
        return CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler, TIMEOUT_SECONDS);
    }

    public static int waitForProcess(Process proc, StreamGobbler errorGobbler, StreamGobbler outputGobbler, int idleTimeoutSeconds) throws InterruptedException {
        AtomicReference<Integer> result = new AtomicReference<Integer>();
        InterruptedException[] ex = new InterruptedException[1];
        LOG.debug("Start waiting for process finishing");
        Thread waitThread = CommandLineExecutor.createWaitForProcessThread(proc, errorGobbler, outputGobbler, result, ex);
        waitThread.start();
        long lastReadErr = errorGobbler.getLastActivityTimestamp();
        long lastReadOut = outputGobbler.getLastActivityTimestamp();
        while (true) {
            boolean hasNewOutput = false;
            for (int i = 0; i < 100; ++i) {
                try {
                    waitThread.join(idleTimeoutSeconds * 10);
                }
                catch (InterruptedException e) {
                    waitThread.interrupt();
                    throw e;
                }
                if (ex[0] != null) {
                    throw ex[0];
                }
                if (result.get() != null || (hasNewOutput = CommandLineExecutor.hasNewOutput(errorGobbler, outputGobbler, lastReadErr, lastReadOut))) break;
            }
            if (result.get() != null) break;
            if (!hasNewOutput) {
                CommandLineExecutor.destroySilently(proc);
                throw new ProcessTimeoutException("Timeout exception: the process did not produce output longer than " + idleTimeoutSeconds + " seconds");
            }
            lastReadErr = errorGobbler.getLastActivityTimestamp();
            lastReadOut = outputGobbler.getLastActivityTimestamp();
        }
        LOG.debug("Stop waiting for process finishing");
        return result.get();
    }

    private static void destroySilently(Process proc) {
        try {
            proc.destroy();
        }
        catch (Throwable e) {
            LOG.debug("Failed to destroy process: " + e.toString(), e);
        }
    }

    private static boolean hasNewOutput(StreamGobbler errorGobbler, StreamGobbler outputGobbler, long lastReadErr, long lastReadOut) {
        return lastReadErr != errorGobbler.getLastActivityTimestamp() || lastReadOut != outputGobbler.getLastActivityTimestamp();
    }

    private static Thread createWaitForProcessThread(final Process proc, final StreamGobbler errorGobbler, final StreamGobbler outputGobbler, final AtomicReference<Integer> result, final InterruptedException[] ex) {
        final String curThreadName = Thread.currentThread().getName();
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setName(NamedThreadUtil.getTcThreadPrefix() + "Wait for process: " + curThreadName);
                Integer execResult = null;
                try {
                    execResult = proc.waitFor();
                    LOG.debug("Process.waitFor() finished");
                }
                catch (InterruptedException e) {
                    LOG.warn("Failed to Process.waitFor(): " + e.getLocalizedMessage(), (Throwable)e);
                    ex[0] = e;
                }
                finally {
                    try {
                        CommandLineExecutor.finalizeAll(proc, errorGobbler, outputGobbler);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        result.set(execResult);
                    }
                }
            }
        });
    }
}

