/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.SAXParserFactory;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.SimpleObjectPool;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class TCNonValidatedSAXParser
implements Parser {
    private final Parser myDelegate = myPool.getFromPool();
    private static final SimpleObjectPool<Parser> myPool = new SimpleObjectPool<Parser>(new SimpleObjectPool.ObjectFactory<Parser>(){

        @Override
        @NotNull
        public Parser create() {
            Parser parser = TCNonValidatedSAXParser.createNewParser();
            if (parser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/TCNonValidatedSAXParser$1", "create"));
            }
            return parser;
        }
    }, Integer.parseInt(TeamCityProperties.getProperty("teamcity.xmlParser.poolSize", "100")));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String systemId) throws SAXException, IOException {
        try {
            this.myDelegate.parse(systemId);
        }
        finally {
            myPool.returnInPool(this.myDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            this.myDelegate.parse(inputSource);
        }
        finally {
            myPool.returnInPool(this.myDelegate);
        }
    }

    public void setLocale(Locale locale) throws SAXException {
        this.myDelegate.setLocale(locale);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.myDelegate.setEntityResolver(resolver);
    }

    public void setDTDHandler(DTDHandler handler) {
        this.myDelegate.setDTDHandler(handler);
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.myDelegate.setDocumentHandler(handler);
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.myDelegate.setErrorHandler(handler);
    }

    private static Parser createNewParser() {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setNamespaceAware(false);
            try {
                parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Exception e) {
                Loggers.XMLRPC.warn("Exception occurred during parser configuration: " + e.toString());
            }
            return parserFactory.newSAXParser().getParser();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowAsRuntimeException(e);
            return null;
        }
    }
}

