/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.XmlUtil;
import jetbrains.buildServer.vcs.CheckoutRules;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentCheckoutDirRevisionInfo {
    private final List<VcsRootInstanceState> myInstancesStates;
    private final String myCheckoutDirPath;
    private final Map<String, Long> myLastBuilds;
    private final String myVcsSettingsHash;

    public static AgentCheckoutDirRevisionInfo createEmptyState() {
        return new AgentCheckoutDirRevisionInfo();
    }

    @NotNull
    public static AgentCheckoutDirRevisionInfo parseXml(@NotNull Reader reader) throws IOException {
        AgentCheckoutDirRevisionInfo agentCheckoutDirRevisionInfo;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "parseXml"));
        }
        try {
            Element state = FileUtil.parseDocument(reader, false);
            String checkoutDirPath = state.getChild("CheckoutDirPath").getText();
            String vcsSettingsHash = state.getChild("VcsSettingsHash").getText();
            HashMap<String, Long> buildsMap = new HashMap<String, Long>();
            Element buildHistory = state.getChild("BuildHistory");
            if (buildHistory != null) {
                List builds = buildHistory.getChildren("Build");
                for (Object buildObj : builds) {
                    Element build = (Element)buildObj;
                    buildsMap.put(build.getChild("BuildTypeId").getText(), Long.parseLong(build.getChild("BuildId").getText()));
                }
            }
            AgentCheckoutDirRevisionInfo retval = new AgentCheckoutDirRevisionInfo(checkoutDirPath, vcsSettingsHash, buildsMap);
            List vcsRootsList = state.getChild("VcsRoots").getChildren("VcsRoot");
            for (Object elementObj : vcsRootsList) {
                Element vcsRoot = (Element)elementObj;
                retval.addVcsRootInstanceState(vcsRoot.getChild("Revision").getText(), vcsRoot.getChild("VcsRootSettings").getText(), new CheckoutRules(vcsRoot.getChild("CheckoutRules").getText()));
            }
            AgentCheckoutDirRevisionInfo agentCheckoutDirRevisionInfo2 = retval;
            agentCheckoutDirRevisionInfo = agentCheckoutDirRevisionInfo2;
        }
        catch (Exception e) {
            throw new IOException("An error occurred while trying to deserialize AgentCheckoutDirRevisionInfo", e);
        }
        finally {
            FileUtil.close(reader);
        }
        if (agentCheckoutDirRevisionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "parseXml"));
        }
        return agentCheckoutDirRevisionInfo;
    }

    private AgentCheckoutDirRevisionInfo() {
        this.myInstancesStates = Collections.emptyList();
        this.myCheckoutDirPath = "";
        this.myVcsSettingsHash = "";
        this.myLastBuilds = Collections.emptyMap();
    }

    private AgentCheckoutDirRevisionInfo(String checkoutDirPath, String vcsSettingsHash, Map<String, Long> lastBuilds) {
        this.myInstancesStates = new ArrayList<VcsRootInstanceState>();
        this.myCheckoutDirPath = checkoutDirPath;
        this.myVcsSettingsHash = vcsSettingsHash;
        this.myLastBuilds = lastBuilds;
    }

    public AgentCheckoutDirRevisionInfo(@NotNull File checkoutDir, @NotNull File agentWorkdir, @NotNull String vcsSettingsHash) {
        if (checkoutDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutDir", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (agentWorkdir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agentWorkdir", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (vcsSettingsHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettingsHash", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        this(FileUtil.getNameOrAbsolutePath(agentWorkdir, checkoutDir), vcsSettingsHash, new HashMap<String, Long>());
    }

    /*
     * WARNING - void declaration
     */
    public AgentCheckoutDirRevisionInfo(@NotNull AgentCheckoutDirRevisionInfo oldInfo, @NotNull String vcsSettingsHash, @NotNull String buildTypeId, long buildId, boolean bl) {
        void fullCheckout;
        if (oldInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInfo", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (vcsSettingsHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettingsHash", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (buildTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypeId", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        this(oldInfo.getCheckoutDirPath(), vcsSettingsHash, (Map<String, Long>)new HashMap<String, Long>((boolean)fullCheckout, vcsSettingsHash, oldInfo){
            final /* synthetic */ boolean val$fullCheckout;
            final /* synthetic */ String val$vcsSettingsHash;
            final /* synthetic */ AgentCheckoutDirRevisionInfo val$oldInfo;
            {
                this.val$fullCheckout = bl;
                this.val$vcsSettingsHash = string;
                this.val$oldInfo = agentCheckoutDirRevisionInfo;
                if (!this.val$fullCheckout && this.val$vcsSettingsHash.equals(this.val$oldInfo.getVcsSettingsHash())) {
                    this.putAll(this.val$oldInfo.myLastBuilds);
                }
            }
        });
        this.myLastBuilds.put(buildTypeId, buildId);
    }

    public List<VcsRootInstanceState> getInstancesStates() {
        return this.myInstancesStates;
    }

    public String getVcsSettingsHash() {
        return this.myVcsSettingsHash;
    }

    public long getLastBuildByType(@NotNull String buildTypeId) {
        if (buildTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypeId", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "getLastBuildByType"));
        }
        Long value = this.myLastBuilds.get(buildTypeId);
        return value == null ? 0L : value;
    }

    public long getFirstBuildId() {
        if (this.myLastBuilds.size() > 0) {
            return Collections.min(this.myLastBuilds.values());
        }
        return 0L;
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null ")
    public VcsRootInstanceState addVcsRootInstanceState(@Nullable String revision, @NotNull String vcsRootSettingsHash, @NotNull CheckoutRules checkoutRules) {
        if (vcsRootSettingsHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRootSettingsHash", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "addVcsRootInstanceState"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "addVcsRootInstanceState"));
        }
        if (revision == null) {
            return null;
        }
        VcsRootInstanceState instanceState = new VcsRootInstanceState(vcsRootSettingsHash, revision, checkoutRules);
        this.myInstancesStates.add(instanceState);
        return instanceState;
    }

    private Document getDocument() {
        try {
            Document document = new Document();
            Element state = new Element("CheckoutDirectoryState");
            document.setRootElement(state);
            state.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("VcsSettingsHash", this.getVcsSettingsHash()));
            state.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("CheckoutDirPath", this.getCheckoutDirPath()));
            Element buildHistory = new Element("BuildHistory");
            state.addContent(buildHistory);
            for (Map.Entry<String, Long> entry : this.myLastBuilds.entrySet()) {
                Element build = new Element("Build");
                build.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("BuildTypeId", entry.getKey()));
                build.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("BuildId", entry.getValue().toString()));
                buildHistory.addContent(build);
            }
            Element revisions = new Element("VcsRoots");
            state.addContent(revisions);
            for (VcsRootInstanceState instanceState : this.myInstancesStates) {
                Element revision = new Element("VcsRoot");
                revisions.addContent(revision);
                revision.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("VcsRootSettings", String.valueOf(instanceState.getVcsRootSignature())));
                revision.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("Revision", instanceState.getRevision()));
                revision.addContent(AgentCheckoutDirRevisionInfo.appendElementWithText("CheckoutRules", instanceState.getCheckoutRules().getAsString()));
            }
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred during serialization", e);
        }
    }

    public String serializeToXml() {
        return XmlUtil.toString(this.getDocument());
    }

    public void store(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "store"));
        }
        FileUtil.saveDocument(this.getDocument(), file);
    }

    @NotNull
    public String getCheckoutDirPath() {
        String string = this.myCheckoutDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "getCheckoutDirPath"));
        }
        return string;
    }

    public boolean isEmpty() {
        return this.myInstancesStates.size() == 0;
    }

    public Map<String, String> createRevisionsMap() {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (VcsRootInstanceState instancesState : this.myInstancesStates) {
            retval.put(instancesState.getVcsRootSignature(), instancesState.getRevision());
        }
        return retval;
    }

    public File getCheckoutDir(@NotNull File agentWorkDir) {
        if (agentWorkDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agentWorkDir", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "getCheckoutDir"));
        }
        if (FileUtil.isAbsolute((String)this.getCheckoutDirPath())) {
            return new File(this.getCheckoutDirPath());
        }
        return new File(agentWorkDir, this.getCheckoutDirPath());
    }

    private static Element appendElementWithText(String elementName, String elementValue) {
        return new Element(elementName).setText(elementValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentCheckoutDirRevisionInfo)) {
            return false;
        }
        AgentCheckoutDirRevisionInfo that = (AgentCheckoutDirRevisionInfo)o;
        if (!this.myCheckoutDirPath.equals(that.myCheckoutDirPath)) {
            return false;
        }
        if (!((Object)this.myInstancesStates).equals(that.myInstancesStates)) {
            return false;
        }
        if (!((Object)this.myLastBuilds).equals(that.myLastBuilds)) {
            return false;
        }
        return this.myVcsSettingsHash.equals(that.myVcsSettingsHash);
    }

    public int hashCode() {
        int result = ((Object)this.myInstancesStates).hashCode();
        result = 31 * result + this.myCheckoutDirPath.hashCode();
        result = 31 * result + ((Object)this.myLastBuilds).hashCode();
        result = 31 * result + this.myVcsSettingsHash.hashCode();
        return result;
    }

    public static class VcsRootInstanceState {
        private final String myVcsRootSignature;
        private final String myRevision;
        private final CheckoutRules myCheckoutRules;

        public VcsRootInstanceState(@NotNull String vcsRootSignature, @NotNull String revision, @NotNull CheckoutRules checkoutRules) {
            if (vcsRootSignature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRootSignature", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo$VcsRootInstanceState", "<init>"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo$VcsRootInstanceState", "<init>"));
            }
            if (checkoutRules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo$VcsRootInstanceState", "<init>"));
            }
            this.myVcsRootSignature = vcsRootSignature;
            this.myRevision = StringUtil.isEmpty((String)revision) ? null : revision;
            this.myCheckoutRules = checkoutRules;
        }

        public String getVcsRootSignature() {
            return this.myVcsRootSignature;
        }

        public String getRevision() {
            return this.myRevision;
        }

        public CheckoutRules getCheckoutRules() {
            return this.myCheckoutRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VcsRootInstanceState)) {
                return false;
            }
            VcsRootInstanceState that = (VcsRootInstanceState)o;
            if (!this.myVcsRootSignature.equals(that.myVcsRootSignature)) {
                return false;
            }
            if (!this.myCheckoutRules.getAsString().equals(that.myCheckoutRules.getAsString())) {
                return false;
            }
            return this.myRevision.equals(that.myRevision);
        }

        public int hashCode() {
            int result = this.myVcsRootSignature.hashCode();
            result = 31 * result + this.myRevision.hashCode();
            result = 31 * result + this.myCheckoutRules.hashCode();
            return result;
        }
    }
}

