/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.buildServer.agentServer.DetailsSerializationUtil;
import jetbrains.buildServer.util.XmlUtil;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentDetails {
    @NotNull
    private final String myAgentName;
    @Nullable
    private String myAgentAddress;
    private final int myAgentPort;
    private Integer myAgentId;
    @NotNull
    private String myAuthorizationToken;
    @NotNull
    private final String myPingCode;
    @Nullable
    private Long myBuildId;
    @Nullable
    private String myOsName;
    private final Collection<String> myAvailableRunners;
    private final Collection<String> myAvailableVcsPlugins;
    private final List<String> myAlternativeAddresses;
    private final Map<String, String> myConfigParameters;
    private final Map<String, String> myBuildParameters;
    private String myVersion;
    private String myPluginsVersion;

    public AgentDetails(@NotNull String agentName, @Nullable String agentAddress, int agentPort, @NotNull String authorizationToken, @NotNull String pingCode) {
        if (agentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agentName", "jetbrains/buildServer/agentServer/AgentDetails", "<init>"));
        }
        if (authorizationToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorizationToken", "jetbrains/buildServer/agentServer/AgentDetails", "<init>"));
        }
        if (pingCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pingCode", "jetbrains/buildServer/agentServer/AgentDetails", "<init>"));
        }
        this.myAvailableRunners = new ArrayList<String>();
        this.myAvailableVcsPlugins = new ArrayList<String>();
        this.myAlternativeAddresses = new ArrayList<String>();
        this.myConfigParameters = new TreeMap<String, String>();
        this.myBuildParameters = new TreeMap<String, String>();
        this.myVersion = "0";
        this.myPluginsVersion = "0";
        this.myAgentName = agentName;
        this.myAgentAddress = agentAddress;
        this.myAgentPort = agentPort;
        this.myAuthorizationToken = authorizationToken;
        this.myPingCode = pingCode;
    }

    public Integer getAgentId() {
        return this.myAgentId;
    }

    public void setAgentId(@Nullable Integer agentId) {
        this.myAgentId = agentId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    @NotNull
    public Map<String, String> getConfigParameters() {
        Map<String, String> map = Collections.unmodifiableMap(this.myConfigParameters);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getConfigParameters"));
        }
        return map;
    }

    @NotNull
    public Map<String, String> getBuildParameters() {
        Map<String, String> map = Collections.unmodifiableMap(this.myBuildParameters);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getBuildParameters"));
        }
        return map;
    }

    public void setConfigParameters(@NotNull Map<String, String> configParameters) {
        if (configParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configParameters", "jetbrains/buildServer/agentServer/AgentDetails", "setConfigParameters"));
        }
        this.myConfigParameters.clear();
        this.myConfigParameters.putAll(configParameters);
    }

    public void setBuildParameters(@NotNull Map<String, String> buildParameters) {
        if (buildParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildParameters", "jetbrains/buildServer/agentServer/AgentDetails", "setBuildParameters"));
        }
        this.myBuildParameters.clear();
        this.myBuildParameters.putAll(buildParameters);
    }

    @NotNull
    public List<String> getAlternativeAddresses() {
        List<String> list = this.myAlternativeAddresses;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getAlternativeAddresses"));
        }
        return list;
    }

    public void setAlternativeAddresses(@NotNull List<String> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addresses", "jetbrains/buildServer/agentServer/AgentDetails", "setAlternativeAddresses"));
        }
        this.myAlternativeAddresses.clear();
        this.myAlternativeAddresses.addAll(addresses);
    }

    @NotNull
    public String getAgentName() {
        String string = this.myAgentName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getAgentName"));
        }
        return string;
    }

    @Nullable
    public String getAgentAddress() {
        return this.myAgentAddress;
    }

    public void setAgentAddress(@Nullable String agentAddress) {
        this.myAgentAddress = agentAddress;
    }

    public int getAgentPort() {
        return this.myAgentPort;
    }

    @NotNull
    public String getAuthorizationToken() {
        String string = this.myAuthorizationToken;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getAuthorizationToken"));
        }
        return string;
    }

    public void setAuthorizationToken(@NotNull String authorizationToken) {
        if (authorizationToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorizationToken", "jetbrains/buildServer/agentServer/AgentDetails", "setAuthorizationToken"));
        }
        this.myAuthorizationToken = authorizationToken;
    }

    public void setServerInferredAgentAddress(@NotNull String address) {
        if (address == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "address", "jetbrains/buildServer/agentServer/AgentDetails", "setServerInferredAgentAddress"));
        }
        this.myAlternativeAddresses.remove(address);
        this.myAlternativeAddresses.add(0, address);
    }

    @NotNull
    public String getPingCode() {
        String string = this.myPingCode;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getPingCode"));
        }
        return string;
    }

    @Nullable
    public String getOsName() {
        return this.myOsName;
    }

    public int getCpuBenchmarkIndex() {
        try {
            String index = this.getBuildParameters().get("system.teamcity.agent.cpuBenchmark");
            return index == null ? -1 : Integer.parseInt(index);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setOsName(@Nullable String osName) {
        this.myOsName = osName;
    }

    @NotNull
    public String getAgentVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getAgentVersion"));
        }
        return string;
    }

    public void setAgentVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "jetbrains/buildServer/agentServer/AgentDetails", "setAgentVersion"));
        }
        this.myVersion = version;
    }

    @NotNull
    public String getPluginsVersion() {
        String string = this.myPluginsVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getPluginsVersion"));
        }
        return string;
    }

    public void setPluginsVersion(@NotNull String pluginsVersion) {
        if (pluginsVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginsVersion", "jetbrains/buildServer/agentServer/AgentDetails", "setPluginsVersion"));
        }
        this.myPluginsVersion = pluginsVersion;
    }

    @Nullable
    public Long getBuildId() {
        return this.myBuildId;
    }

    public void setBuildId(@Nullable Long buildId) {
        this.myBuildId = buildId;
    }

    @NotNull
    public Collection<String> getAvailableRunners() {
        Collection<String> collection = this.myAvailableRunners;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getAvailableRunners"));
        }
        return collection;
    }

    public void setAvailableRunners(@NotNull Collection<String> availableRunners) {
        if (availableRunners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableRunners", "jetbrains/buildServer/agentServer/AgentDetails", "setAvailableRunners"));
        }
        this.myAvailableRunners.clear();
        this.myAvailableRunners.addAll(availableRunners);
    }

    @NotNull
    public Collection<String> getAvailableVcsPlugins() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myAvailableVcsPlugins);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "getAvailableVcsPlugins"));
        }
        return collection;
    }

    public void setAvailableVcsPlugins(@NotNull Collection<String> available) {
        if (available == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "available", "jetbrains/buildServer/agentServer/AgentDetails", "setAvailableVcsPlugins"));
        }
        this.myAvailableVcsPlugins.clear();
        this.myAvailableVcsPlugins.addAll(available);
    }

    public String serializeToOldString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        try {
            XmlUtil.saveDocument(this.serializeToDocument(), bos);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return bos.toString();
    }

    public String serializeToString() {
        try {
            return DetailsSerializationUtil.saveDocument(this.serializeToDocument());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document serializeToDocument() {
        Element rootElement = new Element("agentDetails");
        Document document = new Document(rootElement);
        rootElement.setAttribute("agentName", this.myAgentName);
        if (this.myAgentAddress != null) {
            rootElement.setAttribute("agentAddress", this.myAgentAddress);
        }
        rootElement.setAttribute("agentPort", String.valueOf(this.myAgentPort));
        rootElement.setAttribute("authToken", this.myAuthorizationToken);
        rootElement.setAttribute("pingCode", this.myPingCode);
        if (this.myBuildId != null) {
            rootElement.setAttribute("buildId", this.myBuildId.toString());
        }
        if (this.myAgentId != null) {
            rootElement.setAttribute("agentId", this.myAgentId.toString());
        }
        Element alternativeAddresses = new Element("alternativeAddresses");
        for (String address : this.myAlternativeAddresses) {
            Element el = new Element("address");
            el.setText(address);
            alternativeAddresses.addContent((Content)el);
        }
        rootElement.addContent((Content)alternativeAddresses);
        Element runners = new Element("availableRunners");
        for (String runner : this.myAvailableRunners) {
            Element runnerEl = new Element("runner");
            runnerEl.setAttribute("runType", runner);
            runners.addContent((Content)runnerEl);
        }
        rootElement.addContent((Content)runners);
        Element vcs = new Element("availableVcs");
        for (String runner : this.myAvailableVcsPlugins) {
            Element runnerEl = new Element("vcs");
            runnerEl.setAttribute("name", runner);
            vcs.addContent((Content)runnerEl);
        }
        rootElement.addContent((Content)vcs);
        AgentDetails.mapToElement(this.myBuildParameters, "buildParameters", rootElement);
        AgentDetails.mapToElement(this.myConfigParameters, "configParameters", rootElement);
        if (this.myOsName != null) {
            rootElement.setAttribute("osName", this.myOsName);
        }
        if (this.myVersion != null || this.myPluginsVersion != null) {
            Element version = new Element("version");
            AgentDetails.saveAttribute(version, "agent", this.myVersion);
            AgentDetails.saveAttribute(version, "plugins", this.myPluginsVersion);
            rootElement.addContent((Content)version);
        }
        return document;
    }

    private static void saveAttribute(Element rootElement, String key, String tok) {
        if (tok != null) {
            rootElement.setAttribute(key, tok);
        }
    }

    @NotNull
    public static AgentDetails deserializeFromOldString(@NotNull String serialized) {
        AgentDetails agentDetails;
        if (serialized == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serialized", "jetbrains/buildServer/agentServer/AgentDetails", "deserializeFromOldString"));
        }
        try {
            agentDetails = AgentDetails.deserializeString(new String(serialized.getBytes("UTF-8"), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (agentDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "deserializeFromOldString"));
        }
        return agentDetails;
    }

    @NotNull
    public static AgentDetails deserializeString(@NotNull String serialized) {
        AgentDetails agentDetails;
        if (serialized == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serialized", "jetbrains/buildServer/agentServer/AgentDetails", "deserializeString"));
        }
        try {
            agentDetails = AgentDetails.deserializeFromDocument(DetailsSerializationUtil.loadDocument(serialized));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (agentDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "deserializeString"));
        }
        return agentDetails;
    }

    private static AgentDetails deserializeFromDocument(Document doc) {
        Element altAddresses;
        String agentIdStr;
        Element rootElem = doc.getRootElement();
        AgentDetails ad = new AgentDetails(rootElem.getAttributeValue("agentName"), rootElem.getAttributeValue("agentAddress"), Integer.parseInt(rootElem.getAttributeValue("agentPort")), rootElem.getAttributeValue("authToken"), StringUtil.notNullize((String)rootElem.getAttributeValue("pingCode")));
        String buildIdStr = rootElem.getAttributeValue("buildId");
        if (buildIdStr != null) {
            ad.setBuildId(Long.parseLong(buildIdStr));
        }
        if ((agentIdStr = rootElem.getAttributeValue("agentId")) != null) {
            ad.setAgentId(Integer.parseInt(agentIdStr));
        }
        if ((altAddresses = rootElem.getChild("alternativeAddresses")) != null) {
            ArrayList<String> alternativeAddresses = new ArrayList<String>();
            for (Object o : altAddresses.getChildren("address")) {
                Element el = (Element)o;
                alternativeAddresses.add(el.getTextTrim());
            }
            ad.setAlternativeAddresses(alternativeAddresses);
        }
        Element availableRunners = rootElem.getChild("availableRunners");
        ArrayList<String> runners = new ArrayList<String>();
        if (availableRunners != null) {
            for (Object r : availableRunners.getChildren("runner")) {
                Element runnerEl = (Element)r;
                runners.add(runnerEl.getAttributeValue("runType"));
            }
        }
        ad.setAvailableRunners(runners);
        Element availableVcs = rootElem.getChild("availableVcs");
        ArrayList<String> vcses = new ArrayList<String>();
        if (availableVcs != null) {
            for (Object r : availableVcs.getChildren("vcs")) {
                Element runnerEl = (Element)r;
                vcses.add(runnerEl.getAttributeValue("name"));
            }
        }
        ad.setAvailableVcsPlugins(vcses);
        ad.setOsName(rootElem.getAttributeValue("osName"));
        Map<String, String> buildParameters = AgentDetails.elementToMap(rootElem, "buildParameters");
        Map<String, String> configParameters = AgentDetails.elementToMap(rootElem, "configParameters");
        if (buildParameters.size() == 0 && configParameters.size() == 0) {
            TreeMap<String, String> allMap = new TreeMap<String, String>();
            allMap.putAll(AgentDetails.elementToMap(rootElem, "definedParameters"));
            allMap.putAll(AgentDetails.elementToMap(rootElem, "availableParameters"));
            for (Map.Entry entry : allMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.startsWith("system.") || key.startsWith("env.")) {
                    buildParameters.put(key, value);
                    continue;
                }
                configParameters.put(key, value);
            }
        }
        ad.setBuildParameters(buildParameters);
        ad.setConfigParameters(configParameters);
        Element version = rootElem.getChild("version");
        if (version == null) {
            ad.setAgentVersion("pre5.0");
            ad.setPluginsVersion("pre5.0");
        } else {
            ad.setAgentVersion(version.getAttributeValue("agent"));
            ad.setPluginsVersion(version.getAttributeValue("plugins"));
        }
        return ad;
    }

    private static void mapToElement(@NotNull Map<String, String> map, @NotNull String elementName, @NotNull Element rootElement) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/agentServer/AgentDetails", "mapToElement"));
        }
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "jetbrains/buildServer/agentServer/AgentDetails", "mapToElement"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "jetbrains/buildServer/agentServer/AgentDetails", "mapToElement"));
        }
        Element definedParams = new Element(elementName);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            XmlUtil.writeParameter(definedParams, entry.getKey(), entry.getValue());
        }
        rootElement.addContent((Content)definedParams);
    }

    @NotNull
    private static Map<String, String> elementToMap(@NotNull Element rootElem, @NotNull String elementName) {
        if (rootElem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElem", "jetbrains/buildServer/agentServer/AgentDetails", "elementToMap"));
        }
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "jetbrains/buildServer/agentServer/AgentDetails", "elementToMap"));
        }
        Element availableParams = rootElem.getChild(elementName);
        TreeMap<String, String> availableParamsMap = new TreeMap<String, String>();
        if (availableParams != null) {
            for (Object p : availableParams.getChildren("param")) {
                Element paramEl = (Element)p;
                Pair<String, String> param = XmlUtil.readParameter(paramEl);
                availableParamsMap.put((String)param.getFirst(), (String)param.getSecond());
            }
        }
        TreeMap<String, String> treeMap = availableParamsMap;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentDetails", "elementToMap"));
        }
        return treeMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AgentDetails");
        sb.append("{Name='").append(this.myAgentName).append('\'');
        sb.append(", AgentId=").append(this.myAgentId);
        sb.append(", BuildId=").append(this.myBuildId);
        sb.append(", AgentOwnAddress='").append(this.myAgentAddress).append('\'');
        sb.append(", AlternativeAddresses=").append(this.myAlternativeAddresses);
        sb.append(", Port=").append(this.myAgentPort);
        sb.append(", Version='").append(this.myVersion).append('\'');
        sb.append(", PluginsVersion='").append(this.myPluginsVersion).append('\'');
        sb.append(", AvailableRunners=").append(this.myAvailableRunners);
        sb.append(", AvailableVcs=").append(this.myAvailableVcsPlugins);
        sb.append(", AuthorizationToken='").append(this.myAuthorizationToken).append('\'');
        sb.append(", PingCode='").append(this.myPingCode).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentDetails that = (AgentDetails)o;
        if (this.myAgentPort != that.myAgentPort) {
            return false;
        }
        if (this.myAgentAddress != null ? !this.myAgentAddress.equals(that.myAgentAddress) : that.myAgentAddress != null) {
            return false;
        }
        if (this.myAgentId != null ? !this.myAgentId.equals(that.myAgentId) : that.myAgentId != null) {
            return false;
        }
        if (!this.myAgentName.equals(that.myAgentName)) {
            return false;
        }
        if (!((Object)this.myAlternativeAddresses).equals(that.myAlternativeAddresses)) {
            return false;
        }
        if (!this.myAuthorizationToken.equals(that.myAuthorizationToken)) {
            return false;
        }
        if (!((Object)this.myAvailableRunners).equals(that.myAvailableRunners)) {
            return false;
        }
        if (!((Object)this.myAvailableVcsPlugins).equals(that.myAvailableVcsPlugins)) {
            return false;
        }
        if (this.myBuildId != null ? !this.myBuildId.equals(that.myBuildId) : that.myBuildId != null) {
            return false;
        }
        if (!((Object)this.myBuildParameters).equals(that.myBuildParameters)) {
            return false;
        }
        if (!((Object)this.myConfigParameters).equals(that.myConfigParameters)) {
            return false;
        }
        if (this.myOsName != null ? !this.myOsName.equals(that.myOsName) : that.myOsName != null) {
            return false;
        }
        if (!this.myPingCode.equals(that.myPingCode)) {
            return false;
        }
        if (this.myPluginsVersion != null ? !this.myPluginsVersion.equals(that.myPluginsVersion) : that.myPluginsVersion != null) {
            return false;
        }
        return !(this.myVersion == null ? that.myVersion != null : !this.myVersion.equals(that.myVersion));
    }

    public int hashCode() {
        int result = this.myAgentName.hashCode();
        result = 31 * result + (this.myAgentAddress != null ? this.myAgentAddress.hashCode() : 0);
        result = 31 * result + this.myAgentPort;
        result = 31 * result + (this.myAgentId != null ? this.myAgentId.hashCode() : 0);
        result = 31 * result + this.myAuthorizationToken.hashCode();
        result = 31 * result + this.myPingCode.hashCode();
        result = 31 * result + (this.myBuildId != null ? this.myBuildId.hashCode() : 0);
        result = 31 * result + (this.myOsName != null ? this.myOsName.hashCode() : 0);
        result = 31 * result + ((Object)this.myAvailableRunners).hashCode();
        result = 31 * result + ((Object)this.myAvailableVcsPlugins).hashCode();
        result = 31 * result + ((Object)this.myAlternativeAddresses).hashCode();
        result = 31 * result + ((Object)this.myConfigParameters).hashCode();
        result = 31 * result + ((Object)this.myBuildParameters).hashCode();
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myPluginsVersion != null ? this.myPluginsVersion.hashCode() : 0);
        return result;
    }
}

