/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import java.io.File;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.agentServer.RemoteFileStructureUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileStructure {
    private static final long FETCHED_DIRECTORY_SIZE = -1L;
    private static final long NOT_FETCHED_DIRECTORY_SIZE = -2L;
    private final String myFullRemoteName;
    private long mySize;
    private List<RemoteFileStructure> myChildren;
    private RemoteFileStructureUpdater myRemoteUpdater;

    public RemoteFileStructure(@NotNull String fullRemoteName, @Nullable List<RemoteFileStructure> children, long size) {
        if (fullRemoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRemoteName", "jetbrains/buildServer/agentServer/RemoteFileStructure", "<init>"));
        }
        this.myFullRemoteName = fullRemoteName;
        this.mySize = size;
        this.myChildren = children;
    }

    @NotNull
    public static RemoteFileStructure createForFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/agentServer/RemoteFileStructure", "createForFile"));
        }
        RemoteFileStructure remoteFileStructure = new RemoteFileStructure(file.getAbsolutePath(), null, file.length());
        if (remoteFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "createForFile"));
        }
        return remoteFileStructure;
    }

    @NotNull
    public static RemoteFileStructure createForFetchedDirectory(@NotNull File directory, @NotNull List<RemoteFileStructure> children) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "jetbrains/buildServer/agentServer/RemoteFileStructure", "createForFetchedDirectory"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "jetbrains/buildServer/agentServer/RemoteFileStructure", "createForFetchedDirectory"));
        }
        RemoteFileStructure remoteFileStructure = new RemoteFileStructure(directory.getAbsolutePath(), children, -1L);
        if (remoteFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "createForFetchedDirectory"));
        }
        return remoteFileStructure;
    }

    public static RemoteFileStructure createForNotFetchedDirectory(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "jetbrains/buildServer/agentServer/RemoteFileStructure", "createForNotFetchedDirectory"));
        }
        return new RemoteFileStructure(directory.getAbsolutePath(), null, -2L);
    }

    @NotNull
    public String getFullRemoteName() {
        String string = this.myFullRemoteName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "getFullRemoteName"));
        }
        return string;
    }

    public long getSize() {
        return this.mySize;
    }

    public boolean isDirectory() {
        return this.mySize < 0L;
    }

    @NotNull
    public List<RemoteFileStructure> getChildren() {
        if (!this.isDirectory()) {
            List<RemoteFileStructure> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "getChildren"));
            }
            return list;
        }
        if (this.mySize == -1L) {
            List<RemoteFileStructure> list = this.myChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "getChildren"));
            }
            return list;
        }
        if (this.mySize == -2L) {
            assert (this.myRemoteUpdater != null);
            List<RemoteFileStructure> children = this.myRemoteUpdater.getChildren(this.myFullRemoteName);
            this.myChildren = children;
            this.mySize = -1L;
            List<RemoteFileStructure> list = children;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "getChildren"));
            }
            return list;
        }
        List<RemoteFileStructure> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/RemoteFileStructure", "getChildren"));
        }
        return list;
    }

    public void setRemoteUpdater(@NotNull RemoteFileStructureUpdater remoteUpdater) {
        if (remoteUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUpdater", "jetbrains/buildServer/agentServer/RemoteFileStructure", "setRemoteUpdater"));
        }
        this.myRemoteUpdater = remoteUpdater;
    }
}

