/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import jetbrains.buildServer.agentServer.StringTreeMap;

class StringTreeMapConverter
implements Converter {
    StringTreeMapConverter() {
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        StringTreeMap map = (StringTreeMap)source;
        for (Map.Entry e : map.entrySet()) {
            writer.startNode("k");
            writer.setValue((String)e.getKey());
            writer.endNode();
            writer.startNode("v");
            writer.setValue((String)e.getValue());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        StringTreeMap map = new StringTreeMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String key = reader.getValue();
            reader.moveUp();
            reader.moveDown();
            String val = reader.getValue();
            reader.moveUp();
            map.put(key, val);
        }
        return map;
    }

    public boolean canConvert(Class type) {
        return StringTreeMap.class.isAssignableFrom(type);
    }
}

