/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.ChangeProvider;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.executors.ExecutorsFactory;
import org.jetbrains.annotations.NotNull;

public class ChangeObserver {
    private static final Logger LOG = Logger.getInstance((String)"jetbrains.buildServer.ChangeObserver");
    private static volatile ScheduledExecutorService ourScheduler;
    private final EventDispatcher<ChangeListener> myListeners = EventDispatcher.create(ChangeListener.class);
    private final List<ChangeProvider> myWatchers = new ArrayList<ChangeProvider>();
    private final AtomicBoolean myStopped = new AtomicBoolean(true);
    private final AtomicInteger myDisabledCounter = new AtomicInteger(0);
    private String myLastRequestor;
    private long mySleepingPeriod;
    private boolean mySkipListenersNotification;
    private boolean myChangesDetected;

    public ChangeObserver(long intervalForCheckingsMsecs) {
        if (ourScheduler == null || ourScheduler.isShutdown() && LogInitializer.isUnitTest()) {
            ourScheduler = ExecutorsFactory.newFixedScheduledDaemonExecutor("Change Observer", 1);
        }
        this.mySleepingPeriod = intervalForCheckingsMsecs;
    }

    public void registerListener(ChangeListener listener) {
        this.myListeners.addListener(listener);
    }

    public void unregisterListener(ChangeListener listener) {
        this.myListeners.removeListener(listener);
    }

    public void registerChangeProvider(ChangeProvider provider) {
        this.myWatchers.add(provider);
    }

    public void unregisterChangeProvider(ChangeProvider provider) {
        this.myWatchers.remove(provider);
    }

    public void start() {
        this.myStopped.set(false);
        this.myDisabledCounter.set(0);
        this.scheduleMe();
    }

    public void stop() {
        this.myStopped.set(true);
    }

    public static void shutdownAll() {
        ScheduledExecutorService scheduler = ourScheduler;
        if (scheduler != null) {
            scheduler.shutdownNow();
            try {
                scheduler.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    public void setSleepingPeriod(long time) {
        this.mySleepingPeriod = time;
    }

    public long getSleepingPeriod() {
        return this.mySleepingPeriod;
    }

    public void clear() {
        this.myListeners.dispose();
        this.myWatchers.clear();
    }

    public void clearListeners() {
        this.myListeners.dispose();
    }

    public synchronized void setSkipListenersNotification(boolean value) {
        this.mySkipListenersNotification = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runActionWithDisabledObserver(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "jetbrains/buildServer/configuration/ChangeObserver", "runActionWithDisabledObserver"));
        }
        this.myDisabledCounter.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            int count = this.myDisabledCounter.decrementAndGet();
            if (count == 0) {
                this.detectChanges();
                this.resetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkForModifications() {
        boolean changesDetected = this.detectChanges();
        if (changesDetected) {
            this.myChangesDetected = true;
            if (this.mySkipListenersNotification) {
                this.resetChanged();
                return;
            }
        }
        if (this.myChangesDetected) {
            try {
                this.myListeners.getMulticaster().changeOccured(this.myLastRequestor);
            }
            finally {
                try {
                    this.resetChanged();
                }
                finally {
                    this.myLastRequestor = null;
                    this.myChangesDetected = false;
                }
            }
        }
    }

    private void scheduleMe() {
        ScheduledExecutorService scheduler = ourScheduler;
        assert (scheduler != null);
        try {
            scheduler.schedule(new Runnable(){

                public void run() {
                    try {
                        if (ChangeObserver.this.myStopped.get()) {
                            return;
                        }
                        if (ChangeObserver.this.myDisabledCounter.get() == 0) {
                            ChangeObserver.this.checkForModifications();
                        }
                        ChangeObserver.this.scheduleMe();
                    }
                    catch (Throwable t) {
                        LOG.warn("Change observer task failed: " + t.getMessage(), t);
                    }
                }
            }, this.mySleepingPeriod, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            LOG.info(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
        }
    }

    private void resetChanged() {
        ChangeProvider[] watchers;
        for (ChangeProvider watcher : watchers = this.myWatchers.toArray(new ChangeProvider[this.myWatchers.size()])) {
            watcher.resetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectChanges() {
        boolean result = false;
        ChangeProvider[] watchers = this.myWatchers.toArray(new ChangeProvider[this.myWatchers.size()]);
        int i = 0;
        for (ChangeProvider watcher : watchers) {
            Disposable patchedThreadName = NamedThreadFactory.patchThreadName("Processing watcher" + (watchers.length > 1 ? " " + ++i + "/" + watchers.length : "") + ": " + watcher);
            try {
                if (!watcher.changesDetected()) continue;
                result = true;
                this.myLastRequestor = watcher.getRequestor();
            }
            finally {
                patchedThreadName.dispose();
            }
        }
        return result;
    }
}

