/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import java.io.File;
import jetbrains.buildServer.configuration.ChangeObserver;
import jetbrains.buildServer.configuration.ChangeProvider;
import jetbrains.buildServer.configuration.WatchedFileState;

public class FileWatcher
extends ChangeObserver
implements ChangeProvider {
    private final File myFile;
    private WatchedFileState myWatchedFileState;

    public FileWatcher(File file) {
        super(10000L);
        this.myFile = file;
        this.myWatchedFileState = new WatchedFileState(file);
        this.registerChangeProvider(this);
    }

    public boolean changesDetected() {
        return this.myWatchedFileState.isChanged(this.myFile);
    }

    public void resetChanged() {
        this.myWatchedFileState = new WatchedFileState(this.myFile);
    }

    public String getRequestor() {
        return "FileWatcher";
    }

    public File getFile() {
        return this.myFile;
    }

    public String toString() {
        return "File watcher for " + (this.myFile != null ? this.myFile.getPath() : "null");
    }
}

