/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.configuration.WatchedFileState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesState {
    private final Map<String, WatchedFileState> myFilesState = new HashMap<String, WatchedFileState>();
    private final List<File> myNewFiles = new ArrayList<File>();
    private final List<File> myRemovedFiles = new ArrayList<File>();
    private final List<File> myModifiedFiles = new ArrayList<File>();

    public void resetState(File ... watchedFiles) {
        this.clearDetectedChanges();
        this.myFilesState.clear();
        this.addToState(watchedFiles);
    }

    void addToState(File ... watchedFiles) {
        for (File watchedFile : watchedFiles) {
            this.myFilesState.put(watchedFile.getAbsolutePath(), new WatchedFileState(watchedFile));
        }
    }

    public boolean computeChanges(File[] files) {
        this.clearDetectedChanges();
        HashSet<String> filesPaths = new HashSet<String>();
        for (File file : files) {
            boolean updateState = false;
            if (!this.myFilesState.containsKey(file.getAbsolutePath())) {
                this.myNewFiles.add(file);
                updateState = true;
            } else {
                WatchedFileState watchedFile = this.myFilesState.get(file.getAbsolutePath());
                if (watchedFile.isCreated(file)) {
                    this.myNewFiles.add(file);
                    updateState = true;
                } else if (watchedFile.isChanged(file)) {
                    this.myModifiedFiles.add(file);
                    updateState = true;
                }
            }
            if (updateState) {
                this.addToState(file);
            }
            filesPaths.add(file.getAbsolutePath());
        }
        for (String path : this.myFilesState.keySet()) {
            if (filesPaths.contains(path)) continue;
            this.myRemovedFiles.add(new File(path));
        }
        for (File removed : this.myRemovedFiles) {
            this.myFilesState.remove(removed.getAbsolutePath());
        }
        return this.myNewFiles.size() > 0 || this.myRemovedFiles.size() > 0 || this.myModifiedFiles.size() > 0;
    }

    public Map<String, WatchedFileState> getFilesState() {
        return this.myFilesState;
    }

    public List<File> getNewFiles() {
        return Collections.unmodifiableList(new ArrayList<File>(this.myNewFiles));
    }

    public List<File> getRemovedFiles() {
        return Collections.unmodifiableList(new ArrayList<File>(this.myRemovedFiles));
    }

    public List<File> getModifiedFiles() {
        return Collections.unmodifiableList(new ArrayList<File>(this.myModifiedFiles));
    }

    public void clearDetectedChanges() {
        this.myNewFiles.clear();
        this.myRemovedFiles.clear();
        this.myModifiedFiles.clear();
    }
}

