/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.configuration;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jetbrains.buildServer.configuration.ChangeObserver;
import jetbrains.buildServer.configuration.ChangeProvider;
import jetbrains.buildServer.configuration.FilesState;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesWatcher
extends ChangeObserver
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance((String)FilesWatcher.class.getName());
    private FilesState myFilesState;
    private final WatchedFilesProvider myFilesProvider;

    public FilesWatcher(WatchedFilesProvider filesProvider) {
        super(10000L);
        this.myFilesProvider = filesProvider;
        this.registerChangeProvider(this);
        this.resetState();
    }

    private void resetState() {
        try {
            this.myFilesState = new FilesState();
            this.myFilesState.addToState(this.myFilesProvider.getWatchedFiles());
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean changesDetected() {
        this.myFilesState.clearDetectedChanges();
        try {
            File[] watchedFiles = this.myFilesProvider.getWatchedFiles();
            return this.myFilesState.computeChanges(watchedFiles);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
            return false;
        }
    }

    public List<File> getNewFiles() {
        return this.myFilesState.getNewFiles();
    }

    public List<File> getRemovedFiles() {
        return this.myFilesState.getRemovedFiles();
    }

    public List<File> getModifiedFiles() {
        return this.myFilesState.getModifiedFiles();
    }

    @Override
    public synchronized void resetChanged() {
    }

    @Override
    public String getRequestor() {
        return "FilesWatcher";
    }

    public String toString() {
        return "Files watcher for " + (this.myFilesProvider != null ? this.myFilesProvider.toString() : "null");
    }

    public static interface WatchedFilesProvider {
        @NotNull
        public File[] getWatchedFiles() throws IOException;
    }
}

