/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMapDecorator<TK, TV, TC extends Collection<TV>> {
    protected final Map<TK, TC> myMap;

    public MultiMapDecorator(@NotNull Map<TK, TC> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "<init>"));
        }
        this.myMap = map;
    }

    public void add(TK key, TV value) {
        this.getValuesInternal(key).add(value);
    }

    public void addEmpty(TK key) {
        this.getValuesInternal(key);
    }

    @NotNull
    public Collection<TV> getValues(TK key) {
        Collection collection = Collections.unmodifiableCollection(this.getValuesInternal(key));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "getValues"));
        }
        return collection;
    }

    public boolean containsKey(TK key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public Set<TK> keySet() {
        Set<TK> set = this.myMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "keySet"));
        }
        return set;
    }

    @NotNull
    public Collection<TC> values() {
        Collection<TC> collection = this.myMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "values"));
        }
        return collection;
    }

    @NotNull
    public Set<Map.Entry<TK, TC>> entrySet() {
        Set<Map.Entry<TK, TC>> set = this.myMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "entrySet"));
        }
        return set;
    }

    public int size() {
        return this.myMap.size();
    }

    public int valuesSize() {
        int cnt = 0;
        for (Collection futures : this.values()) {
            cnt += futures.size();
        }
        return cnt;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public void removeKey(TK key) {
        this.myMap.remove(key);
    }

    public void removeValue(TV v) {
        for (Collection tc : this.myMap.values()) {
            tc.remove(v);
        }
    }

    @NotNull
    private TC getValuesInternal(TK key) {
        Collection<Object> list = (Collection)this.myMap.get(key);
        if (list == null) {
            list = this.createEmptyCollection();
            this.myMap.put(key, list);
        }
        Collection collection = list;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "getValuesInternal"));
        }
        return (TC)collection;
    }

    public void addAll(TK key, @NotNull Collection<? extends TV> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "addAll"));
        }
        TC list = this.getValuesInternal(key);
        list.addAll(values);
    }

    public void addAll(@NotNull MultiMapDecorator<TK, TV, TC> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/dataStructures/MultiMapDecorator", "addAll"));
        }
        for (Map.Entry<TK, TC> entry : map.myMap.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    @NotNull
    protected abstract TC createEmptyCollection();
}

