/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import java.io.IOException;
import jetbrains.buildServer.http.CustomSSLProtocolSocketFactory;
import jetbrains.buildServer.http.HttpUtil;
import jetbrains.buildServer.http.SimpleCredentials;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpResourceValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceAvailable(@NotNull String url, @Nullable SimpleCredentials credentials) throws IOException {
        URI uri;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "jetbrains/buildServer/http/HttpResourceValidator", "testResourceAvailable"));
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            return;
        }
        try {
            uri = new URI(url, false);
        }
        catch (URIException e) {
            throw new IOException("Invalid URL: " + url, e);
        }
        HttpClient client = HttpUtil.createHttpClient(TeamCityProperties.getInteger("teamcity.httpUrlValidator.connectionTimeoutSecs", 30));
        UsernamePasswordCredentials cre = null;
        if (credentials != null) {
            cre = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
        }
        String host = uri.getHost();
        String pathQuery = uri.getPathQuery();
        if (cre != null) {
            client.getParams().setAuthenticationPreemptive(true);
            HttpState state = new HttpState();
            state.setCredentials(new AuthScope(host, uri.getPort()), (Credentials)cre);
            client.setState(state);
        }
        HostConfiguration hc = new HostConfiguration();
        hc.setHost(host, uri.getPort());
        if ("https".equals(uri.getScheme())) {
            Protocol httpsProto = new Protocol("https", (ProtocolSocketFactory)new CustomSSLProtocolSocketFactory(), 443);
            hc.setHost(host, uri.getPort(), httpsProto);
        }
        HeadMethod method = new HeadMethod(pathQuery);
        try {
            int response;
            method.setFollowRedirects(false);
            try {
                response = client.executeMethod(hc, (HttpMethod)method);
            }
            catch (IOException e) {
                throw new IOException("Failed to connect to the server using the specified URL, error: " + e.toString());
            }
            if (response == 401) {
                throw new IOException("Failed to connect to the server using the specified URL: authentication failed");
            }
        }
        finally {
            method.releaseConnection();
        }
    }
}

