/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtil {
    @NotNull
    public static HttpClient createHttpClient(int connectionTimeoutSeconds, @Nullable URL url, @Nullable Credentials credentials) {
        HttpClient httpClient = HttpUtil.createHttpClient(connectionTimeoutSeconds, url, credentials, true);
        if (httpClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/http/HttpUtil", "createHttpClient"));
        }
        return httpClient;
    }

    @NotNull
    public static HttpClient createHttpClient(int connectionTimeoutSeconds, @Nullable URL url, @Nullable Credentials credentials, boolean isBasicAuth) {
        HttpClient client = HttpUtil.createHttpClient(connectionTimeoutSeconds);
        if (url != null && credentials != null) {
            if (isBasicAuth) {
                client.getParams().setAuthenticationPreemptive(true);
            }
            HttpState state = new HttpState();
            state.setCredentials(new AuthScope(url.getHost(), url.getPort()), credentials);
            client.setState(state);
        }
        HttpClient httpClient = client;
        if (httpClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/http/HttpUtil", "createHttpClient"));
        }
        return httpClient;
    }

    @NotNull
    public static HttpClient createHttpClient(int connectionTimeoutSeconds) {
        HttpClient client = new HttpClient();
        client.getParams().setVersion(HttpVersion.HTTP_1_1);
        int timeoutMillis = 1000 * connectionTimeoutSeconds;
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(timeoutMillis);
        params.setSoTimeout(timeoutMillis);
        HttpClient httpClient = client;
        if (httpClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/http/HttpUtil", "createHttpClient"));
        }
        return httpClient;
    }

    public static String composeHttpErrorMessage(StatusLine status, String errorMessagePrefix) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(errorMessagePrefix).append(" Server status: ").append(status.getStatusCode());
        if (status.getReasonPhrase() != null && status.getReasonPhrase().length() > 0) {
            logMessage.append(" (").append(status.getReasonPhrase()).append(")");
        }
        return logMessage.toString();
    }
}

