/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import jetbrains.buildServer.http.HttpUtil;
import jetbrains.buildServer.util.Interruptable;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jetbrains.annotations.NotNull;

public class ServerStreamProvider
implements Interruptable {
    protected volatile HttpMethodBase myMethod;
    private final String myUri;
    private String myUserId;
    private String myPassword;
    private int myConnectionTimeout = 0;
    private boolean myUseProxy = false;
    private String myProxyHost = null;
    private int myProxyPort = -1;
    private volatile boolean myInterrupted = false;

    public ServerStreamProvider(String uri) {
        this.myUri = uri;
    }

    public void setCredentials(String userId, String password) {
        this.myUserId = userId;
        this.myPassword = password;
    }

    public void setProxySettings(boolean useProxy, String proxyHost, int proxyPort) {
        this.myUseProxy = useProxy;
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.myConnectionTimeout = connectionTimeout;
    }

    public void abort() {
        if (this.myMethod != null) {
            this.myMethod.abort();
            this.myMethod = null;
        }
    }

    public void dispose() {
        if (this.myMethod != null) {
            this.myMethod.releaseConnection();
            this.myMethod = null;
        }
    }

    public InputStream getStream() throws IOException {
        return this.getStream(null);
    }

    public InputStream getStream(String postData) throws IOException {
        URL serverURL = new URL(this.myUri);
        UsernamePasswordCredentials cre = null;
        if (this.myUserId != null && this.myPassword != null) {
            cre = new UsernamePasswordCredentials(this.myUserId, this.myPassword);
        }
        HttpClient client = HttpUtil.createHttpClient(this.myConnectionTimeout, serverURL, cre);
        if (this.myUseProxy) {
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(this.myUri);
            hostConfiguration.setProxy(this.myProxyHost, this.myProxyPort);
            client.setHostConfiguration(hostConfiguration);
        }
        this.myMethod = postData != null ? new PostMethod(this.myUri) : new GetMethod(this.myUri);
        this.myMethod.addRequestHeader(new Header("Accept-encoding", "gzip"));
        this.myMethod.setDoAuthentication(true);
        try {
            if (postData != null) {
                ((PostMethod)this.myMethod).setRequestEntity((RequestEntity)new StringRequestEntity(postData, null, "utf-8"));
            }
            client.executeMethod((HttpMethod)this.myMethod);
            StatusLine status = this.myMethod.getStatusLine();
            if (status.getStatusCode() != 200) {
                throw new IOException(HttpUtil.composeHttpErrorMessage(status, "Failed to obtain stream from server."));
            }
            return this.doGetStream(this.myMethod);
        }
        catch (IOException e) {
            this.myMethod.releaseConnection();
            this.myMethod = null;
            throw e;
        }
    }

    private InputStream doGetStream(HttpMethodBase method) throws IOException {
        Header contentTypeHeader = method.getResponseHeader("content-encoding");
        if (contentTypeHeader != null && "gzip".equals(contentTypeHeader.getValue())) {
            return new GZIPInputStream(this.wrapStream(method.getResponseBodyAsStream()));
        }
        return this.wrapStream(method.getResponseBodyAsStream());
    }

    private InputStream wrapStream(final @NotNull InputStream original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "jetbrains/buildServer/http/ServerStreamProvider", "wrapStream"));
        }
        return new InputStream(){

            public int read() throws IOException {
                ServerStreamProvider.this.checkInterrupted();
                return original.read();
            }
        };
    }

    public void interrupt() {
        this.myInterrupted = true;
        this.abort();
    }

    private void checkInterrupted() throws IOException {
        if (this.myInterrupted) {
            this.dispose();
            throw new InterruptedIOException("Operation interrupted");
        }
    }
}

