/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class ErrorData {
    public static final String UPDATE_SOURCES_TYPE = "UPDATE_SOURCES";
    public static final String CHECKING_FOR_CHANGES_ERROR_TYPE = "CHECKING_FOR_CHANGES_ERROR";
    public static final String ARTIFACT_DEPENDENCY_ERROR_TYPE = "ARTIFACT_DEPENDENCY_ERROR";
    public static final String SNAPSHOT_DEPENDENCY_ERROR_TYPE = "SNAPSHOT_DEPENDENCY_ERROR";
    public static final String PREPARATION_FAILURE_TYPE = "PREPARATION_FAILURE_TYPE";
    public static final String DIRECTORY_CREATION_ERROR_TYPE = "DIRECTORY_CREATION_ERROR";
    public static final String BUILD_RUNNER_ERROR_TYPE = "BUILD_RUNNER_ERROR";
    public static final String UNKNOWN_TYPE = "UNKNOWN";
    public static final String SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE = "SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE";
    public static final Map TYPE_DESCRIPTIONS = new HashMap(){
        {
            this.put(ErrorData.UPDATE_SOURCES_TYPE, "Error while applying patch");
            this.put(ErrorData.CHECKING_FOR_CHANGES_ERROR_TYPE, "Unable to collect changes");
            this.put(ErrorData.ARTIFACT_DEPENDENCY_ERROR_TYPE, "Artifacts resolving failed");
            this.put(ErrorData.SNAPSHOT_DEPENDENCY_ERROR_TYPE, "Snapshot dependency failure");
            this.put(ErrorData.SNAPSHOT_DEPENDENCY_ERROR_BUILD_PROCEEDS_TYPE, "Snapshot dependency failure");
            this.put(ErrorData.PREPARATION_FAILURE_TYPE, "Failed to start build");
            this.put(ErrorData.DIRECTORY_CREATION_ERROR_TYPE, "Failed to create a directory");
            this.put(ErrorData.BUILD_RUNNER_ERROR_TYPE, "Cannot start build runner");
        }
    };
    public String stackTrace;
    public String localizedMessage;
    public String type = "UNKNOWN";

    public ErrorData(Throwable th) {
        this.stackTrace = ErrorData.toTrace(th);
        String msg = th.getLocalizedMessage();
        this.localizedMessage = msg != null ? th.getClass().getName() + ": " + msg : th.getClass().getName();
    }

    public ErrorData(Throwable th, String localizedMessage, String type) {
        this(ErrorData.toTrace(th), localizedMessage, type);
    }

    public ErrorData(String stackTrace, String localizedMessage, String type) {
        this.stackTrace = stackTrace;
        this.localizedMessage = localizedMessage;
        this.type = type != null ? type : UNKNOWN_TYPE;
    }

    private static String toTrace(Throwable th) {
        if (th == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        th.printStackTrace(writer);
        writer.close();
        return stringWriter.toString();
    }

    public boolean isInternalError() {
        return ErrorData.isInternalError(this.type);
    }

    public static boolean isInternalError(String type) {
        return UPDATE_SOURCES_TYPE.equals(type) || CHECKING_FOR_CHANGES_ERROR_TYPE.equals(type) || ARTIFACT_DEPENDENCY_ERROR_TYPE.equals(type) || SNAPSHOT_DEPENDENCY_ERROR_TYPE.equals(type) || PREPARATION_FAILURE_TYPE.equals(type) || DIRECTORY_CREATION_ERROR_TYPE.equals(type) || BUILD_RUNNER_ERROR_TYPE.equals(type);
    }

    public String toString() {
        return "ErrorData{type='" + this.type + '\'' + ", localizedMessage='" + this.localizedMessage + '\'' + ", stackTrace='" + this.stackTrace + '\'' + '}';
    }
}

