/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jetbrains.buildServer.messages.serviceMessages.BlockClosed;
import jetbrains.buildServer.messages.serviceMessages.BlockOpened;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.CompilationFinished;
import jetbrains.buildServer.messages.serviceMessages.CompilationStarted;
import jetbrains.buildServer.messages.serviceMessages.InternalErrorMessage;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.RequiredAttribute;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestNavigationInfo;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessage {
    @NotNull
    public static final String SERVICE_MESSAGE_START = "##teamcity[";
    public static final String TAGS_SEPARATOR = ",";
    @NonNls
    public static final String ENABLE = "enableServiceMessages";
    @NonNls
    public static final String DISABLE = "disableServiceMessages";
    private static final String RESERVED_ATTRIBUTE_PREFIX = "tc:";
    public static final String ARG_ATTRIBUTE = "tc:arg";
    public static final String TAGS_ATRRIBUTE = "tc:tags";
    @NotNull
    private static final String SERVICE_MESSAGE_END = "]";
    @NotNull
    private static final String FORMAT_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    @NotNull
    private static final String FORMAT_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int FORMAT_WITHOUT_TZ_LEN = "yyyy-MM-dd'T'HH:mm:ss.SSS".replace("'", "").length();
    @NotNull
    private static final Map<String, Class<? extends ServiceMessage>> SERVICE_MESSAGE_CLASSES = new HashMap<String, Class<? extends ServiceMessage>>();
    @NotNull
    private String myMessageName;
    @NotNull
    private final Map<String, String> myAttributes;
    @Nullable
    private String myArgument;
    @Nullable
    private Timestamp myCreationTimestamp;
    @Nullable
    private String myFlowId;
    @NotNull
    private List<String> myTags;

    ServiceMessage() {
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
    }

    protected ServiceMessage(@NotNull String messageName) {
        if (messageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageName", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "<init>"));
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
    }

    protected ServiceMessage(@NotNull String messageName, @Nullable String argument) {
        if (messageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageName", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "<init>"));
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
        this.myArgument = argument;
    }

    protected ServiceMessage(@NotNull String messageName, @NotNull Map<String, String> attributes) {
        if (messageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageName", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "<init>"));
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
        try {
            this.populateAttributes(attributes);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text) throws ParseException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "parse"));
        }
        if (text.startsWith(SERVICE_MESSAGE_START) && text.endsWith(SERVICE_MESSAGE_END)) {
            return ServiceMessage.doParse(text.substring(SERVICE_MESSAGE_START.length(), text.length() - SERVICE_MESSAGE_END.length()).trim());
        }
        return null;
    }

    public static void parse(@NotNull String mixedText, @NotNull ServiceMessageParserCallback parserCallback) {
        if (mixedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mixedText", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "parse"));
        }
        if (parserCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserCallback", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "parse"));
        }
        for (Pair<String, Boolean> parsed : ServiceMessage.splitTextToServiceMessagesAndRegularText(mixedText)) {
            if (parsed.getSecond().booleanValue()) {
                try {
                    parserCallback.serviceMessage(ServiceMessage.doParse(parsed.getFirst()));
                }
                catch (ParseException e) {
                    parserCallback.parseException(e, ServiceMessage.appendPrefixAndSuffix(parsed.getFirst()));
                }
                continue;
            }
            parserCallback.regularText(parsed.getFirst());
        }
    }

    @Deprecated
    @NotNull
    public static List<String> splitTextToPotentialMessages(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "splitTextToPotentialMessages"));
        }
        List<Pair<String, Boolean>> pairs = ServiceMessage.splitTextToServiceMessagesAndRegularText(text);
        ArrayList<String> result = new ArrayList<String>();
        for (Pair<String, Boolean> pair : pairs) {
            String body = pair.getFirst();
            result.add(pair.getSecond() != false ? ServiceMessage.appendPrefixAndSuffix(body) : body);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "splitTextToPotentialMessages"));
        }
        return arrayList;
    }

    private static boolean isReservedName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "isReservedName"));
        }
        return name.startsWith(RESERVED_ATTRIBUTE_PREFIX) && MapSerializerUtil.isValidJavaIdentifier(name.substring(RESERVED_ATTRIBUTE_PREFIX.length()));
    }

    @NotNull
    public String getMessageName() {
        String string = this.myMessageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "getMessageName"));
        }
        return string;
    }

    @Nullable
    public String getArgument() {
        return this.myArgument;
    }

    @Nullable
    public Timestamp getCreationTimestamp() {
        return this.myCreationTimestamp;
    }

    @Nullable
    public String getFlowId() {
        return this.myFlowId;
    }

    @NotNull
    public Collection<String> getTags() {
        List<String> list = this.myTags;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "getTags"));
        }
        return list;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Map<String, String> map = Collections.unmodifiableMap(this.myAttributes);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "getAttributes"));
        }
        return map;
    }

    public void visit(@NotNull ServiceMessageVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "visit"));
        }
        visitor.visitServiceMessage(this);
    }

    public void setTimestamp(@NotNull Date timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestamp", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "setTimestamp"));
        }
        this.myAttributes.put("timestamp", new SimpleDateFormat(FORMAT_WITH_TZ).format(timestamp));
        this.myCreationTimestamp = new Timestamp(timestamp, true);
    }

    public void setFlowId(@NotNull String flowId) {
        if (flowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowId", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "setFlowId"));
        }
        this.myAttributes.put("flowId", flowId);
        this.myFlowId = flowId;
    }

    @Nullable
    protected String getAttributeValue(@NotNull String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "getAttributeValue"));
        }
        return this.getAttributes().get(attrName);
    }

    @NotNull
    private static List<Pair<String, Boolean>> splitTextToServiceMessagesAndRegularText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "splitTextToServiceMessagesAndRegularText"));
        }
        ArrayList<Pair<String, Boolean>> pairs = new ArrayList<Pair<String, Boolean>>();
        int currentIndex = 0;
        while (currentIndex < text.length()) {
            int messageStartPos = text.indexOf(SERVICE_MESSAGE_START, currentIndex);
            if (messageStartPos == -1) {
                ServiceMessage.addMessageToListIfNotEmpty(pairs, text.substring(currentIndex), false);
                ArrayList<Pair<String, Boolean>> arrayList = pairs;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "splitTextToServiceMessagesAndRegularText"));
                }
                return arrayList;
            }
            int messageEndPos = ServiceMessage.findMessageEnd(text, messageStartPos);
            if (messageEndPos == -1) {
                ServiceMessage.addMessageToListIfNotEmpty(pairs, text.substring(currentIndex), false);
                ArrayList<Pair<String, Boolean>> arrayList = pairs;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "splitTextToServiceMessagesAndRegularText"));
                }
                return arrayList;
            }
            ServiceMessage.addMessageToListIfNotEmpty(pairs, text.substring(currentIndex, messageStartPos), false);
            ServiceMessage.addMessageToListIfNotEmpty(pairs, text.substring(messageStartPos + SERVICE_MESSAGE_START.length(), messageEndPos - SERVICE_MESSAGE_END.length()).trim(), true);
            currentIndex = messageEndPos;
        }
        ArrayList<Pair<String, Boolean>> arrayList = pairs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "splitTextToServiceMessagesAndRegularText"));
        }
        return arrayList;
    }

    private void parseArgument(@Nullable String argumentsStr) throws ParseException {
        this.myArgument = argumentsStr == null ? null : ServiceMessage.stringToText(argumentsStr);
    }

    private void parseAttributes(@Nullable String argumentsStr) throws ParseException {
        this.reset();
        if (argumentsStr != null) {
            Map<String, String> parsedAttributes = MapSerializerUtil.stringToProperties(argumentsStr, MapSerializerUtil.STD_ESCAPER2, false);
            for (String attrName : parsedAttributes.keySet()) {
                if (ServiceMessage.isReservedName(attrName) || MapSerializerUtil.isValidJavaIdentifier(attrName)) continue;
                throw new ParseException("Invalid attribute name: " + attrName, 0);
            }
            this.populateAttributes(parsedAttributes);
        }
    }

    private void populateAttributes(Map<String, String> attributes) throws ParseException {
        this.myAttributes.putAll(attributes);
        if (this.myAttributes.containsKey(ARG_ATTRIBUTE)) {
            this.myArgument = this.myAttributes.get(ARG_ATTRIBUTE);
            this.myAttributes.remove(ARG_ATTRIBUTE);
        }
        if (this.myAttributes.containsKey(TAGS_ATRRIBUTE)) {
            String tagsStr = this.myAttributes.get(TAGS_ATRRIBUTE);
            this.myTags = ServiceMessage.splitTags(tagsStr);
            this.myAttributes.remove(TAGS_ATRRIBUTE);
        }
        this.parseCreationTimestamp();
        this.parseFlowId();
    }

    private void reset() {
        this.myAttributes.clear();
        this.myCreationTimestamp = null;
        this.myFlowId = null;
        this.myTags = Collections.emptyList();
        this.myArgument = null;
    }

    private static List<String> splitTags(String tagsStr) {
        StringTokenizer tok = new StringTokenizer(tagsStr, TAGS_SEPARATOR);
        ArrayList<String> result = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken().trim());
        }
        return Collections.unmodifiableList(result);
    }

    private void parseFlowId() {
        this.myFlowId = this.getAttributeValue("flowId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCreationTimestamp() throws ParseException {
        String creationTimestampStr = this.getAttributeValue("timestamp");
        if (creationTimestampStr == null) {
            this.myCreationTimestamp = null;
            return;
        }
        creationTimestampStr = creationTimestampStr.replace("'T'", "T");
        ServiceMessage serviceMessage = this;
        synchronized (serviceMessage) {
            this.myCreationTimestamp = creationTimestampStr.length() == FORMAT_WITHOUT_TZ_LEN ? new Timestamp(new SimpleDateFormat(FORMAT_WITHOUT_TZ).parse(creationTimestampStr), false) : new Timestamp(new SimpleDateFormat(FORMAT_WITH_TZ).parse(creationTimestampStr), true);
        }
    }

    private static int indexOfAnyWhitespace(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "indexOfAnyWhitespace"));
        }
        char[] charArray = text.toCharArray();
        int charArrayLength = charArray.length;
        for (int i = 0; i < charArrayLength; ++i) {
            char ch = charArray[i];
            if (!Character.isWhitespace(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static ServiceMessage doParse(@NotNull String text) throws ParseException {
        ServiceMessage serviceMessage;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "doParse"));
        }
        int sepIndex = ServiceMessage.indexOfAnyWhitespace(text);
        String key = sepIndex == -1 ? text : text.substring(0, sepIndex);
        String argumentsStr = sepIndex == -1 ? null : text.substring(sepIndex).trim();
        Class<? extends ServiceMessage> clazz = SERVICE_MESSAGE_CLASSES.get(key);
        if (clazz == null) {
            clazz = ServiceMessage.class;
        }
        try {
            ServiceMessage msg = clazz.newInstance();
            msg.init(key, argumentsStr);
            msg.validate();
            serviceMessage = msg;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (serviceMessage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "doParse"));
        }
        return serviceMessage;
    }

    protected void validate() throws ParseException {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            RequiredAttribute required = method.getAnnotation(RequiredAttribute.class);
            if (required == null) continue;
            try {
                Object invoke = method.invoke((Object)this, new Object[0]);
                if (invoke != null) continue;
                throw new ParseException("Attribute '" + required.attributeName() + "' is not specified in service message {" + this.toString() + "}", 0);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String appendPrefixAndSuffix(String text) {
        return SERVICE_MESSAGE_START + text + SERVICE_MESSAGE_END;
    }

    private static void addMessageToListIfNotEmpty(@NotNull List<Pair<String, Boolean>> pairs, @NotNull String message, boolean isServiceMessage) {
        if (pairs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "addMessageToListIfNotEmpty"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "addMessageToListIfNotEmpty"));
        }
        if (message.length() != 0) {
            pairs.add(Pair.create(message, isServiceMessage));
        }
    }

    private static int findMessageEnd(@NotNull String text, int messageStartPos) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "findMessageEnd"));
        }
        int pos = messageStartPos;
        while ((pos = text.indexOf(SERVICE_MESSAGE_END, pos + 1)) != -1 && text.charAt(pos - 1) == MapSerializerUtil.STD_ESCAPER2.escapeCharacter()) {
        }
        return pos == -1 ? -1 : pos + 1;
    }

    @NotNull
    private static String stringToText(@NotNull String message) throws ParseException {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "stringToText"));
        }
        if ((message = message.trim()).startsWith("'") && message.endsWith("'") && message.length() >= 2) {
            String string = MapSerializerUtil.unescapeStr(message.substring(1, message.length() - 1), MapSerializerUtil.STD_ESCAPER2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "stringToText"));
            }
            return string;
        }
        throw new ParseException("Cannot extract text message [" + message + SERVICE_MESSAGE_END, 0);
    }

    private void init(@NotNull String key, @Nullable String argumentsStr) throws ParseException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "init"));
        }
        this.myMessageName = key;
        if (argumentsStr != null && argumentsStr.trim().startsWith("'")) {
            this.parseArgument(argumentsStr);
        } else {
            this.parseAttributes(argumentsStr);
        }
    }

    @NotNull
    public String asString() {
        if (this.myArgument != null && this.myTags.isEmpty()) {
            String string = ServiceMessage.asString(this.myMessageName, this.myArgument);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
            }
            return string;
        }
        LinkedHashMap<String, String> fullAttrMap = new LinkedHashMap<String, String>();
        if (this.myArgument != null) {
            fullAttrMap.put(ARG_ATTRIBUTE, this.myArgument);
        }
        if (!this.myTags.isEmpty()) {
            StringBuilder tagsStr = new StringBuilder();
            for (String tag : this.myTags) {
                if (tagsStr.length() > 0) {
                    tagsStr.append(TAGS_SEPARATOR);
                }
                tagsStr.append(tag);
            }
            fullAttrMap.put(TAGS_ATRRIBUTE, tagsStr.toString());
        }
        fullAttrMap.putAll(this.myAttributes);
        String string = ServiceMessage.asString(this.myMessageName, fullAttrMap);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        return string;
    }

    @NotNull
    public static String asString(@NotNull String messageName, @NotNull Map<String, String> attributes) {
        if (messageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageName", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        StringBuilder text = new StringBuilder();
        ServiceMessage.appendMessageName(text, messageName);
        if (!attributes.isEmpty()) {
            text.append(' ');
            text.append(MapSerializerUtil.propertiesToString(attributes, MapSerializerUtil.STD_ESCAPER2));
        }
        text.append(SERVICE_MESSAGE_END);
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        return string;
    }

    @NotNull
    public static String asString(@NotNull String messageName, @NotNull String argument) {
        if (messageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageName", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        StringBuilder text = new StringBuilder();
        ServiceMessage.appendMessageName(text, messageName);
        text.append(" '");
        text.append(MapSerializerUtil.escapeStr(argument, MapSerializerUtil.STD_ESCAPER2));
        text.append("'");
        text.append(SERVICE_MESSAGE_END);
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessage", "asString"));
        }
        return string;
    }

    private static void appendMessageName(StringBuilder target, String messageName) {
        target.append(SERVICE_MESSAGE_START);
        target.append(messageName);
    }

    public String toString() {
        return this.asString();
    }

    static {
        SERVICE_MESSAGE_CLASSES.put("progressMessage", ProgressMessage.class);
        SERVICE_MESSAGE_CLASSES.put("progressStart", ProgressStart.class);
        SERVICE_MESSAGE_CLASSES.put("progressFinish", ProgressFinish.class);
        SERVICE_MESSAGE_CLASSES.put("publishArtifacts", PublishArtifacts.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteStarted", TestSuiteStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testSuiteFinished", TestSuiteFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testStarted", TestStarted.class);
        SERVICE_MESSAGE_CLASSES.put("testFailed", TestFailed.class);
        SERVICE_MESSAGE_CLASSES.put("testFinished", TestFinished.class);
        SERVICE_MESSAGE_CLASSES.put("testIgnored", TestIgnored.class);
        SERVICE_MESSAGE_CLASSES.put("testStdOut", TestStdOut.class);
        SERVICE_MESSAGE_CLASSES.put("testStdErr", TestStdErr.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatus", BuildStatus.class);
        SERVICE_MESSAGE_CLASSES.put("buildNumber", BuildNumber.class);
        SERVICE_MESSAGE_CLASSES.put("buildStatisticValue", BuildStatisticValue.class);
        SERVICE_MESSAGE_CLASSES.put("testNavigationInfo", TestNavigationInfo.class);
        SERVICE_MESSAGE_CLASSES.put("blockOpened", BlockOpened.class);
        SERVICE_MESSAGE_CLASSES.put("blockClosed", BlockClosed.class);
        SERVICE_MESSAGE_CLASSES.put("compilationStarted", CompilationStarted.class);
        SERVICE_MESSAGE_CLASSES.put("compilationFinished", CompilationFinished.class);
        SERVICE_MESSAGE_CLASSES.put("message", Message.class);
        SERVICE_MESSAGE_CLASSES.put("internalError", InternalErrorMessage.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<T1, T2> {
        private final T1 myFirst;
        private final T2 mySecond;

        private Pair(T1 first, T2 second) {
            this.myFirst = first;
            this.mySecond = second;
        }

        public T1 getFirst() {
            return this.myFirst;
        }

        public T2 getSecond() {
            return this.mySecond;
        }

        public static <T1, T2> Pair<T1, T2> create(T1 first, T2 second) {
            return new Pair<T1, T2>(first, second);
        }
    }

    public static class Timestamp {
        private final Date myTimestamp;
        private final boolean myTimeZoneWasSpecified;

        public Date getTimestamp() {
            return this.myTimestamp;
        }

        public boolean isTimeZoneSpecified() {
            return this.myTimeZoneWasSpecified;
        }

        public Timestamp(Date timestamp, boolean timeZoneWasSpecified) {
            this.myTimestamp = timestamp;
            this.myTimeZoneWasSpecified = timeZoneWasSpecified;
        }
    }
}

