/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.parameters.GradualParametersProvider;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.impl.CompositeParametersProviderImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradualParametersProviderImpl
implements GradualParametersProvider {
    private final List<ParametersProvider> myProviders = new ArrayList<ParametersProvider>();
    private int myProviderIndex = 0;

    public void addProvider(@NotNull ParametersProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "jetbrains/buildServer/parameters/GradualParametersProviderImpl", "addProvider"));
        }
        this.myProviders.add(provider);
    }

    @Nullable
    public ParametersProvider getNextParametersProvider() {
        if (this.myProviderIndex >= this.myProviders.size()) {
            return null;
        }
        CompositeParametersProviderImpl composite = new CompositeParametersProviderImpl();
        for (int i = 0; i <= this.myProviderIndex; ++i) {
            composite.appendParametersProvider(this.myProviders.get(i));
        }
        ++this.myProviderIndex;
        return composite;
    }

    public boolean hasNextParametersProvider() {
        return this.myProviderIndex < this.myProviders.size();
    }
}

