/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ValueResolver;
import jetbrains.buildServer.parameters.impl.ParametersResolverUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterBasedValueResolver
implements ValueResolver {
    @NotNull
    private final ParameterResolver myResolver;
    @NotNull
    private final ParametersProvider myDictionary;

    public ParameterBasedValueResolver(@NotNull ParameterResolver resolver, @NotNull ParametersProvider dictionary) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "<init>"));
        }
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "<init>"));
        }
        this.myResolver = resolver;
        this.myDictionary = dictionary;
    }

    @Override
    @NotNull
    public ProcessingResult resolve(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "resolve"));
        }
        ProcessingResult processingResult = this.doResolve(Collections.singletonList(value), this.myDictionary).get(0);
        if (processingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "resolve"));
        }
        return processingResult;
    }

    @Override
    @NotNull
    public Map<String, String> resolve(@NotNull Map<String, String> unresolved) {
        if (unresolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolved", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "resolve"));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        LinkedHashMap<String, String> toResolve = new LinkedHashMap<String, String>(unresolved);
        List<ProcessingResult> resolved = this.doResolve(new ArrayList<String>(toResolve.values()), this.myDictionary);
        int idx = 0;
        for (String key : toResolve.keySet()) {
            result.put(key, resolved.get(idx++).getResult());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "resolve"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public Map<String, ProcessingResult> resolveWithDetails(@NotNull Map<String, String> unresolved) {
        if (unresolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolved", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "resolveWithDetails"));
        }
        HashMap<String, ProcessingResult> result = new HashMap<String, ProcessingResult>();
        LinkedHashMap<String, String> toResolve = new LinkedHashMap<String, String>(unresolved);
        List<ProcessingResult> resolved = this.doResolve(new ArrayList<String>(toResolve.values()), this.myDictionary);
        int idx = 0;
        for (String key : toResolve.keySet()) {
            result.put(key, resolved.get(idx++));
        }
        HashMap<String, ProcessingResult> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "resolveWithDetails"));
        }
        return hashMap;
    }

    @NotNull
    protected List<ProcessingResult> doResolve(@NotNull List<String> toResolve, @NotNull ParametersProvider dictionary) {
        if (toResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toResolve", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "doResolve"));
        }
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "doResolve"));
        }
        List<ProcessingResult> list = ParametersResolverUtil.resolveValues(toResolve, dictionary, this.myResolver);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ParameterBasedValueResolver", "doResolve"));
        }
        return list;
    }
}

