/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesResolverUtil {
    private static final char REF_MARKER_CHAR = '%';
    private static final char NEW_LINE_SYMBOL = '\n';

    @NotNull
    public static String makeReference(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "makeReference"));
        }
        String string = '%' + propertyName + '%';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "makeReference"));
        }
        return string;
    }

    public static void resolve(@NotNull String value, @NotNull ReferencesResolverListener listener) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "resolve"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "resolve"));
        }
        if (value.length() <= 1) {
            listener.appendText(value);
            return;
        }
        int refStart = value.indexOf(37);
        if (refStart == -1) {
            listener.appendText(value);
            return;
        }
        if (refStart > 0) {
            listener.appendText(value.substring(0, refStart));
        }
        CharBuffer textBuf = new CharBuffer(value.length() - refStart);
        CharBuffer refBuf = new CharBuffer(value.length() - refStart);
        char[] valueToProcess = value.substring(refStart).toCharArray();
        boolean refStarted = false;
        for (int idx = 0; idx < valueToProcess.length; ++idx) {
            String refKey;
            int start = idx;
            while (idx < valueToProcess.length && valueToProcess[idx] != '%' && valueToProcess[idx] != '\n') {
                ++idx;
            }
            if (idx < valueToProcess.length && valueToProcess[idx] == '\n') {
                if (refStarted) {
                    textBuf.append('%');
                }
                refStarted = false;
                textBuf.append(valueToProcess, start, idx - start);
                textBuf.append('\n');
                continue;
            }
            if (idx > start) {
                if (refStarted) {
                    refBuf.append(valueToProcess, start, idx - start);
                } else {
                    textBuf.append(valueToProcess, start, idx - start);
                }
            }
            if (idx >= valueToProcess.length) break;
            if (!refStarted) {
                if (idx + 1 < valueToProcess.length && valueToProcess[idx + 1] == '%') {
                    textBuf.append('%');
                    textBuf.append('%');
                    ++idx;
                    refStarted = false;
                } else if (idx + 2 < valueToProcess.length) {
                    refStarted = true;
                } else {
                    textBuf.append('%');
                    refStarted = false;
                }
            } else {
                refStarted = false;
            }
            if (!(refBuf.isEmpty() || refStarted || listener.appendReference(refKey = refBuf.flush()))) {
                listener.appendText(String.valueOf('%'));
                listener.appendText(refKey);
                listener.appendText(String.valueOf('%'));
            }
            if (textBuf.isEmpty() || !refStarted) continue;
            listener.appendText(textBuf.flush());
        }
        if (!refBuf.isEmpty()) {
            listener.appendText(String.valueOf('%'));
            listener.appendText(refBuf.flush());
        }
        if (!textBuf.isEmpty()) {
            listener.appendText(textBuf.flush());
        }
    }

    @NotNull
    public static String unescape(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "unescape"));
        }
        CharBuffer result = new CharBuffer(value.length());
        char[] valueArr = value.toCharArray();
        for (int i = 0; i < valueArr.length; ++i) {
            char c = valueArr[i];
            if (c != '%') {
                result.append(c);
                continue;
            }
            if (i + 1 < valueArr.length && valueArr[i + 1] == '%') {
                result.append(c);
                ++i;
                continue;
            }
            result.append(c);
        }
        String string = result.flush();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "unescape"));
        }
        return string;
    }

    public static boolean containsReference(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "containsReference"));
        }
        return ReferencesResolverUtil.containsReference(value, new String[0], false);
    }

    public static boolean containsReference(@NotNull String value, final @NotNull String[] prefixes, final boolean allowSpaces) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "containsReference"));
        }
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "containsReference"));
        }
        final boolean[] hasRefs = new boolean[]{false};
        ReferencesResolverUtil.resolve(value, new ReferencesResolverListener(){

            public void appendText(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/parameters/ReferencesResolverUtil$1", "appendText"));
                }
            }

            public boolean appendReference(@NotNull String referenceKey) {
                if (referenceKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceKey", "jetbrains/buildServer/parameters/ReferencesResolverUtil$1", "appendReference"));
                }
                if (!allowSpaces && referenceKey.indexOf(32) != -1) {
                    return false;
                }
                boolean validRef = prefixes.length == 0;
                for (String prefix : prefixes) {
                    if (!referenceKey.startsWith(prefix)) continue;
                    validRef = true;
                    break;
                }
                if (validRef) {
                    hasRefs[0] = true;
                }
                return validRef;
            }
        });
        return hasRefs[0];
    }

    public static boolean isReference(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "isReference"));
        }
        final boolean[] containsText = new boolean[]{false};
        final int[] foundReferenceCount = new int[]{0};
        ReferencesResolverUtil.resolve(value.trim(), new ReferencesResolverListener(){

            public void appendText(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/parameters/ReferencesResolverUtil$2", "appendText"));
                }
                containsText[0] = true;
            }

            public boolean appendReference(@NotNull String referenceKey) {
                if (referenceKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceKey", "jetbrains/buildServer/parameters/ReferencesResolverUtil$2", "appendReference"));
                }
                foundReferenceCount[0] = foundReferenceCount[0] + 1;
                return true;
            }
        });
        return !containsText[0] && foundReferenceCount[0] == 1;
    }

    public static boolean mayContainReference(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "mayContainReference"));
        }
        int numMarkers = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '%' || ++numMarkers < 2) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> findParametersReferringToKey(@NotNull Map<String, String> parameters, @NotNull Collection<String> keys) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "findParametersReferringToKey"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "findParametersReferringToKey"));
        }
        HashSet<String> result = new HashSet<String>();
        Set<Map.Entry<String, String>> entries = parameters.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            Set<String> references = ReferencesResolverUtil.getReferences(entry.getValue());
            if (Collections.disjoint(references, keys)) continue;
            result.add(entry.getKey());
        }
        Set<String> set = Collections.unmodifiableSet(result);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "findParametersReferringToKey"));
        }
        return set;
    }

    public static Set<String> getReferences(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "getReferences"));
        }
        return ReferencesResolverUtil.getReferences(value, new String[0], false);
    }

    public static Set<String> getReferences(@NotNull String value, @NotNull String[] prefixes, boolean allowSpaces) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "getReferences"));
        }
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "jetbrains/buildServer/parameters/ReferencesResolverUtil", "getReferences"));
        }
        ReferencesExtractor referencesExtractor = new ReferencesExtractor(allowSpaces);
        ReferencesResolverUtil.resolve(value, referencesExtractor);
        Set<String> allReferences = referencesExtractor.getReferences();
        if (prefixes.length == 0) {
            return allReferences;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(allReferences.size());
        block0: for (String reference : allReferences) {
            for (String prefix : prefixes) {
                if (!reference.startsWith(prefix)) continue;
                result.add(reference);
                continue block0;
            }
        }
        return result;
    }

    private static class CharBuffer {
        private final char[] myBuf;
        private int myPos;

        public CharBuffer(int length) {
            this.myBuf = new char[length];
            this.myPos = 0;
        }

        public void append(char[] src, int startPos, int len) {
            System.arraycopy(src, startPos, this.myBuf, this.myPos, len);
            this.myPos += len;
        }

        public void append(char c) {
            this.myBuf[this.myPos++] = c;
        }

        public boolean isEmpty() {
            return this.myPos == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String flush() {
            try {
                String string = new String(this.myBuf, 0, this.myPos);
                return string;
            }
            finally {
                this.myPos = 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferencesExtractor
    implements ReferencesResolverListener {
        private final Set<String> myReferences = new LinkedHashSet<String>();
        private final boolean myAllowSpaces;

        private ReferencesExtractor(boolean allowSpaces) {
            this.myAllowSpaces = allowSpaces;
        }

        @Override
        public void appendText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/parameters/ReferencesResolverUtil$ReferencesExtractor", "appendText"));
            }
        }

        @Override
        public boolean appendReference(@NotNull String referenceKey) {
            if (referenceKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceKey", "jetbrains/buildServer/parameters/ReferencesResolverUtil$ReferencesExtractor", "appendReference"));
            }
            if (!this.myAllowSpaces && referenceKey.indexOf(32) != -1) {
                return false;
            }
            this.myReferences.add(referenceKey);
            return true;
        }

        public Set<String> getReferences() {
            return this.myReferences;
        }
    }

    public static interface ReferencesResolverListener {
        public void appendText(@NotNull String var1);

        public boolean appendReference(@NotNull String var1);
    }
}

