/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.ParametersProvider;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixedParametersProvider
implements ParametersProvider {
    @NotNull
    private final ParametersProvider myProvider;
    @NotNull
    private final String myPrefix;

    public PrefixedParametersProvider(@NotNull String prefix, @NotNull ParametersProvider provider) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "jetbrains/buildServer/parameters/impl/PrefixedParametersProvider", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "jetbrains/buildServer/parameters/impl/PrefixedParametersProvider", "<init>"));
        }
        this.myProvider = provider;
        this.myPrefix = prefix;
    }

    @Override
    public String get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/PrefixedParametersProvider", "get"));
        }
        return this.myProvider.get(this.myPrefix + key);
    }

    @Override
    public int size() {
        return this.myProvider.size();
    }

    @Override
    public Map<String, String> getAll() {
        Map<String, String> baseParameters = this.myProvider.getAll();
        HashMap<String, String> result = new HashMap<String, String>(baseParameters.size());
        for (Map.Entry<String, String> entry : baseParameters.entrySet()) {
            result.put(this.myPrefix + entry.getKey(), entry.getValue());
        }
        return result;
    }
}

