/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.DoubleKeyMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleKeyMap<Key1, Key2, Value>
implements DoubleKeyMap<Key1, Key2, Value> {
    protected final Map<Key1, Map<Key2, Value>> myMapByKey1;
    protected final Map<Key2, Map<Key1, Value>> myMapByKey2;
    protected int mySize;

    protected AbstractDoubleKeyMap(@NotNull Map<Key1, Map<Key2, Value>> mapByKey1, @NotNull Map<Key2, Map<Key1, Value>> mapByKey2) {
        if (mapByKey1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapByKey1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "<init>"));
        }
        if (mapByKey2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapByKey2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "<init>"));
        }
        this.myMapByKey1 = mapByKey1;
        this.myMapByKey2 = mapByKey2;
        this.mySize = 0;
    }

    @Override
    @Nullable
    public Value put(@NotNull Key1 k1, @NotNull Key2 k2, @Nullable Value v) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "put"));
        }
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "put"));
        }
        Value previous1 = AbstractDoubleKeyMap.putToDoubleMap(this.myMapByKey1, k1, k2, v);
        Value previous2 = AbstractDoubleKeyMap.putToDoubleMap(this.myMapByKey2, k2, k1, v);
        assert (previous1 == previous2);
        if (previous1 == null) {
            ++this.mySize;
        }
        return previous1;
    }

    @Override
    public void putAllForKey1(@NotNull Key1 k1, @NotNull Map<Key2, Value> map) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putAllForKey1"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putAllForKey1"));
        }
        Map<Key2, Value> innerMap = AbstractDoubleKeyMap.getOrCreate(this.myMapByKey1, k1);
        innerMap.putAll(map);
        int added = AbstractDoubleKeyMap.putMap(this.myMapByKey2, k1, map);
        this.mySize += added;
    }

    @Override
    public void putAllForKey2(@NotNull Key2 k2, @NotNull Map<Key1, Value> map) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putAllForKey2"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putAllForKey2"));
        }
        Map<Key1, Value> innerMap = AbstractDoubleKeyMap.getOrCreate(this.myMapByKey2, k2);
        innerMap.putAll(map);
        int added = AbstractDoubleKeyMap.putMap(this.myMapByKey1, k2, map);
        this.mySize += added;
    }

    @Override
    public void putAll(@NotNull DoubleKeyMap<Key1, Key2, Value> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putAll"));
        }
        Set<Map.Entry<Key1, Map<Key2, Value>>> entries = map.entrySet();
        for (Map.Entry<Key1, Map<Key2, Value>> entry : entries) {
            Key1 key1 = entry.getKey();
            Map<Key2, Value> value = entry.getValue();
            for (Map.Entry<Key2, Value> innerEntry : value.entrySet()) {
                this.put(key1, innerEntry.getKey(), innerEntry.getValue());
            }
        }
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean isEmpty() {
        return this.mySize == 0;
    }

    @Override
    @Nullable
    public Value get(@NotNull Key1 k1, @NotNull Key2 k2) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "get"));
        }
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "get"));
        }
        Map<Key2, Value> map = this.myMapByKey1.get(k1);
        return map != null ? (Value)map.get(k2) : null;
    }

    @Override
    @NotNull
    public Map<Key2, Value> getAllByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getAllByKey1"));
        }
        Map<Key2, Value> map = AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getAllByKey1"));
        }
        return map;
    }

    @Override
    @NotNull
    public Map<Key1, Value> getAllByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getAllByKey2"));
        }
        Map<Key1, Value> map = AbstractDoubleKeyMap.notNullize(this.myMapByKey2.get(k2));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getAllByKey2"));
        }
        return map;
    }

    @Override
    public boolean contains(@NotNull Key1 k1, @NotNull Key2 k2) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "contains"));
        }
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "contains"));
        }
        return AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1)).containsKey(k2);
    }

    @Override
    public boolean containsAnyByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "containsAnyByKey1"));
        }
        return this.myMapByKey1.containsKey(k1);
    }

    @Override
    public boolean containsAnyByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "containsAnyByKey2"));
        }
        return this.myMapByKey2.containsKey(k2);
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key1, Map<Key2, Value>>> entrySet() {
        Set<Map.Entry<Key1, Map<Key2, Value>>> set = this.myMapByKey1.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "entrySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key2, Value>> entrySetByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "entrySetByKey1"));
        }
        Set<Map.Entry<Key2, Value>> set = AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1)).entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "entrySetByKey1"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<Key1, Value>> entrySetByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "entrySetByKey2"));
        }
        Set<Map.Entry<Key1, Value>> set = AbstractDoubleKeyMap.notNullize(this.myMapByKey2.get(k2)).entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "entrySetByKey2"));
        }
        return set;
    }

    @Override
    @NotNull
    public Map<Key1, Set<Key2>> keys() {
        HashMap<Key1, Set<Key2>> result = new HashMap<Key1, Set<Key2>>();
        for (Map.Entry<Key1, Map<Key2, Value>> entry : this.myMapByKey1.entrySet()) {
            Key1 key1 = entry.getKey();
            Set<Key2> keys2 = entry.getValue().keySet();
            result.put(key1, keys2);
        }
        HashMap<Key1, Set<Key2>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "keys"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public Set<Key2> keySet1(@NotNull Key1 k1) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "keySet1"));
        }
        Set<Key2> set = this.getAllByKey1(k1).keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "keySet1"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Key1> keySet2(@NotNull Key2 k2) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "keySet2"));
        }
        Set<Key1> set = this.getAllByKey2(k2).keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "keySet2"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<Value> values() {
        ArrayList<Value> result = new ArrayList<Value>();
        Collection<Map<Key2, Value>> mapCollection = this.myMapByKey1.values();
        for (Map<Key2, Value> map : mapCollection) {
            result.addAll(map.values());
        }
        ArrayList<Value> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<Value> valuesByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "valuesByKey1"));
        }
        Collection<Value> collection = this.getAllByKey1(k1).values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "valuesByKey1"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Value> valuesByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "valuesByKey2"));
        }
        Collection<Value> collection = this.getAllByKey2(k2).values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "valuesByKey2"));
        }
        return collection;
    }

    @Override
    @Nullable
    public Value remove(@NotNull Key1 k1, @NotNull Key2 k2) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "remove"));
        }
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "remove"));
        }
        Value value1 = AbstractDoubleKeyMap.notNullize(this.myMapByKey1.get(k1)).remove(k2);
        Value value2 = AbstractDoubleKeyMap.notNullize(this.myMapByKey2.get(k2)).remove(k1);
        assert (value1 == value2);
        if (value1 != null) {
            --this.mySize;
        }
        return value1;
    }

    @Override
    @Nullable
    public Map<Key2, Value> removeAllByKey1(@NotNull Key1 k1) {
        if (k1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeAllByKey1"));
        }
        Map<Key2, Value> map = this.myMapByKey1.remove(k1);
        if (map != null) {
            AbstractDoubleKeyMap.removeKeyForAll(this.myMapByKey2, k1, map.keySet());
            this.mySize -= map.size();
        }
        return map;
    }

    @Override
    @Nullable
    public Map<Key1, Value> removeAllByKey2(@NotNull Key2 k2) {
        if (k2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeAllByKey2"));
        }
        Map<Key1, Value> map = this.myMapByKey2.remove(k2);
        if (map != null) {
            AbstractDoubleKeyMap.removeKeyForAll(this.myMapByKey1, k2, map.keySet());
            this.mySize -= map.size();
        }
        return map;
    }

    @Override
    public void removeAll(@NotNull Collection<Key1> keys1, @NotNull Collection<Key2> keys2) {
        if (keys1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeAll"));
        }
        if (keys2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeAll"));
        }
        AbstractDoubleKeyMap.removeForAllKeys(this.myMapByKey1, keys1, keys2);
        AbstractDoubleKeyMap.removeForAllKeys(this.myMapByKey2, keys2, keys1);
        this.recalculateSize();
    }

    @Override
    public void clear() {
        this.myMapByKey1.clear();
        this.myMapByKey2.clear();
        this.mySize = 0;
    }

    protected void recalculateSize() {
        this.mySize = 0;
        for (Map<Key2, Value> map : this.myMapByKey1.values()) {
            this.mySize += map.size();
        }
    }

    @NotNull
    private static <TK1, TK2, TV> Map<TK2, TV> getOrCreate(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK1 key) {
        if (doubleMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubleMap", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getOrCreate"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getOrCreate"));
        }
        Map<TK2, TV> map = doubleMap.get(key);
        if (map == null) {
            map = new HashMap<TK2, TV>();
            doubleMap.put(key, map);
        }
        Map<TK2, TV> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "getOrCreate"));
        }
        return map2;
    }

    @Nullable
    private static <TK1, TK2, TV> TV putToDoubleMap(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK1 key1, @NotNull TK2 key2, @Nullable TV value) {
        if (doubleMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubleMap", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putToDoubleMap"));
        }
        if (key1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putToDoubleMap"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putToDoubleMap"));
        }
        Map<TK2, TV> map = AbstractDoubleKeyMap.getOrCreate(doubleMap, key1);
        return map.put(key2, value);
    }

    private static <TK1, TK2, TV> int putMap(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK2 key, @NotNull Map<TK1, TV> map) {
        if (doubleMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubleMap", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putMap"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putMap"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "putMap"));
        }
        int added = 0;
        for (Map.Entry<TK1, TV> entry : map.entrySet()) {
            TV value;
            TK1 key1 = entry.getKey();
            TV previous = AbstractDoubleKeyMap.putToDoubleMap(doubleMap, key1, key, value = entry.getValue());
            if (previous != null) continue;
            ++added;
        }
        return added;
    }

    @NotNull
    private static <TK, TV> Map<TK, TV> notNullize(@Nullable Map<TK, TV> map) {
        Map<Object, Object> map2 = map != null ? map : Collections.emptyMap();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "notNullize"));
        }
        return map2;
    }

    private static <TK1, TK2, TV> void removeKeyForAll(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull TK2 key2, @NotNull Set<TK1> keys) {
        if (doubleMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubleMap", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeKeyForAll"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeKeyForAll"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeKeyForAll"));
        }
        for (TK1 key1 : keys) {
            AbstractDoubleKeyMap.notNullize(doubleMap.get(key1)).remove(key2);
        }
    }

    private static <TK1, TK2, TV> void removeForAllKeys(@NotNull Map<TK1, Map<TK2, TV>> doubleMap, @NotNull Collection<TK1> keys1, @NotNull Collection<TK2> keys2) {
        if (doubleMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doubleMap", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeForAllKeys"));
        }
        if (keys1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys1", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeForAllKeys"));
        }
        if (keys2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys2", "jetbrains/buildServer/util/AbstractDoubleKeyMap", "removeForAllKeys"));
        }
        for (TK1 key1 : keys1) {
            Map<TK2, TV> map = doubleMap.get(key1);
            if (map == null) continue;
            for (TK2 key2 : keys2) {
                map.remove(key2);
            }
        }
    }
}

