/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class Alarm
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)Alarm.class.getName());
    private final ScheduledExecutorService myExecutor;
    private final Map<Runnable, Future> myTasks;

    public Alarm(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/Alarm", "<init>"));
        }
        this.myTasks = new HashMap<Runnable, Future>();
        this.myExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Alarm (" + name + ")");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public synchronized void dispose() {
        this.myExecutor.shutdownNow();
    }

    public synchronized void addRepeatableRequest(Runnable toRun, long delay, long repeatDelay) {
        this.myTasks.put(toRun, this.myExecutor.scheduleAtFixedRate(this.createTask(toRun, true), delay, repeatDelay, TimeUnit.MILLISECONDS));
    }

    public synchronized void addRequest(Runnable toRun, long delay, boolean repeatable) {
        if (repeatable) {
            this.addRepeatableRequest(toRun, delay, delay);
        } else {
            this.myTasks.put(toRun, this.myExecutor.schedule(this.createTask(toRun, false), delay, TimeUnit.MILLISECONDS));
        }
    }

    public synchronized void cancelAllRequests() {
        ArrayList<Runnable> allRunnables = new ArrayList<Runnable>(this.myTasks.keySet());
        for (Runnable r : allRunnables) {
            this.cancelRequest(r);
        }
    }

    public synchronized void cancelRequest(Runnable request) {
        Future task = this.myTasks.get(request);
        if (task != null) {
            task.cancel(true);
            this.myTasks.remove(request);
        }
    }

    public synchronized boolean hasRequests() {
        return !this.myTasks.isEmpty();
    }

    private Runnable createTask(final Runnable toRun, final boolean repeatable) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    toRun.run();
                }
                catch (Throwable t) {
                    LOG.warn("Unexpected error occurred inside Alarm task: " + t.toString());
                    LOG.debug("Unexpected error occurred inside Alarm task: " + t.toString(), t);
                }
                finally {
                    if (!repeatable) {
                        Alarm.this.cancelRequest(toRun);
                    }
                }
            }
        };
    }
}

