/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPatternFileFinder {
    private final String[] myIncludePatterns;
    private final String[] myExcludePatterns;
    private final boolean myCaseSensitive;

    public AntPatternFileFinder(String[] includePatterns, String[] excludePatterns, boolean caseSensitive) {
        this.myIncludePatterns = includePatterns;
        this.myExcludePatterns = excludePatterns;
        this.myCaseSensitive = caseSensitive;
        if (!caseSensitive) {
            int i;
            for (i = 0; i < this.myIncludePatterns.length; ++i) {
                this.myIncludePatterns[i] = this.myIncludePatterns[i].toLowerCase();
            }
            for (i = 0; i < this.myExcludePatterns.length; ++i) {
                this.myExcludePatterns[i] = this.myExcludePatterns[i].toLowerCase();
            }
        }
    }

    private static boolean matchAny(@NotNull PathMatcher matcher, @NotNull String[] patterns, @NotNull String name) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "jetbrains/buildServer/util/AntPatternFileFinder", "matchAny"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "jetbrains/buildServer/util/AntPatternFileFinder", "matchAny"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/AntPatternFileFinder", "matchAny"));
        }
        for (String pattern : patterns) {
            if (!matcher.match(pattern, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchStartAny(@NotNull PathMatcher matcher, @NotNull String[] patterns, @NotNull String name) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "jetbrains/buildServer/util/AntPatternFileFinder", "matchStartAny"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "jetbrains/buildServer/util/AntPatternFileFinder", "matchStartAny"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/AntPatternFileFinder", "matchStartAny"));
        }
        for (String pattern : patterns) {
            if (!matcher.matchStart(pattern, name)) continue;
            return true;
        }
        return false;
    }

    private void findFilesRec(@NotNull File baseDirectory, @NotNull String current, @NotNull PathMatcher matcher, @NotNull Collection<File> result) throws IOException {
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "jetbrains/buildServer/util/AntPatternFileFinder", "findFilesRec"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "jetbrains/buildServer/util/AntPatternFileFinder", "findFilesRec"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "jetbrains/buildServer/util/AntPatternFileFinder", "findFilesRec"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "jetbrains/buildServer/util/AntPatternFileFinder", "findFilesRec"));
        }
        File dir = new File(baseDirectory, current);
        File[] fileEntries = dir.listFiles((FileFilter)FileFileFilter.FILE);
        if (fileEntries == null) {
            throw new IOException("Can't list files in " + dir.getPath());
        }
        for (File entry : fileEntries) {
            String relativeName = (current.length() == 0 ? "" : current + "/") + entry.getName();
            if (!this.myCaseSensitive) {
                relativeName = relativeName.toLowerCase();
            }
            if (!AntPatternFileFinder.matchAny(matcher, this.myIncludePatterns, relativeName) || AntPatternFileFinder.matchAny(matcher, this.myExcludePatterns, relativeName)) continue;
            result.add(entry);
        }
        File[] dirEntries = dir.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (dirEntries == null) {
            throw new IOException("Can't list subdirectories in " + dir.getPath());
        }
        for (File entry : dirEntries) {
            String relativeName = (current.length() == 0 ? "" : current + "/") + entry.getName();
            if (!this.myCaseSensitive) {
                relativeName = relativeName.toLowerCase();
            }
            if (!AntPatternFileFinder.matchStartAny(matcher, this.myIncludePatterns, relativeName) || AntPatternFileFinder.matchAny(matcher, this.myExcludePatterns, relativeName)) continue;
            this.findFilesRec(baseDirectory, relativeName, matcher, result);
        }
    }

    public File[] findFiles(@NotNull File baseDirectory) throws IOException {
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "jetbrains/buildServer/util/AntPatternFileFinder", "findFiles"));
        }
        ArrayList<File> files = new ArrayList<File>();
        this.findFilesRec(baseDirectory, "", (PathMatcher)new AntPathMatcher(), files);
        return files.toArray(new File[files.size()]);
    }
}

