/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.PathUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jetbrains.buildServer.util.ArchiveType;
import jetbrains.buildServer.util.BaseArchiveUtil;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.impl.FileAware;
import jetbrains.buildServer.util.impl.SevenZArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveUtil
extends BaseArchiveUtil {
    public static final String DEFAULT_ZIP_ENCODING = "cp437";
    public static final String ARCHIVE_PATH_SEPARATOR = "!/";
    private static final Logger LOG = Logger.getInstance((String)ArchiveUtil.class.getName());
    private static final String GZ = ".gz";

    @NotNull
    public static ArchiveType getArchiveType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
        }
        if ((name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".nupkg") || name.endsWith(".sit")) {
            ArchiveType archiveType = ArchiveType.ZIP;
            if (archiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
            }
            return archiveType;
        }
        if (name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".apk")) {
            ArchiveType archiveType = ArchiveType.JAR;
            if (archiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
            }
            return archiveType;
        }
        if (name.endsWith(".tar.gz") || name.endsWith(".tgz") || name.endsWith(".tar.gzip")) {
            ArchiveType archiveType = ArchiveType.TAR_GZ;
            if (archiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
            }
            return archiveType;
        }
        if (name.endsWith(".tar")) {
            ArchiveType archiveType = ArchiveType.TAR;
            if (archiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
            }
            return archiveType;
        }
        if (name.endsWith(".7z")) {
            ArchiveType archiveType = ArchiveType.SEVEN_Z;
            if (archiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
            }
            return archiveType;
        }
        ArchiveType archiveType = ArchiveType.NOT_ARCHIVE;
        if (archiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveType"));
        }
        return archiveType;
    }

    @Nullable
    public static ArchiveInputStream getArchiveInputStream(@NotNull ArchiveType archiveType, @NotNull InputStream inputStream) throws IOException {
        if (archiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveType", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveInputStream"));
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveInputStream"));
        }
        if (archiveType == ArchiveType.SEVEN_Z) {
            if (inputStream instanceof FileAware) {
                return new SevenZArchiveInputStream(((FileAware)((Object)inputStream)).getFile());
            }
            return null;
        }
        return archiveType == ArchiveType.ZIP ? new ZipArchiveInputStream(inputStream, DEFAULT_ZIP_ENCODING, true) : (archiveType == ArchiveType.JAR ? new JarArchiveInputStream(inputStream) : (archiveType == ArchiveType.TAR_GZ ? new TarArchiveInputStream((InputStream)new GZIPInputStream(inputStream)) : (archiveType == ArchiveType.TAR ? new TarArchiveInputStream(inputStream) : null)));
    }

    @Nullable
    public static ArchiveInputStream getArchiveInputStream(@NotNull String name, @NotNull InputStream inputStream) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveInputStream"));
        }
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "jetbrains/buildServer/util/ArchiveUtil", "getArchiveInputStream"));
        }
        return ArchiveUtil.getArchiveInputStream(ArchiveUtil.getArchiveType(name), inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unpackZip(@NotNull File zip, @NotNull String pathPrefix, @NotNull File targetDir) {
        if (zip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        LOG.debug("Unpacking zip " + zip.getAbsolutePath() + "!" + pathPrefix + " to " + targetDir.getAbsolutePath());
        ZipInputStream file = null;
        try {
            file = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ArchiveUtil.unpackZip(file, targetDir, pathPrefix);
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOG.warn("Failed to unpack zip " + zip.getAbsolutePath() + "!" + pathPrefix + " to " + targetDir.getAbsolutePath(), (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(file);
                throw throwable;
            }
            FileUtil.close(file);
            return bl;
        }
        FileUtil.close(file);
        return true;
    }

    public static boolean unpackZip(@NotNull File zip, @NotNull File targetDir) {
        if (zip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zip", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        return ArchiveUtil.unpackZip(zip, "", targetDir);
    }

    public static boolean unpackZip(@NotNull ZipInputStream input, @NotNull File targetDir) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        try {
            ArchiveUtil.unpackZip(input, targetDir, "");
        }
        catch (IOException e) {
            LOG.warn("Failed to unpack zip input stream to " + targetDir.getAbsolutePath(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static void unpackZip(@NotNull ZipInputStream file, @NotNull File targetDir, @NotNull String pathPrefix) throws IOException {
        ZipEntry ze;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "jetbrains/buildServer/util/ArchiveUtil", "unpackZip"));
        }
        while ((ze = file.getNextEntry()) != null) {
            if (!ze.getName().startsWith(pathPrefix)) continue;
            ArchiveUtil.saveEntry(targetDir, file, ze, pathPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void saveEntry(@NotNull File parentDir, @NotNull ZipInputStream zf, @NotNull ZipEntry entry, @NotNull String pathPrefix) throws IOException {
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "jetbrains/buildServer/util/ArchiveUtil", "saveEntry"));
        }
        if (zf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zf", "jetbrains/buildServer/util/ArchiveUtil", "saveEntry"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "jetbrains/buildServer/util/ArchiveUtil", "saveEntry"));
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathPrefix", "jetbrains/buildServer/util/ArchiveUtil", "saveEntry"));
        }
        String relativePath = entry.getName().substring(pathPrefix.length());
        if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
            relativePath = relativePath.substring(1);
        }
        File file = new File(parentDir, relativePath);
        LOG.debug("Extracting zip entry \"" + entry.getName() + "\" to \"" + file.getAbsolutePath() + "\"");
        FileUtil.createParentDirs((File)file);
        if (entry.isDirectory()) {
            file.mkdirs();
            return;
        }
        if (file.exists()) {
            FileUtil.delete(file);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        try {
            TCStreamUtil.writeBinary(new BufferedInputStream(zf), bos);
        }
        catch (Throwable throwable) {
            FileUtil.closeAll(bos);
            throw throwable;
        }
        FileUtil.closeAll(bos);
    }

    public static boolean packZip(@NotNull File destFile, @NotNull Collection<File> sourceFiles) throws FileNotFoundException {
        if (destFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destFile", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        return ArchiveUtil.packZip(destFile, null, sourceFiles);
    }

    public static boolean packZip(@NotNull File destFile, @Nullable FilenameFilter filter, @NotNull Collection<File> sourceFiles) throws FileNotFoundException {
        if (destFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destFile", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        LOG.debug("Packing " + sourceFiles.size() + " file" + (sourceFiles.size() == 1 ? "" : "s") + " to " + destFile.getAbsolutePath());
        return ArchiveUtil.packZip(new FileOutputStream(destFile), null, sourceFiles);
    }

    public static boolean packZip(@NotNull OutputStream destStream, @NotNull Collection<File> sourceFiles) {
        if (destStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destStream", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        return ArchiveUtil.packZip(destStream, null, sourceFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean packZip(@NotNull OutputStream destStream, @Nullable FilenameFilter filter, @NotNull Collection<File> sourceFiles) {
        boolean i$;
        block9: {
            if (destStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destStream", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
            }
            if (sourceFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
            }
            ZipOutputStream outputStream = null;
            try {
                outputStream = new ZipOutputStream(destStream);
                for (File file : sourceFiles) {
                    ArchiveUtil.packToZip(file, filter, outputStream, false);
                }
                i$ = true;
                if (outputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    LOG.warn("Failed to pack " + sourceFiles.size() + " file" + (sourceFiles.size() == 1 ? "" : "s"));
                    return false;
                }
            }
            outputStream.close();
        }
        return i$;
    }

    public static boolean packZip(@NotNull File root, @NotNull ZipOutputStream output) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        return ArchiveUtil.packZip(root, null, output);
    }

    public static boolean packZip(@NotNull File root, @Nullable FilenameFilter filter, @NotNull ZipOutputStream output) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "jetbrains/buildServer/util/ArchiveUtil", "packZip"));
        }
        return ArchiveUtil.packToZip(root, filter, output, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean packToZip(@NotNull File root, @Nullable FilenameFilter filter, @NotNull ZipOutputStream output, boolean closeZip) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/util/ArchiveUtil", "packToZip"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "jetbrains/buildServer/util/ArchiveUtil", "packToZip"));
        }
        try {
            byte[] buffer = new byte[65536];
            try {
                ArchiveUtil.traverseAndWrite(root, filter, output, new StringBuilder(), true, buffer);
            }
            finally {
                if (closeZip) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to pack " + root + " to zip", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseAndWrite(@NotNull File file, @Nullable FilenameFilter filter, @NotNull ZipOutputStream output, @NotNull StringBuilder pathBuilder, boolean isFirst, @NotNull byte[] buffer) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/ArchiveUtil", "traverseAndWrite"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "jetbrains/buildServer/util/ArchiveUtil", "traverseAndWrite"));
        }
        if (pathBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathBuilder", "jetbrains/buildServer/util/ArchiveUtil", "traverseAndWrite"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "jetbrains/buildServer/util/ArchiveUtil", "traverseAndWrite"));
        }
        if (!isFirst || file.isFile()) {
            pathBuilder.append(file.getName());
            if (!file.isFile()) {
                pathBuilder.append('/');
            }
        }
        if (file.isFile()) {
            String path = pathBuilder.toString();
            ZipEntry zipEntry = new ZipEntry(path);
            zipEntry.setTime(file.lastModified());
            output.putNextEntry(zipEntry);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                do {
                    read = ((InputStream)input).read(buffer);
                    output.write(buffer, 0, Math.max(read, 0));
                } while (read == buffer.length);
            }
            catch (IOException e) {
                LOG.warn("Failed to pack " + file.getAbsolutePath() + " to zip (error: " + e.getMessage() + ")");
                LOG.debug((Throwable)e);
            }
            finally {
                ((InputStream)input).close();
                output.closeEntry();
            }
        } else {
            File[] files;
            File[] fileArray = files = filter == null ? file.listFiles() : file.listFiles(filter);
            if (files != null) {
                int length = pathBuilder.length();
                for (File innerFile : files) {
                    ArchiveUtil.traverseAndWrite(innerFile, filter, output, pathBuilder, false, buffer);
                    pathBuilder.setLength(length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packStream(@NotNull OutputStream out, @NotNull InputStream in) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "jetbrains/buildServer/util/ArchiveUtil", "packStream"));
        }
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "jetbrains/buildServer/util/ArchiveUtil", "packStream"));
        }
        GZIPOutputStream gz = new GZIPOutputStream(out);
        try {
            StreamUtil.copyStreamContent((InputStream)in, (OutputStream)gz);
        }
        finally {
            gz.finish();
        }
    }

    public static void unpackStream(@NotNull OutputStream out, @NotNull InputStream in) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "jetbrains/buildServer/util/ArchiveUtil", "unpackStream"));
        }
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "jetbrains/buildServer/util/ArchiveUtil", "unpackStream"));
        }
        StreamUtil.copyStreamContent((InputStream)new GZIPInputStream(in), (OutputStream)out);
    }

    @Nullable
    public static byte[] packBytes(@Nullable byte[] unpacked) {
        try {
            if (unpacked == null) {
                return null;
            }
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ArchiveUtil.packStream(bas, new ByteArrayInputStream(unpacked));
            return bas.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack bytes", e);
        }
    }

    @Nullable
    public static byte[] unpackBytes(@Nullable byte[] packed) {
        try {
            if (packed == null) {
                return null;
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream(packed.length);
            ArchiveUtil.unpackStream(result, new ByteArrayInputStream(packed));
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unpack bytes", e);
        }
    }

    @Nullable
    public static InputStream extractEntry(@NotNull ZipInputStream input, @NotNull String path) throws IOException {
        ZipEntry entry;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/util/ArchiveUtil", "extractEntry"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "extractEntry"));
        }
        while ((entry = input.getNextEntry()) != null) {
            if (!entry.getName().equals(path)) continue;
            return input;
        }
        return null;
    }

    @NotNull
    public static File getPackedFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/ArchiveUtil", "getPackedFile"));
        }
        File parentFile = file.getParentFile();
        String packedFileName = ArchiveUtil.getPackedFileName(file.getName());
        File file2 = parentFile != null ? new File(parentFile, packedFileName) : new File(packedFileName);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getPackedFile"));
        }
        return file2;
    }

    @NotNull
    public static String getPackedFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "jetbrains/buildServer/util/ArchiveUtil", "getPackedFileName"));
        }
        String string = fileName + GZ;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getPackedFileName"));
        }
        return string;
    }

    public static boolean isPackedFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/ArchiveUtil", "isPackedFile"));
        }
        return ArchiveUtil.isPackedFileName(file.getName());
    }

    public static boolean isPackedFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "jetbrains/buildServer/util/ArchiveUtil", "isPackedFileName"));
        }
        return fileName.endsWith(GZ);
    }

    @NotNull
    public static File packFile(@NotNull File srcFile) throws IOException {
        if (srcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcFile", "jetbrains/buildServer/util/ArchiveUtil", "packFile"));
        }
        File packedFile = ArchiveUtil.getPackedFile(srcFile);
        ArchiveUtil.packFileTo(packedFile, srcFile);
        File file = packedFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "packFile"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packFileTo(@NotNull File dstFile, @NotNull File srcFile) throws IOException {
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "jetbrains/buildServer/util/ArchiveUtil", "packFileTo"));
        }
        if (srcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcFile", "jetbrains/buildServer/util/ArchiveUtil", "packFileTo"));
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(srcFile);
            output = new FileOutputStream(dstFile);
            ArchiveUtil.packStream(output, input);
        }
        catch (Throwable throwable) {
            FileUtil.close(input);
            FileUtil.close(output);
            throw throwable;
        }
        FileUtil.close(input);
        FileUtil.close(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsEntry(File zip, String relativePath) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        try {
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (!relativePath.equals(zipEntry.getName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Collection<ArchivedFileInfo> getArchivedFolderEntries(@NotNull ArchiveFileDescriptor archive, @NotNull String innerPathToFolder) throws IOException {
        Object entry;
        ArchiveEntryToArchivedFileInfoConverter converter;
        String segment;
        ArchiveInputStream stream;
        block15: {
            if (archive == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "jetbrains/buildServer/util/ArchiveUtil", "getArchivedFolderEntries"));
            }
            if (innerPathToFolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerPathToFolder", "jetbrains/buildServer/util/ArchiveUtil", "getArchivedFolderEntries"));
            }
            LinkedList<String> segments = new LinkedList<String>(ArchiveUtil.splitByArchivePathSeparator(innerPathToFolder, true));
            InputStream archiveInputStream = archive.getInputStream();
            ArrayList<InputStream> toClose = new ArrayList<InputStream>();
            toClose.add(archiveInputStream);
            stream = ArchiveUtil.getArchiveInputStream(archive.getName(), archiveInputStream);
            while (true) {
                if (stream == null) {
                    throw new FileNotFoundException("File " + innerPathToFolder + " not found in " + ((Object)archive).toString() + ": archive not supported");
                }
                toClose.add((InputStream)stream);
                segment = StringUtil.removeLeadingSlash(StringUtil.convertAndCollapseSlashes((String)segments.poll()));
                if (segments.isEmpty()) {
                    converter = new ArchiveEntryToArchivedFileInfoConverter();
                    entry = stream.getNextEntry();
                    break block15;
                }
                ArchiveEntry entry2 = ArchiveUtil.positionArchivedPath(stream, segment);
                if (entry2 == null) {
                    throw new FileNotFoundException("File " + innerPathToFolder + " not found in " + ((Object)archive).toString());
                }
                String name = StringUtil.convertAndCollapseSlashes(entry2.getName());
                stream = ArchiveUtil.getArchiveInputStream(name, (InputStream)new BufferedInputStream((InputStream)stream));
            }
            finally {
                Collections.reverse(toClose);
                Iterator i$ = toClose.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                    }
                    Closeable closeable = (Closeable)i$.next();
                    FileUtil.close(closeable);
                }
            }
        }
        while (entry != null) {
            String string;
            String name = StringUtil.removeLeadingSlash(StringUtil.convertAndCollapseSlashes(entry.getName()));
            if (!ArchiveUtil.equalsIgnoringTLSlashes(innerPathToFolder, name) && name.startsWith(segment) && !StringUtil.isEmptyOrSpaces((String)(string = StringUtil.removeLeadingAndTailingSlash(name.substring(segment.length()))))) {
                converter.add(string, (ArchiveEntry)entry);
            }
            entry = stream.getNextEntry();
        }
        entry = converter.convert();
        Object object = entry;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getArchivedFolderEntries"));
        }
        return object;
    }

    @NotNull
    public static List<String> splitByArchivePathSeparator(@NotNull String path, boolean withEmptyLast) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "splitByArchivePathSeparator"));
        }
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(path.split(ARCHIVE_PATH_SEPARATOR)));
        if (withEmptyLast && path.endsWith(ARCHIVE_PATH_SEPARATOR)) {
            list.add("");
        }
        LinkedList<String> linkedList = list;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "splitByArchivePathSeparator"));
        }
        return linkedList;
    }

    @Nullable
    private static ArchiveEntry positionArchivedPath(@NotNull ArchiveInputStream stream, @NotNull String path) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "jetbrains/buildServer/util/ArchiveUtil", "positionArchivedPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "positionArchivedPath"));
        }
        ArchiveEntry entry = stream.getNextEntry();
        while (entry != null) {
            String name = StringUtil.convertAndCollapseSlashes(entry.getName());
            if (ArchiveUtil.equalsIgnoringTLSlashes(name, path)) {
                return entry;
            }
            entry = stream.getNextEntry();
        }
        return null;
    }

    private static boolean equalsIgnoringTLSlashes(@NotNull String a, @NotNull String b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "jetbrains/buildServer/util/ArchiveUtil", "equalsIgnoringTLSlashes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "jetbrains/buildServer/util/ArchiveUtil", "equalsIgnoringTLSlashes"));
        }
        a = StringUtil.removeLeadingAndTailingSlash(a);
        b = StringUtil.removeLeadingAndTailingSlash(b);
        return a.equals(b);
    }

    public static <T> T doInArchive(@NotNull ArchiveFileDescriptor archive, @NotNull String path, final @NotNull DoInArchiveHandler<T> callback) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        return ArchiveUtil.doInArchive(archive, path, new DoInArchiveHandler2<T>(){

            @Override
            public T found(@NotNull ArchiveEntry entry, @NotNull ArchiveInputStream stream, @NotNull Deque<Closeable> shouldBeManuallyClosed) throws IOException {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "jetbrains/buildServer/util/ArchiveUtil$1", "found"));
                }
                if (stream == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "jetbrains/buildServer/util/ArchiveUtil$1", "found"));
                }
                if (shouldBeManuallyClosed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeManuallyClosed", "jetbrains/buildServer/util/ArchiveUtil$1", "found"));
                }
                return callback.found(entry, stream);
            }
        }, true);
    }

    public static <T> T doInArchive(@NotNull ArchiveFileDescriptor archive, @NotNull String path, @NotNull DoInArchiveHandler2<T> callable) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        return ArchiveUtil.doInArchive(archive, path, callable, false);
    }

    private static <T> T doInArchive(@NotNull ArchiveFileDescriptor archive, @NotNull String path, @NotNull DoInArchiveHandler2<T> callable, boolean shouldCloseStreamsOnReturn) throws IOException {
        if (archive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "jetbrains/buildServer/util/ArchiveUtil", "doInArchive"));
        }
        LinkedList<String> segments = new LinkedList<String>(ArchiveUtil.splitByArchivePathSeparator(path, false));
        InputStream artifactStream = archive.getInputStream();
        boolean closeRequired = true;
        LinkedList<Closeable> toClose = new LinkedList<Closeable>();
        toClose.push(artifactStream);
        try {
            ArchiveInputStream stream = ArchiveUtil.getArchiveInputStream(archive.getName(), artifactStream);
            while (true) {
                if (stream == null) {
                    throw new FileNotFoundException("File " + path + " not found in " + ((Object)archive).toString() + ": archive not supported");
                }
                toClose.push((Closeable)stream);
                String segment = StringUtil.convertAndCollapseSlashes((String)segments.poll());
                ArchiveEntry entry = ArchiveUtil.positionArchivedPath(stream, segment);
                if (entry == null) {
                    throw new FileNotFoundException("File " + path + " not found in " + ((Object)archive).toString());
                }
                String found = StringUtil.convertAndCollapseSlashes(entry.getName());
                if (segments.isEmpty()) {
                    T result = callable.found(entry, stream, toClose);
                    if (!shouldCloseStreamsOnReturn) {
                        closeRequired = false;
                    }
                    T t = result;
                    return t;
                }
                stream = ArchiveUtil.getArchiveInputStream(found, (InputStream)new BufferedInputStream((InputStream)stream));
            }
        }
        finally {
            if (closeRequired) {
                while (!toClose.isEmpty()) {
                    FileUtil.close((Closeable)toClose.pop());
                }
            }
        }
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/ArchiveUtil", "getParentPath"));
        }
        path = StringUtil.convertAndCollapseSlashes(path);
        String parent = PathUtil.getParentPath((String)(path = StringUtil.removeTailingSlash(path)));
        if (parent.endsWith("!")) {
            String string = parent.substring(0, parent.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getParentPath"));
            }
            return string;
        }
        String string = parent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil", "getParentPath"));
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArchiveEntryToArchivedFileInfoConverter {
        private final Map<String, ArchiveEntry> myMap = new LinkedHashMap<String, ArchiveEntry>();

        private ArchiveEntryToArchivedFileInfoConverter() {
        }

        public void add(@NotNull String name, @NotNull ArchiveEntry entry) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter", "add"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter", "add"));
            }
            if ((name = StringUtil.removeLeadingAndTailingSlash(name)).contains("/")) {
                this.myMap.put(name.substring(0, name.indexOf(47)), null);
            } else {
                this.myMap.put(name, entry);
            }
        }

        @NotNull
        public Collection<ArchivedFileInfo> convert() {
            List<ArchivedFileInfo> list = CollectionsUtil.convertCollection(this.myMap.entrySet(), new Converter<ArchivedFileInfo, Map.Entry<String, ArchiveEntry>>(){

                @Override
                public ArchivedFileInfo createFrom(@NotNull Map.Entry<String, ArchiveEntry> source) {
                    boolean isDirectory;
                    long timestamp;
                    long size;
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter$1", "createFrom"));
                    }
                    String name = source.getKey();
                    ArchiveEntry value = source.getValue();
                    if (value != null) {
                        ArchiveEntry entry = value;
                        size = entry.getSize();
                        timestamp = entry.getLastModifiedDate() != null ? entry.getLastModifiedDate().getTime() : -1L;
                        isDirectory = entry.isDirectory();
                    } else {
                        size = -1L;
                        timestamp = 0L;
                        isDirectory = true;
                    }
                    return new ArchivedFileInfo(name, size, timestamp, isDirectory);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ArchiveUtil$ArchiveEntryToArchivedFileInfoConverter", "convert"));
            }
            return list;
        }
    }

    public static class ArchivedFileInfo {
        public static final long SIZE_UNKNOWN = -1L;
        private final String myName;
        private final long mySize;
        private final long myTimestamp;
        private final boolean myIsDirectory;

        /*
         * WARNING - void declaration
         */
        public ArchivedFileInfo(@NotNull String name, long size, long timestamp, boolean bl) {
            void isDirectory;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/ArchiveUtil$ArchivedFileInfo", "<init>"));
            }
            this.myName = name;
            this.mySize = size;
            this.myTimestamp = timestamp;
            this.myIsDirectory = isDirectory;
        }

        public String getName() {
            return this.myName;
        }

        public long getSize() {
            return this.mySize;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public boolean isDirectory() {
            return this.myIsDirectory;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoInArchiveHandler2<T> {
        public T found(@NotNull ArchiveEntry var1, @NotNull ArchiveInputStream var2, @NotNull Deque<Closeable> var3) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoInArchiveHandler<T> {
        public T found(@NotNull ArchiveEntry var1, @NotNull ArchiveInputStream var2) throws IOException;
    }

    public static interface ArchiveFileDescriptor {
        public InputStream getInputStream() throws IOException;

        public String getName();

        public String toString();
    }
}

