/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cached<V> {
    private final Object mySyncObject;
    @Nullable
    private volatile V myValue;
    @NotNull
    private final Calculator<V> myCalculator;

    public Cached(@NotNull Calculator<V> calculator) {
        if (calculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "jetbrains/buildServer/util/Cached", "<init>"));
        }
        this.mySyncObject = new Object();
        this.myCalculator = calculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public V get() {
        V value = this.myValue;
        if (value == null) {
            Object object = this.mySyncObject;
            synchronized (object) {
                value = this.myValue;
                if (value == null) {
                    value = this.myValue = this.myCalculator.calculate();
                }
            }
            assert (value != null);
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Cached", "get"));
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.mySyncObject;
        synchronized (object) {
            this.myValue = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Calculator<CV> {
        @NotNull
        public CV calculate();
    }
}

