/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPOutputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.TimePrinter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticUtil {
    public static final String FILE_DATE_FORMAT = "yyyy-MM-dd_HH.mm.ss";
    public static final String THREAD_DUMP_PREFIX = "threadDump";
    public static final String THREAD_DUMP_EXTENSION = ".txt";
    public static final String TC_TOTAL_MEMORY_USAGE_KEY = "TC_TOTAL_MEMORY_USAGE_KEY";
    public static final String THREAD_DUMP_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @NonNls
    private static final String EOL = System.getProperty("line.separator");
    @Nullable
    private static Method ourGetProcessCpuLoad;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";

    public static void threadDumpToLog(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadFactory factory = ((ThreadPoolExecutor)executorService).getThreadFactory();
            if (factory instanceof NamedThreadFactory) {
                NamedThreadFactory namedThreadFactory = (NamedThreadFactory)factory;
                DiagnosticUtil.threadDumpToLog(namedThreadFactory);
            }
            DiagnosticUtil.threadDumpToLog("Current thread: ", Thread.currentThread());
        }
    }

    public static void threadDumpToLog(@NotNull NamedThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadFactory", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToLog"));
        }
        DiagnosticUtil.warnToThreadFactoryLogger("Thread dump of " + threadFactory.toString() + EOL + threadFactory.getThreadDump());
    }

    public static void threadDumpToLog(@NotNull String message, @NotNull Thread thread) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToLog"));
        }
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToLog"));
        }
        StringBuilder sb = new StringBuilder();
        DiagnosticUtil.appendThreadStacktrace(sb, thread);
        DiagnosticUtil.warnToThreadFactoryLogger(message + sb.toString());
    }

    public static void warnToThreadFactoryLogger(String threadDump) {
        Logger.getInstance((String)"jetbrains.buildServer.util.NamedThreadFactory").warn(threadDump);
    }

    public static void threadDumpToStream(final @NotNull PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToStream"));
        }
        DiagnosticUtil.threadDumpInternal(new Printer(){

            public void println(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/DiagnosticUtil$1", "println"));
                }
                out.println(text);
            }

            public void println() {
                out.println();
            }

            public void print(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/DiagnosticUtil$1", "print"));
                }
                out.print(text);
            }
        }, new ThreadDumpData());
    }

    public static void threadDumpToStream(final @NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToStream"));
        }
        DiagnosticUtil.threadDumpInternal(new Printer(){

            public void println(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/DiagnosticUtil$2", "println"));
                }
                out.println(text);
            }

            public void println() {
                out.println();
            }

            public void print(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/DiagnosticUtil$2", "print"));
                }
                out.print(text);
            }
        }, new ThreadDumpData());
    }

    public static File threadDumpToDirectory(@Nullable File dir, @Nullable String suffix, @NotNull ThreadDumpData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToDirectory"));
        }
        if (dir != null && !dir.isDirectory()) {
            throw new IllegalArgumentException("Specified path is not a directory: " + dir.getAbsolutePath());
        }
        return DiagnosticUtil.threadDumpToFile(DiagnosticUtil.getDiagnosticFile(dir, StringUtil.isEmpty((String)suffix) ? THREAD_DUMP_PREFIX : suffix, THREAD_DUMP_EXTENSION), data);
    }

    public static File threadDumpToDirectory(@Nullable File dir, @NotNull ThreadDumpData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToDirectory"));
        }
        return DiagnosticUtil.threadDumpToDirectory(dir, null, data);
    }

    public static File threadDumpToFile(@NotNull File file, @NotNull ThreadDumpData data) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToFile"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToFile"));
        }
        String dump = DiagnosticUtil.threadDumpToString(data);
        FileUtil.writeFile(file, dump);
        return file;
    }

    public static File getDiagnosticFile(@Nullable File baseDir, @NotNull String suffix, @NotNull String ext) {
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "jetbrains/buildServer/util/DiagnosticUtil", "getDiagnosticFile"));
        }
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "jetbrains/buildServer/util/DiagnosticUtil", "getDiagnosticFile"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(FILE_DATE_FORMAT);
        File parentDir = baseDir == null ? new File(".") : baseDir;
        return new File(parentDir, sdf.format(Dates.now()) + "-" + suffix + ext).getAbsoluteFile();
    }

    @NotNull
    public static String threadDumpToString() {
        String string = DiagnosticUtil.threadDumpToString(new ThreadDumpData());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToString"));
        }
        return string;
    }

    @NotNull
    public static String threadDumpToString(@NotNull ThreadDumpData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToString"));
        }
        final StringBuilder sb = new StringBuilder();
        DiagnosticUtil.threadDumpInternal(new Printer(){

            public void println(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/DiagnosticUtil$3", "println"));
                }
                this.print(text);
                this.println();
            }

            public void println() {
                sb.append("\n");
            }

            public void print(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/DiagnosticUtil$3", "print"));
                }
                sb.append(text);
            }
        }, data);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpToString"));
        }
        return string;
    }

    private static void threadDumpInternal(Printer out, @NotNull ThreadDumpData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/DiagnosticUtil", "threadDumpInternal"));
        }
        if (data.getSummary() != null) {
            out.println(data.getSummary());
        }
        Date startTime = Dates.now();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ThreadMXBean bean = DiagnosticUtil.getThreadsBean();
        long currentThreadId = Thread.currentThread().getId();
        DiagnosticUtil.printHeader(out);
        for (Map.Entry<Thread, StackTraceElement[]> e : map.entrySet()) {
            ThreadGroup group;
            StackTraceElement[] el = e.getValue();
            Thread t = e.getKey();
            if (currentThreadId == t.getId()) continue;
            out.print(MessageFormat.format("\"{0}\" ", t.getName()));
            if (t.isDaemon()) {
                out.print("daemon ");
            }
            if ((group = t.getThreadGroup()) != null) {
                out.print(MessageFormat.format("group=\"{0}\" ", group.getName()));
            }
            out.print("prio=" + t.getPriority() + " ");
            out.print("tid=" + t.getId() + " ");
            out.print("nid=" + t.getId() + " ");
            Thread.State state = t.getState();
            if (state == Thread.State.RUNNABLE) {
                out.print("runnable ");
            }
            if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING) {
                out.print("waiting ");
            }
            if (state == Thread.State.BLOCKED) {
                out.print("blocked ");
            }
            ThreadInfo thInfo = bean == null ? null : bean.getThreadInfo(t.getId());
            DiagnosticUtil.writeThreadAllocatedBytes(t, out, bean);
            DiagnosticUtil.writeLocksInfo(thInfo, out);
            DiagnosticUtil.writeThreadState(thInfo, out);
            out.println();
            for (StackTraceElement line : el) {
                out.println("    at " + line);
            }
            out.println();
        }
        out.println();
        DiagnosticUtil.printMemoryUsage(out);
        out.println();
        DiagnosticUtil.printCpuUsage(out, data);
        out.println();
        out.println("Dump taken in " + TimePrinter.createMillisecondsFormatter().formatTime(Dates.now().getTime() - startTime.getTime()));
    }

    private static void writeThreadAllocatedBytes(@NotNull Thread thread, @NotNull Printer out, @Nullable ThreadMXBean threadMXBean) {
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "jetbrains/buildServer/util/DiagnosticUtil", "writeThreadAllocatedBytes"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "jetbrains/buildServer/util/DiagnosticUtil", "writeThreadAllocatedBytes"));
        }
        long[] stats = NamedThreadUtil.getThreadStatistics(thread, threadMXBean);
        if (stats != null && (stats[0] > 0L || stats[1] > 0L)) {
            out.print("[mem alloc: " + StringUtil.formatFileSize(stats[0]) + ", cpu time: " + 1.0f * (float)stats[1] / 1000.0f / 1000.0f + " s] ");
        }
    }

    public static void printMemoryUsage(Printer out) {
        out.println("Memory usage:");
        List<MemoryPoolMXBean> mpools = ManagementFactory.getMemoryPoolMXBeans();
        long totalUsed = 0L;
        long totalMax = 0L;
        String prefix = "   ";
        for (MemoryPoolMXBean pool : mpools) {
            MemoryUsage usage = pool.getUsage();
            StringBuilder line = new StringBuilder();
            line.append("   ").append(pool.getName()).append(": ");
            line.append("used = ").append(StringUtil.formatFileSize(usage.getUsed())).append(" ");
            line.append("committed = ").append(StringUtil.formatFileSize(usage.getCommitted())).append(" ");
            line.append("max = ").append(StringUtil.formatFileSize(usage.getMax())).append(" ");
            line.append(DiagnosticUtil.percent(usage.getUsed(), usage.getMax()));
            out.println(line.toString());
            totalUsed += usage.getUsed();
            totalMax += usage.getMax();
        }
        out.println("   Total: used = " + StringUtil.formatFileSize(totalUsed) + " max = " + StringUtil.formatFileSize(totalMax) + " " + DiagnosticUtil.percent(totalUsed, totalMax));
    }

    public static void printCpuUsage(Printer out, ThreadDumpData data) {
        String systemLoadAverage;
        out.println("CPU statistics:");
        out.println("   Available processors = " + data.getNumberOfProcessors());
        String javaProcessCpu = data.getJavaProcessCPULoad();
        if (javaProcessCpu != null) {
            out.println("   Java process = " + javaProcessCpu);
        }
        if ((systemLoadAverage = data.getSystemLoad()) != null) {
            out.println("   System overall = " + systemLoadAverage);
        }
    }

    private static double getJavaProcessCpuUsage(OperatingSystemMXBean os) {
        if (ourGetProcessCpuLoad != null) {
            try {
                return (Double)ourGetProcessCpuLoad.invoke((Object)os, new Object[0]);
            }
            catch (Exception e) {
                ourGetProcessCpuLoad = null;
            }
        }
        return -1.0;
    }

    @NotNull
    public static MemoryUsage getHeapMemoryUsage() {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memBean.getHeapMemoryUsage();
        if (memoryUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "getHeapMemoryUsage"));
        }
        return memoryUsage;
    }

    @Nullable
    public static MemoryUsage getPermGenPoolMemoryUsage() {
        for (MemoryPoolMXBean bean : DiagnosticUtil.getMemoryUsageBeans()) {
            if (!DiagnosticUtil.isPermGenPool(bean.getName())) continue;
            return bean.getUsage();
        }
        return null;
    }

    public static boolean isPermGenPool(String name) {
        return name.contains("Perm") || "class storage".equals(name);
    }

    public static List<MemoryPoolMXBean> getMemoryUsageBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    private static String percent(long used, long max) {
        String percentStr = "";
        if (max > 0L) {
            percentStr = "used/max = " + DiagnosticUtil.percent((double)used / (double)max);
        }
        return percentStr;
    }

    private static String percent(double val) {
        return String.format(Locale.ENGLISH, "%.2f%%", val * 100.0);
    }

    private static void printHeader(Printer out) {
        out.println(new SimpleDateFormat(THREAD_DUMP_DATE_PATTERN).format(Dates.now()));
        out.println(MessageFormat.format("Full thread dump {0} ({1} {2}):", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.info")));
        out.println();
    }

    private static ThreadMXBean getThreadsBean() {
        try {
            return ManagementFactory.getThreadMXBean();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void writeLocksInfo(ThreadInfo info, Printer ps) {
        if (info == null) {
            return;
        }
        String lock = info.getLockName();
        String lockOwner = info.getLockOwnerName();
        if (lock != null && lockOwner != null) {
            ps.println(MessageFormat.format("on {0}", lock));
            ps.print(MessageFormat.format("   by \"{0}\"", lockOwner));
        }
    }

    private static void writeThreadState(ThreadInfo info, Printer ps) {
        if (info == null) {
            return;
        }
        Thread.State state = info.getThreadState();
        ps.println();
        ps.print("   java.lang.Thread.State: " + state.name());
    }

    public static long getMaxPoolSize(String key) {
        if (TC_TOTAL_MEMORY_USAGE_KEY.equals(key)) {
            return DiagnosticUtil.getHeapMemoryUsage().getMax();
        }
        for (MemoryPoolMXBean bean : DiagnosticUtil.getMemoryUsageBeans()) {
            if (!bean.getName().equals(key)) continue;
            return bean.getUsage().getMax();
        }
        return -1L;
    }

    public static void appendThreadStacktrace(StringBuilder sb, Thread thread) {
        StackTraceElement[] trace;
        sb.append(thread.getName()).append(EOL);
        for (StackTraceElement aTrace : trace = thread.getStackTrace()) {
            sb.append("\tat ").append(aTrace).append(EOL);
        }
    }

    public static boolean memoryDumpAvailable() {
        try {
            return DiagnosticUtil.getHotspotMBean() != null;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @NotNull
    public static File memoryDump(@Nullable File hprofDir) throws Exception {
        File hprof = new File(hprofDir, "memoryDump-" + new SimpleDateFormat(FILE_DATE_FORMAT).format(Dates.now()) + ".hprof");
        Object mxbean = DiagnosticUtil.getHotspotMBean();
        if (mxbean == null) {
            throw new RuntimeException("Can't create HotSpotDiagnosticMXBean");
        }
        if (!hprof.exists()) {
            Method dumpHeap = mxbean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
            dumpHeap.invoke(mxbean, hprof.getAbsolutePath(), true);
        }
        File file = hprof;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "memoryDump"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File memoryDumpZipped(@Nullable File dir) throws Exception {
        File hprof = DiagnosticUtil.memoryDump(dir);
        File zippedHprof = new File(hprof.getAbsolutePath() + ".gz");
        BufferedInputStream fis = null;
        GZIPOutputStream os = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(hprof));
            os = new GZIPOutputStream(new FileOutputStream(zippedHprof));
            TCStreamUtil.writeBinary(fis, os);
        }
        catch (Throwable throwable) {
            FileUtil.close(os);
            FileUtil.close(fis);
            FileUtil.delete(hprof);
            throw throwable;
        }
        FileUtil.close(os);
        FileUtil.close(fis);
        FileUtil.delete(hprof);
        File file = zippedHprof;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "memoryDumpZipped"));
        }
        return file;
    }

    @NotNull
    public static List<String> getJVMArgs() {
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "getJVMArgs"));
        }
        return list;
    }

    @NotNull
    public static String getJVMArgsString() {
        List<String> jvmArgs = DiagnosticUtil.getJVMArgs();
        StringBuilder builder = new StringBuilder();
        for (String arg : jvmArgs) {
            builder.append(arg).append(" ");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "getJVMArgsString"));
        }
        return string;
    }

    public static String getUser() {
        return System.getProperty("user.name");
    }

    @NotNull
    public static String getJVMDiagnosticString() {
        String string = SystemInfo.JAVA_RUNTIME_VERSION + " " + DiagnosticUtil.getJVMName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "getJVMDiagnosticString"));
        }
        return string;
    }

    @NotNull
    public static String getJVMName() {
        String vmName = System.getProperty("java.vm.name");
        String bitness = System.getProperty("sun.arch.data.model");
        if (bitness != null && !vmName.contains(bitness)) {
            String string = vmName + " (" + bitness + " bit)";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "getJVMName"));
            }
            return string;
        }
        String string = vmName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil", "getJVMName"));
        }
        return string;
    }

    @Nullable
    private static Object getHotspotMBean() throws UnsupportedOperationException {
        try {
            final Class<?> hotSpotMxBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Set<ObjectName> s = server.queryNames(new ObjectName(DiagnosticUtil.HOTSPOT_BEAN_NAME), null);
                    Iterator<ObjectName> itr = s.iterator();
                    if (itr.hasNext()) {
                        ObjectName name = itr.next();
                        return ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), hotSpotMxBeanClass);
                    }
                    return null;
                }
            });
        }
        catch (Exception exp) {
            throw new UnsupportedOperationException(exp);
        }
    }

    static {
        try {
            ourGetProcessCpuLoad = ManagementFactory.getOperatingSystemMXBean().getClass().getMethod("getProcessCpuLoad", new Class[0]);
            if (ourGetProcessCpuLoad != null && !ourGetProcessCpuLoad.isAccessible()) {
                ourGetProcessCpuLoad.setAccessible(true);
            }
        }
        catch (Exception ignore) {
            ourGetProcessCpuLoad = null;
        }
    }

    public static class ThreadDumpData {
        @Nullable
        private final String myNumberOfProcessors;
        @Nullable
        private final String mySystemLoad;
        @Nullable
        private final String myJavaProcessLoad;
        @Nullable
        private String mySummary;

        public ThreadDumpData() {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            int availableProcessors = os.getAvailableProcessors();
            double javaProcessCpuUsage = DiagnosticUtil.getJavaProcessCpuUsage(os);
            this.myJavaProcessLoad = javaProcessCpuUsage >= 0.0 ? DiagnosticUtil.percent(javaProcessCpuUsage) : null;
            double systemLoadAverage = os.getSystemLoadAverage();
            this.mySystemLoad = systemLoadAverage >= 0.0 ? DiagnosticUtil.percent(systemLoadAverage / (double)availableProcessors) : null;
            this.myNumberOfProcessors = Integer.toString(availableProcessors);
        }

        public ThreadDumpData(@Nullable String numberOfProcessors, @Nullable String javaProcessLoad, @Nullable String systemLoad) {
            this.myNumberOfProcessors = numberOfProcessors;
            this.mySystemLoad = systemLoad;
            this.myJavaProcessLoad = javaProcessLoad;
        }

        @Nullable
        public String getSystemLoad() {
            return this.mySystemLoad;
        }

        @Nullable
        public String getJavaProcessCPULoad() {
            return this.myJavaProcessLoad;
        }

        @Nullable
        public String getNumberOfProcessors() {
            return this.myNumberOfProcessors;
        }

        @Nullable
        public String getSummary() {
            return this.mySummary;
        }

        @NotNull
        public ThreadDumpData withSummary(@Nullable String summary) {
            this.mySummary = summary;
            ThreadDumpData threadDumpData = this;
            if (threadDumpData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/DiagnosticUtil$ThreadDumpData", "withSummary"));
            }
            return threadDumpData;
        }
    }

    public static interface Printer {
        public void println(@NotNull String var1);

        public void println();

        public void print(@NotNull String var1);
    }
}

