/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import jetbrains.buildServer.util.Option;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOption<T extends Enum<T>>
extends Option<T> {
    private final Class<T> myEnumClass;

    public EnumOption(@NonNls @NotNull String key, @NotNull T defaultValue, @NotNull Class<T> enumClass) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/EnumOption", "<init>"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "jetbrains/buildServer/util/EnumOption", "<init>"));
        }
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "jetbrains/buildServer/util/EnumOption", "<init>"));
        }
        super(key, defaultValue);
        this.myEnumClass = enumClass;
    }

    @Override
    public T fromString(String value) {
        return Enum.valueOf(this.myEnumClass, value);
    }

    @Override
    public String toString(T value) {
        return ((Enum)value).toString();
    }
}

