/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.Converter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemSynchronizer<LocalItem, RemoteItem, ItemId> {
    @NotNull
    public List<Item> synchronize(@NotNull Collection<LocalItem> localItems, @NotNull Collection<RemoteItem> remoteItems) {
        ItemId itemId;
        if (localItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localItems", "jetbrains/buildServer/util/ItemSynchronizer", "synchronize"));
        }
        if (remoteItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteItems", "jetbrains/buildServer/util/ItemSynchronizer", "synchronize"));
        }
        Map<ItemId, RemoteItem> remoteItemIndex = this.buildRemoteItemIndex(remoteItems);
        if (remoteItemIndex.isEmpty()) {
            if (!this.canDeleteItems()) {
                List<Item> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer", "synchronize"));
                }
                return list;
            }
            if (!this.canDeleteAllItems()) {
                this.logRefusedToDeleteAllItems();
                List<Item> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer", "synchronize"));
                }
                return list;
            }
        }
        ArrayList<Item> items = new ArrayList<Item>();
        Map<ItemId, LocalItem> localItemIndex = this.buildLocalItemIndex(localItems);
        for (Map.Entry<ItemId, RemoteItem> entry : remoteItemIndex.entrySet()) {
            LocalItem newLocalItem;
            itemId = entry.getKey();
            RemoteItem remoteItem = entry.getValue();
            LocalItem localItem = localItemIndex.remove(itemId);
            if (localItem == null) {
                if (this.canCreateItems()) {
                    newLocalItem = this.createItem(remoteItem, itemId);
                    if (newLocalItem == null) continue;
                    items.add(new Item(newLocalItem, remoteItem, itemId));
                    continue;
                }
                this.logRefusedToCreateItem(remoteItem, itemId);
                continue;
            }
            newLocalItem = localItem;
            if (this.canUpdateItems()) {
                newLocalItem = this.updateItem(localItem, remoteItem, itemId);
            } else {
                this.logRefusedToUpdateItem(localItem, remoteItem, itemId);
            }
            items.add(new Item(newLocalItem, remoteItem, itemId));
        }
        for (Map.Entry<ItemId, Object> entry : localItemIndex.entrySet()) {
            itemId = entry.getKey();
            Object localItem = entry.getValue();
            if (this.canDeleteItems()) {
                this.deleteItem(localItem, itemId);
                continue;
            }
            this.logRefusedToDeleteItem(localItem, itemId);
        }
        ArrayList<Item> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer", "synchronize"));
        }
        return arrayList;
    }

    @Nullable
    protected abstract ItemId getLocalItemId(@NotNull LocalItem var1);

    @Nullable
    protected abstract ItemId getRemoteItemId(@NotNull RemoteItem var1);

    @Nullable
    protected abstract LocalItem createItem(@NotNull RemoteItem var1, @NotNull ItemId var2);

    @NotNull
    protected abstract LocalItem updateItem(@NotNull LocalItem var1, @NotNull RemoteItem var2, @NotNull ItemId var3);

    protected abstract void deleteItem(@NotNull LocalItem var1, @NotNull ItemId var2);

    protected boolean canCreateItems() {
        return true;
    }

    protected boolean canUpdateItems() {
        return true;
    }

    protected boolean canDeleteItems() {
        return true;
    }

    protected boolean canDeleteAllItems() {
        return true;
    }

    protected void logRefusedToCreateItem(@NotNull RemoteItem remoteItem, @NotNull ItemId itemId) {
        if (remoteItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteItem", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToCreateItem"));
        }
        if (itemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemId", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToCreateItem"));
        }
    }

    protected void logRefusedToUpdateItem(@NotNull LocalItem localItem, @NotNull RemoteItem remoteItem, @NotNull ItemId itemId) {
        if (localItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localItem", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToUpdateItem"));
        }
        if (remoteItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteItem", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToUpdateItem"));
        }
        if (itemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemId", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToUpdateItem"));
        }
    }

    protected void logRefusedToDeleteItem(@NotNull LocalItem localItem, @NotNull ItemId itemId) {
        if (localItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localItem", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToDeleteItem"));
        }
        if (itemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemId", "jetbrains/buildServer/util/ItemSynchronizer", "logRefusedToDeleteItem"));
        }
    }

    protected void logRefusedToDeleteAllItems() {
    }

    @NotNull
    protected Map<ItemId, LocalItem> buildLocalItemIndex(@NotNull Collection<LocalItem> localItems) {
        if (localItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localItems", "jetbrains/buildServer/util/ItemSynchronizer", "buildLocalItemIndex"));
        }
        Map<ItemId, LocalItem> map = ItemSynchronizer.buildItemIndex(localItems, new Converter<ItemId, LocalItem>(){

            @Override
            public ItemId createFrom(@NotNull LocalItem item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/ItemSynchronizer$1", "createFrom"));
                }
                return ItemSynchronizer.this.getLocalItemId(item);
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer", "buildLocalItemIndex"));
        }
        return map;
    }

    @NotNull
    protected Map<ItemId, RemoteItem> buildRemoteItemIndex(@NotNull Collection<RemoteItem> remoteItems) {
        if (remoteItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteItems", "jetbrains/buildServer/util/ItemSynchronizer", "buildRemoteItemIndex"));
        }
        Map<ItemId, RemoteItem> map = ItemSynchronizer.buildItemIndex(remoteItems, new Converter<ItemId, RemoteItem>(){

            @Override
            public ItemId createFrom(@NotNull RemoteItem item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/ItemSynchronizer$2", "createFrom"));
                }
                return ItemSynchronizer.this.getRemoteItemId(item);
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer", "buildRemoteItemIndex"));
        }
        return map;
    }

    @NotNull
    protected static <Item, ItemId> Map<ItemId, Item> buildItemIndex(@NotNull Collection<Item> items, @NotNull Converter<ItemId, Item> itemIdProvider) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "jetbrains/buildServer/util/ItemSynchronizer", "buildItemIndex"));
        }
        if (itemIdProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemIdProvider", "jetbrains/buildServer/util/ItemSynchronizer", "buildItemIndex"));
        }
        HashMap<ItemId, Item> result = new HashMap<ItemId, Item>();
        for (Item item : items) {
            ItemId itemId;
            if (item == null || (itemId = itemIdProvider.createFrom(item)) == null) continue;
            result.put(itemId, item);
        }
        HashMap<ItemId, Item> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer", "buildItemIndex"));
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Item {
        @NotNull
        private final LocalItem myLocalItem;
        @NotNull
        private final RemoteItem myRemoteItem;
        @NotNull
        private final ItemId myItemId;

        public Item(@NotNull LocalItem localItem, @NotNull RemoteItem remoteItem, ItemId itemId) {
            if (localItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localItem", "jetbrains/buildServer/util/ItemSynchronizer$Item", "<init>"));
            }
            if (remoteItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteItem", "jetbrains/buildServer/util/ItemSynchronizer$Item", "<init>"));
            }
            if (itemId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemId", "jetbrains/buildServer/util/ItemSynchronizer$Item", "<init>"));
            }
            this.myLocalItem = localItem;
            this.myRemoteItem = remoteItem;
            this.myItemId = itemId;
        }

        @NotNull
        public LocalItem getLocalItem() {
            Object LocalItem = this.myLocalItem;
            if (LocalItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer$Item", "getLocalItem"));
            }
            return LocalItem;
        }

        @NotNull
        public RemoteItem getRemoteItem() {
            Object RemoteItem = this.myRemoteItem;
            if (RemoteItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer$Item", "getRemoteItem"));
            }
            return RemoteItem;
        }

        @NotNull
        public ItemId getItemId() {
            Object ItemId = this.myItemId;
            if (ItemId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ItemSynchronizer$Item", "getItemId"));
            }
            return ItemId;
        }
    }
}

