/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPool {
    private static final String JAVA_SPEC_VERSION = System.getProperty("java.specification.version");
    private static final boolean OUR_USE_STRING_INTERN = !"1.6".equals(JAVA_SPEC_VERSION) && !"1.5".equals(JAVA_SPEC_VERSION) && !"1.4".equals(JAVA_SPEC_VERSION);
    private static final int BUFFER_SIZE_WHEN_INTERN_USED = 3000;
    private static final ConcurrentMap<String, String> ourPooledStrings = new ConcurrentHashMap<String, String>(30000);

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String getFromPool(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return StringPool.reuse(value);
    }

    @NotNull
    public static String reuse(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/util/StringPool", "reuse"));
        }
        String res = (String)ourPooledStrings.get(value);
        if (res != null) {
            String string = res;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringPool", "reuse"));
            }
            return string;
        }
        res = value;
        if (OUR_USE_STRING_INTERN) {
            res = value.intern();
            if (ourPooledStrings.size() > 3000) {
                ourPooledStrings.clear();
            }
        }
        ourPooledStrings.putIfAbsent(res, res);
        String string = res;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringPool", "reuse"));
        }
        return string;
    }

    public static void clearPool() {
        ourPooledStrings.clear();
    }
}

