/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.CharFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.util.RandomGenerator;
import jetbrains.buildServer.util.StringUtils;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.filters.FilterUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil
extends com.intellij.openapi.util.text.StringUtil {
    public static final char[] DEFAULT_SEPARATORS = new char[]{' ', ',', '\n', '\r', '\t', ';'};
    public static final String EMPTY = "";
    @NonNls
    public static final String NA = "N/A";
    public static final Filter<String> NOT_EMPTY_STRING_FILTER = new Filter<String>(){

        @Override
        public boolean accept(@NotNull String data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/StringUtil$1", "accept"));
            }
            return data.length() > 0;
        }
    };
    private static final String DEFAULT_DATE_FORMAT = "dd MMM yy HH:mm";
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final String B_POSTFIX = " B";
    public static final String KB_POSTFIX = " KB";
    public static final String MB_POSTFIX = " MB";
    public static final String GB_POSTFIX = " GB";
    public static final String TB_POSTFIX = " TB";
    private static final RandomGenerator myRandom = new RandomGenerator();
    @Deprecated
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        public char escape(char c) {
            return MapSerializerUtil.STD_ESCAPER.escape(c);
        }

        public char unescape(char c) {
            return MapSerializerUtil.STD_ESCAPER.unescape(c);
        }

        public char escapeCharacter() {
            return MapSerializerUtil.STD_ESCAPER.escapeCharacter();
        }
    };
    public static final EscapeInfoProvider2 STD_ESCAPER2 = new EscapeInfoProvider2(){

        @Nullable
        public String escape(char c) {
            return MapSerializerUtil.STD_ESCAPER2.escape(c);
        }

        @Nullable
        public MapSerializerUtil.UnescapeResult unescape(@NotNull String str, int startPos) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil$3", "unescape"));
            }
            return MapSerializerUtil.STD_ESCAPER2.unescape(str, startPos);
        }

        public char escapeCharacter() {
            return MapSerializerUtil.STD_ESCAPER2.escapeCharacter();
        }
    };

    private StringUtil() {
    }

    @Contract(value="null, null -> true")
    public static boolean areEqual(@Nullable String string1, @Nullable String string2) {
        return string1 == string2 || string1 != null && string2 != null && string1.equals(string2);
    }

    @Contract(value="null, null -> true")
    public static boolean areEqualIgnoringCase(@Nullable String string1, @Nullable String string2) {
        return string1 == string2 || string1 != null && string2 != null && string1.equalsIgnoreCase(string2);
    }

    public static boolean differCaseOnly(@NotNull String string1, @NotNull String string2) {
        if (string1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string1", "jetbrains/buildServer/util/StringUtil", "differCaseOnly"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string2", "jetbrains/buildServer/util/StringUtil", "differCaseOnly"));
        }
        return string1.equalsIgnoreCase(string2) && !string1.equals(string2);
    }

    public static boolean isUpperCase(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "isUpperCase"));
        }
        boolean hasUppercaseLetters = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            hasUppercaseLetters |= Character.isUpperCase(c);
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return hasUppercaseLetters;
    }

    @NotNull
    public static String escapeHTML(@Nullable String text, boolean replaceQuotes) {
        if (text == null) {
            if (EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "escapeHTML"));
            }
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"' && replaceQuotes) {
                result.append("&quot;");
            } else if (character == '\'' && replaceQuotes) {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "escapeHTML"));
        }
        return string;
    }

    @NotNull
    public static List<String> splitCommandArgumentsAndUnquote(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "jetbrains/buildServer/util/StringUtil", "splitCommandArgumentsAndUnquote"));
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if ((c == '\"' || c == '\'') && StringUtil.isNotEscapedQuote(line, i)) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        List<String> list = StringUtil.removeQuotes(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "splitCommandArgumentsAndUnquote"));
        }
        return list;
    }

    @NotNull
    private static List<String> removeQuotes(@NotNull List<String> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "jetbrains/buildServer/util/StringUtil", "removeQuotes"));
        }
        for (int i = 0; i < result.size(); ++i) {
            String value = StringUtil.unquoteString((String)result.get(i));
            result.set(i, value);
        }
        List<String> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "removeQuotes"));
        }
        return list;
    }

    private static boolean isNotEscapedQuote(@NotNull String line, int i) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "jetbrains/buildServer/util/StringUtil", "isNotEscapedQuote"));
        }
        if (i == 0) {
            return true;
        }
        if (line.charAt(i - 1) == '\\') {
            int j;
            for (j = i + 1; j < line.length(); ++j) {
                if (Character.isWhitespace(line.charAt(j))) continue;
                return line.charAt(j) == '-' || line.charAt(j) == '\"' && j + 1 < line.length() && line.charAt(j + 1) == '-';
            }
            return j == line.length();
        }
        return true;
    }

    @NotNull
    public static String biteOffPostfix(@NotNull String line, @NotNull String postfix) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "jetbrains/buildServer/util/StringUtil", "biteOffPostfix"));
        }
        if (postfix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfix", "jetbrains/buildServer/util/StringUtil", "biteOffPostfix"));
        }
        String string = line.substring(0, line.length() - postfix.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "biteOffPostfix"));
        }
        return string;
    }

    @NotNull
    public static String lastPartOf(@NotNull String s, char separator) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/buildServer/util/StringUtil", "lastPartOf"));
        }
        int i = s.lastIndexOf(separator);
        if (i >= 0) {
            String string = s.substring(i + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "lastPartOf"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "lastPartOf"));
        }
        return string;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String truncateStringValue(@Nullable String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("The 'maxLength' parameter must not be negative.");
        }
        int n = str.length();
        return n <= maxLength ? str : str.substring(0, maxLength);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String truncateStringValueWithDotsAtEnd(@Nullable String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 1 - 3) + "...";
        }
        return str;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String truncateStringValueWithDotsAtCenter(@Nullable String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLength) {
            String start = str.substring(0, maxLength / 2);
            String dots = "...";
            String end = str.substring(str.length() - start.length() - dots.length(), str.length());
            return start + dots + end;
        }
        return str;
    }

    public static boolean isValidXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd' || '\u10000' <= c && c <= '\u10ffff';
    }

    public static int findInvalidXMLChar(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/util/StringUtil", "findInvalidXMLChar"));
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (StringUtil.isValidXMLChar(chars[i])) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static String replaceInvalidXmlChars(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "replaceInvalidXmlChars"));
        }
        int firstInvalid = StringUtil.findInvalidXMLChar(str);
        if (firstInvalid > -1) {
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            sb.append(str, 0, firstInvalid);
            for (int i = firstInvalid; i < len; ++i) {
                char c = str.charAt(i);
                sb.append(StringUtil.isValidXMLChar(c) ? c : (char)' ');
            }
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "replaceInvalidXmlChars"));
            }
            return string;
        }
        String string = str;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "replaceInvalidXmlChars"));
        }
        return string;
    }

    @NotNull
    public static String generateUniqueHash() {
        String string = StringUtil.generateUniqueHash(myRandom.getRandom());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "generateUniqueHash"));
        }
        return string;
    }

    @NotNull
    public static String generateUniqueHashQuickly() {
        String string = StringUtil.generateUniqueHash(new Random(System.nanoTime()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "generateUniqueHashQuickly"));
        }
        return string;
    }

    @NotNull
    private static String generateUniqueHash(@NotNull Random random) {
        if (random == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "random", "jetbrains/buildServer/util/StringUtil", "generateUniqueHash"));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            int rand;
            sb.append((char)(rand += (rand = (int)(random.nextDouble() * 62.0)) < 10 ? 48 : (rand < 36 ? 55 : 61)));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "generateUniqueHash"));
        }
        return string;
    }

    @NotNull
    public static Pattern searchByKeywordPattern(@NotNull String keyword, boolean caseInsensitive) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "jetbrains/buildServer/util/StringUtil", "searchByKeywordPattern"));
        }
        String escapedKeyword = StringUtil.escapeForRegex(keyword);
        int flags = 0;
        if (caseInsensitive) {
            flags = 66;
        }
        Pattern pattern = Pattern.compile(".*\\b" + escapedKeyword + ".*", flags);
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "searchByKeywordPattern"));
        }
        return pattern;
    }

    @NotNull
    public static String escapeForRegex(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "escapeForRegex"));
        }
        String string = Pattern.quote(str);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "escapeForRegex"));
        }
        return string;
    }

    private static boolean mustEscapeInRegexp(char c) {
        switch (c) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String convertWildcardToRegexp(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "jetbrains/buildServer/util/StringUtil", "convertWildcardToRegexp"));
        }
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    result.append(".*");
                    continue block4;
                }
                case '?': {
                    result.append(".");
                    continue block4;
                }
                default: {
                    if (StringUtil.mustEscapeInRegexp(c)) {
                        result.append('\\');
                    }
                    result.append(c);
                }
            }
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "convertWildcardToRegexp"));
        }
        return string;
    }

    @NotNull
    public static List<String> split(@NotNull String values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "jetbrains/buildServer/util/StringUtil", "split"));
        }
        List<String> list = StringUtil.split(values.trim(), true, DEFAULT_SEPARATORS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "split"));
        }
        return list;
    }

    @NotNull
    public static List<String> split(@NotNull String values, boolean removeEmpty, char ... separators) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "jetbrains/buildServer/util/StringUtil", "split"));
        }
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "jetbrains/buildServer/util/StringUtil", "split"));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (values.isEmpty()) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "split"));
            }
            return arrayList;
        }
        char[] currentWord = new char[values.length()];
        int currentEndPosition = 0;
        for (int i = 0; i < values.length(); ++i) {
            char currentChar = values.charAt(i);
            if (StringUtil.isSeparator(currentChar, separators)) {
                result.add(new String(currentWord, 0, currentEndPosition));
                currentEndPosition = 0;
                continue;
            }
            currentWord[currentEndPosition] = currentChar;
            ++currentEndPosition;
        }
        if (currentEndPosition > 0) {
            result.add(new String(currentWord, 0, currentEndPosition));
        }
        if (removeEmpty) {
            List list = FilterUtil.filterCollection(result, NOT_EMPTY_STRING_FILTER);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "split"));
            }
            return list;
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "split"));
        }
        return arrayList;
    }

    private static boolean isSeparator(char currentChar, @NotNull char[] separators) {
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "jetbrains/buildServer/util/StringUtil", "isSeparator"));
        }
        for (char separator : separators) {
            if (currentChar != separator) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isAPositiveNumber(@Nullable String value) {
        if (value == null) {
            return false;
        }
        try {
            int intValue = Integer.parseInt(value);
            return intValue > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Contract(value="null -> false")
    public static boolean isNumber(@Nullable String value) {
        if (value == null) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    public static String getOrdinal(int number) {
        String txt;
        int remains = number - 10 * (number / 10);
        switch (remains) {
            case 1: {
                txt = "st";
                break;
            }
            case 2: {
                txt = "nd";
                break;
            }
            case 3: {
                txt = "rd";
                break;
            }
            default: {
                txt = "th";
            }
        }
        String string = txt;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "getOrdinal"));
        }
        return string;
    }

    @NotNull
    public static String stackTrace(@NotNull Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "jetbrains/buildServer/util/StringUtil", "stackTrace"));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(buffer);
        exception.printStackTrace(printStream);
        printStream.close();
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stackTrace"));
        }
        return string;
    }

    @NotNull
    public static String join(@Nullable String separator, @NotNull Iterable toJoin) {
        if (toJoin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toJoin", "jetbrains/buildServer/util/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(separator, toJoin, result);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "join"));
        }
        return string;
    }

    public static void join(@Nullable String separator, @NotNull Iterable toJoin, @NotNull StringBuilder result) {
        if (toJoin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toJoin", "jetbrains/buildServer/util/StringUtil", "join"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "jetbrains/buildServer/util/StringUtil", "join"));
        }
        if (separator == null) {
            separator = EMPTY;
        }
        Iterator it = toJoin.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item == null) continue;
            result.append(item);
            if (!it.hasNext()) continue;
            result.append(separator);
        }
    }

    @NotNull
    public static String join(@Nullable String separator, Object ... toJoin) {
        if (toJoin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toJoin", "jetbrains/buildServer/util/StringUtil", "join"));
        }
        String string = StringUtil.join(separator, Arrays.asList(toJoin));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    public static String doubleQuote(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/util/StringUtil", "doubleQuote"));
        }
        String string2 = '\"' + string + '\"';
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "doubleQuote"));
        }
        return string2;
    }

    public static Iterator<String> createEscapedTokenizer(String string, char del) {
        return new MyTokenizerIterator(string, del);
    }

    @Deprecated
    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        return MapSerializerUtil.indexOf(currentString, findWhat, escaper);
    }

    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider2 escaper) {
        return MapSerializerUtil.indexOf(currentString, findWhat, escaper);
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        Map<String, String> map = StringUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider2 escaper) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        Map<String, String> map = StringUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        Map<String, String> map = MapSerializerUtil.stringToProperties(string, escaper, strictNameCheck);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider2 escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        Map<String, String> map = MapSerializerUtil.stringToProperties(string, escaper, strictNameCheck);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stringToProperties"));
        }
        return map;
    }

    @Deprecated
    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider escaper) {
        return MapSerializerUtil.propertiesToString(props, escaper);
    }

    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider2 escaper) {
        return MapSerializerUtil.propertiesToString(props, escaper);
    }

    public static String repeat(String whatRepeat, String separator, int times) {
        StringBuilder result = new StringBuilder();
        StringUtil.repeat(whatRepeat, separator, times, result);
        return result.toString();
    }

    public static void repeat(String whatRepeat, String separator, int times, StringBuilder builder) {
        for (int i = 0; i < times; ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            builder.append(whatRepeat);
        }
    }

    @Contract(value="null -> false")
    public static boolean isTrue(@Nullable String property) {
        return Boolean.parseBoolean(property) || "yes".equalsIgnoreCase(property);
    }

    public static String escapeQuotesIfWindows(String value) {
        if (SystemInfo.isWindows) {
            value = StringUtil.escapeQuotes((String)value);
        }
        return value;
    }

    public static void convertStringsToLowerCase(@NotNull List<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "jetbrains/buildServer/util/StringUtil", "convertStringsToLowerCase"));
        }
        ListIterator<String> it = strings.listIterator();
        while (it.hasNext()) {
            String lower;
            String orig = it.next();
            if (orig == null || orig.equals(lower = orig.toLowerCase())) continue;
            it.set(lower);
        }
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String removeTailingSlash(@Nullable String path) {
        return path != null ? StringUtil.removeSuffix(path, "/", true) : null;
    }

    public static String removeSuffix(@NotNull String string, @NotNull String suffix, boolean caseSensitive) {
        int m;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/util/StringUtil", "removeSuffix"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "jetbrains/buildServer/util/StringUtil", "removeSuffix"));
        }
        int n = string.length();
        if (n < (m = suffix.length())) {
            return string;
        }
        boolean toRemove = caseSensitive ? string.endsWith(suffix) : string.substring(n - m).equalsIgnoreCase(suffix);
        return toRemove ? string.substring(0, n - m) : string;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String removeLeadingSlash(@Nullable String path) {
        return path != null && path.startsWith("/") ? path.substring(1) : path;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String removeLeadingAndTailingSlash(@Nullable String path) {
        return StringUtil.removeLeadingSlash(StringUtil.removeTailingSlash(path));
    }

    public static void replace(@NotNull StringBuilder buf, @NotNull String what, @NotNull String with) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "jetbrains/buildServer/util/StringUtil", "replace"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "jetbrains/buildServer/util/StringUtil", "replace"));
        }
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "jetbrains/buildServer/util/StringUtil", "replace"));
        }
        int pos = buf.indexOf(what);
        int n = what.length();
        int m = with.length();
        while (pos >= 0) {
            buf.replace(pos, pos + n, with);
            pos = buf.indexOf(what, pos + m);
        }
    }

    public static void replace(@NotNull StringBuilder buf, @NotNull Pattern pattern, @NotNull String with) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "jetbrains/buildServer/util/StringUtil", "replace"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "jetbrains/buildServer/util/StringUtil", "replace"));
        }
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "jetbrains/buildServer/util/StringUtil", "replace"));
        }
        Matcher matcher = pattern.matcher(buf);
        boolean found = matcher.find();
        while (found) {
            int p1 = matcher.start();
            int p2 = matcher.end();
            buf.replace(p1, p2, with);
            found = matcher.find(p1 + with.length());
        }
    }

    public static int compare(@Nullable String s1, @Nullable String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    @NotNull
    public static String convertAndCollapseSlashes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/buildServer/util/StringUtil", "convertAndCollapseSlashes"));
        }
        StringBuilder sb = new StringBuilder(s.length());
        boolean prevIsSlash = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '/') {
                if (!prevIsSlash) {
                    sb.append('/');
                }
                prevIsSlash = true;
                continue;
            }
            sb.append(c);
            prevIsSlash = false;
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "convertAndCollapseSlashes"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processLines(@NotNull String str, @NotNull LineProcessor processor) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        BufferedReader reader = new BufferedReader(new StringReader(str));
        try {
            StringUtil.processLines(reader, processor);
        }
        finally {
            reader.close();
        }
    }

    private static void processLines(@NotNull BufferedReader reader, @NotNull LineProcessor processor) throws IOException {
        String line;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        while ((line = reader.readLine()) != null) {
            if (!processor.processLine(line)) continue;
            return;
        }
    }

    @NotNull
    public static String formatPercent(float numerator, long denominator) {
        if (denominator == 0L || numerator == 0.0f) {
            if ("0%" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatPercent"));
            }
            return "0%";
        }
        long percent = Math.round(100.0 * (double)numerator / (double)denominator);
        if (percent == 0L) {
            if ("<1%" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatPercent"));
            }
            return "<1%";
        }
        String string = percent + "%";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatPercent"));
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(long fileSize) {
        String string = StringUtil.formatFileSize(fileSize, 2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatFileSize"));
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(long fileSize, int maxFractionDigits) {
        DecimalFormat f = new DecimalFormat();
        DecimalFormatSymbols custom = new DecimalFormatSymbols();
        custom.setDecimalSeparator('.');
        f.setDecimalFormatSymbols(custom);
        f.setRoundingMode(RoundingMode.FLOOR);
        f.setMaximumFractionDigits(maxFractionDigits);
        if (fileSize >= 0x10000000000L) {
            String string = f.format((double)fileSize / 1.099511627776E12) + TB_POSTFIX;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatFileSize"));
            }
            return string;
        }
        if (fileSize >= 0x40000000L) {
            String string = f.format((double)fileSize / 1.073741824E9) + GB_POSTFIX;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatFileSize"));
            }
            return string;
        }
        if (fileSize >= 0x100000L) {
            String string = f.format((double)fileSize / 1048576.0) + MB_POSTFIX;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatFileSize"));
            }
            return string;
        }
        if (fileSize >= 1024L) {
            String string = f.format((double)fileSize / 1024.0) + KB_POSTFIX;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatFileSize"));
            }
            return string;
        }
        String string = fileSize + B_POSTFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatFileSize"));
        }
        return string;
    }

    public static long parseFileSize(@NotNull String fileSizeStr) throws NumberFormatException {
        if (fileSizeStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSizeStr", "jetbrains/buildServer/util/StringUtil", "parseFileSize"));
        }
        String value = fileSizeStr.replace(" ", EMPTY).trim().toLowerCase();
        if (value.length() >= 3) {
            if (value.endsWith("kb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 1024L;
            }
            if (value.endsWith("mb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 0x100000L;
            }
            if (value.endsWith("gb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 0x40000000L;
            }
            if (value.endsWith("tb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 0x10000000000L;
            }
        }
        if (value.length() >= 4) {
            if (value.endsWith("kib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 1024L;
            }
            if (value.endsWith("mib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 0x100000L;
            }
            if (value.endsWith("gib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 0x40000000L;
            }
            if (value.endsWith("tib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 0x10000000000L;
            }
        }
        return Long.parseLong(fileSizeStr);
    }

    public static void processLines(@NotNull InputStream in, @NotNull LineProcessor processor) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringUtil.processLines(reader, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processLines(@NotNull File file, @NotNull LineProcessor processor) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/util/StringUtil", "processLines"));
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            StringUtil.processLines(in, processor);
        }
        finally {
            in.close();
        }
    }

    @Deprecated
    public static String escapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.escapeStr(str, p);
    }

    public static String escapeStr(String str, EscapeInfoProvider2 p) {
        return MapSerializerUtil.escapeStr(str, p);
    }

    @Deprecated
    public static String unescapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.unescapeStr(str, p);
    }

    public static String unescapeStr(String str, EscapeInfoProvider2 p) {
        return MapSerializerUtil.unescapeStr(str, p);
    }

    public static String formatTextForWeb(String txt) {
        if (txt == null) {
            return null;
        }
        return StringUtil.escapeHTML(txt, true).replace("\r\n", "\n").replace("\t", "    ").replace(" ", "&nbsp;").replace("\n", "<br />\n");
    }

    public static String replaceNonAlphaNumericChars(String originalStr, char toReplace) {
        return StringUtils.replaceNonAlphaNumericChars(originalStr, toReplace);
    }

    @Nullable
    @Contract(value="null, _, _, _ -> null; !null, _, _, _ -> !null")
    public static String peekNthDelimitedField(@Nullable String string, char separator, int nth, boolean trim) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int pos1 = nth == 1 ? -1 : n;
        int pos2 = n;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != separator) continue;
            if (++k == nth - 1) {
                pos1 = i;
            }
            if (k != nth) continue;
            pos2 = i;
        }
        assert (pos1 <= pos2);
        if (pos1 >= -1 && pos1 < pos2 && pos2 <= n) {
            if (trim) {
                return string.substring(pos1 + 1, pos2).trim();
            }
            return string.substring(pos1 + 1, pos2);
        }
        return EMPTY;
    }

    public static char charAt(@Nullable String string, int position) {
        int n = string != null ? string.length() : 0;
        return position < n ? string.charAt(position) : (char)'\u0000';
    }

    @Contract(value="null -> null")
    @Nullable
    public static String nullIfEmpty(@Nullable String string) {
        return string != null && string.length() > 0 ? string : null;
    }

    @NotNull
    public static String emptyIfNull(@Nullable String string) {
        String string2 = string != null && string.length() > 0 ? string : EMPTY;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "emptyIfNull"));
        }
        return string2;
    }

    @NotNull
    public static String notEmpty(@Nullable String string, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "jetbrains/buildServer/util/StringUtil", "notEmpty"));
        }
        String string2 = string != null && string.length() > 0 ? string : defaultValue;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "notEmpty"));
        }
        return string2;
    }

    @Nullable
    @Contract(value="null->null; !null->!null")
    public static String trim(@Nullable String s) {
        return s != null ? s.trim() : null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static String trimAndNull(@Nullable String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String trimRight(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0 || !Character.isWhitespace(string.charAt(n - 1))) {
            return string;
        }
        StringBuilder buf = new StringBuilder(string);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.delete(buf.length() - 1, buf.length());
        }
        return buf.toString();
    }

    public static void trimStringBuilderLeft(@NotNull StringBuilder buf) {
        int k;
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "jetbrains/buildServer/util/StringUtil", "trimStringBuilderLeft"));
        }
        int n = buf.length();
        for (k = 0; k < n && Character.isWhitespace(buf.charAt(k)); ++k) {
        }
        if (k > 0) {
            buf.delete(0, k);
        }
    }

    @NotNull
    public static String stripLeftAndRight(@NotNull String s, @NotNull CharFilter filter) {
        int right;
        int left;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/buildServer/util/StringUtil", "stripLeftAndRight"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/StringUtil", "stripLeftAndRight"));
        }
        for (left = 0; left < s.length() && filter.accept(s.charAt(left)); ++left) {
        }
        for (right = s.length() - 1; right >= 0 && filter.accept(s.charAt(right)); --right) {
        }
        String string = s.substring(left, right + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stripLeftAndRight"));
        }
        return string;
    }

    @NotNull
    public static String elapsedTimeToString(@Nullable Date date) {
        if (date == null) {
            if (EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return EMPTY;
        }
        String string = StringUtil.elapsedTimeToString(System.currentTimeMillis() - date.getTime());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
        }
        return string;
    }

    @NotNull
    public static String elapsedTimeToString(long millis) {
        long seconds = millis / 1000L;
        int hour = 3600;
        int day = 86400;
        if (millis < 0L) {
            if (seconds >= -5L) {
                if ("in a moment" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return "in a moment";
            }
            if (seconds > -60L) {
                if ("in several seconds" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return "in several seconds";
            }
            if (seconds > -120L) {
                if ("in a minute" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return "in a minute";
            }
            if (seconds > -3600L) {
                String string = "in " + -seconds / 60L + " minutes";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return string;
            }
            if ((double)seconds > -3960.0000000000005) {
                if ("in an hour" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return "in an hour";
            }
            if (seconds > -7200L) {
                String string = "in 1 hour " + (-seconds - 3600L) / 60L + " min";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return string;
            }
            if (seconds > -10800L) {
                String string = "in 2 hours " + (-seconds - 7200L) / 60L + " min";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return string;
            }
            if (seconds > -86400L) {
                String string = "in " + -seconds / 3600L + " hours";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return string;
            }
            if (seconds > -172800L) {
                if ("in a day" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
                }
                return "in a day";
            }
            String string = "in " + -seconds / 86400L + " days";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return string;
        }
        if (seconds < 5L) {
            if ("moments ago" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return "moments ago";
        }
        if (seconds < 20L) {
            if ("seconds ago" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return "seconds ago";
        }
        if (seconds < 120L) {
            if ("one minute ago" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return "one minute ago";
        }
        if (seconds < 3600L) {
            String string = seconds / 60L + " minutes ago";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return string;
        }
        if (seconds < 7200L) {
            if ("one hour ago" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return "one hour ago";
        }
        if (seconds < 86400L) {
            String string = seconds / 3600L + " hours ago";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return string;
        }
        if (seconds < 172800L) {
            if ("one day ago" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return "one day ago";
        }
        if (seconds < 2592000L) {
            String string = seconds / 86400L + " days ago";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return string;
        }
        if (seconds < 5184000L) {
            if ("one month ago" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
            }
            return "one month ago";
        }
        String string = seconds / 2592000L + " months ago";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "elapsedTimeToString"));
        }
        return string;
    }

    @NotNull
    public static String dateToString(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "jetbrains/buildServer/util/StringUtil", "dateToString"));
        }
        String string = new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(date);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "dateToString"));
        }
        return string;
    }

    @NotNull
    public static String formatInt(int value, int length, char fillChar) {
        StringBuilder builder = new StringBuilder(length);
        builder.append(value);
        while (builder.length() < length) {
            builder.insert(0, fillChar);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatInt"));
        }
        return string;
    }

    @NotNull
    public static String formatInt(int value, int length) {
        String string = StringUtil.formatInt(value, length, '0');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatInt"));
        }
        return string;
    }

    @NotNull
    public static String formatInt(int value) {
        String string = StringUtil.formatInt(value, 2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "formatInt"));
        }
        return string;
    }

    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/buildServer/util/StringUtil", "splitHonorQuotes"));
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        Character quoteSymbol = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && quoteSymbol == null) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                if (quoteSymbol == null) {
                    quoteSymbol = Character.valueOf(c);
                } else if (quoteSymbol.charValue() == c) {
                    quoteSymbol = null;
                }
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "splitHonorQuotes"));
        }
        return arrayList;
    }

    public static String substringByRegex(CharSequence text, Pattern pattern, int groupNr) {
        if (pattern == null) {
            throw new IllegalArgumentException("Called substringByRegex with null pattern.");
        }
        if (text == null) {
            return null;
        }
        Matcher m = pattern.matcher(text);
        boolean found = m.find();
        if (!found) {
            return null;
        }
        return m.group(groupNr);
    }

    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/buildServer/util/StringUtil", "splitHonorQuotes"));
        }
        List<String> list = StringUtil.splitHonorQuotes(s, ' ');
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "splitHonorQuotes"));
        }
        return list;
    }

    @NotNull
    public static String stringValueOf(@Nullable Object obj, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "jetbrains/buildServer/util/StringUtil", "stringValueOf"));
        }
        String string = obj == null ? defaultValue : String.valueOf(obj);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "stringValueOf"));
        }
        return string;
    }

    public static String collapseSpaces(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "collapseSpaces"));
        }
        boolean lastCharIsWhitespace = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            boolean isWhitespace;
            char c = str.charAt(i);
            boolean bl = isWhitespace = c == ' ' || c == '\n' || c == '\r' || c == '\t';
            if (isWhitespace) {
                if (!lastCharIsWhitespace) {
                    result.append(c);
                }
                lastCharIsWhitespace = true;
                continue;
            }
            result.append(c);
            lastCharIsWhitespace = false;
        }
        return result.toString();
    }

    public static String newLineToSpaceDelimited(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "newLineToSpaceDelimited"));
        }
        return str.replaceAll("[\r\n]+", " ").trim();
    }

    public static boolean hasParameterReferences(@Nullable String str) {
        if (StringUtil.isEmpty((String)str)) {
            return false;
        }
        return ReferencesResolverUtil.containsReference(str, new String[0], true);
    }

    @NotNull
    public static String removeNonBMPCharacters(@NotNull String str) {
        char c;
        int k;
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil", "removeNonBMPCharacters"));
        }
        int n = str.length();
        for (k = 0; k < n && (c = str.charAt(k)) < '\ud800'; ++k) {
        }
        if (k == n) {
            String string = str;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "removeNonBMPCharacters"));
            }
            return string;
        }
        StringBuilder buf = new StringBuilder(str);
        do {
            buf.setCharAt(k, '?');
            if (++k < n && buf.charAt(k) >= '\udb00') {
                buf.deleteCharAt(k);
                --n;
            }
            while (k < n && buf.charAt(k) < '\ud800') {
                ++k;
            }
        } while (k < n);
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "removeNonBMPCharacters"));
        }
        return string;
    }

    @NotNull
    public static String escapeForCSV(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "jetbrains/buildServer/util/StringUtil", "escapeForCSV"));
        }
        if (s.indexOf(34) >= 0 || s.indexOf(44) >= 0) {
            s = "\"" + s.replace("\"", "\"\"") + "\"";
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/StringUtil", "escapeForCSV"));
        }
        return string;
    }

    public static void escapeDataForCSV(PrintWriter writer, String ... data) {
        for (int i = 0; i < data.length; ++i) {
            String s = data[i];
            writer.append(StringUtil.escapeForCSV(s));
            if (i != data.length - 1) {
                writer.append(',');
                continue;
            }
            writer.append("\r\n");
        }
    }

    @Nullable
    @Contract(value="null -> null")
    public static String objectToString(@Nullable Object object) {
        return object == null ? null : object.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyTokenizerIterator
    implements Iterator<String> {
        private int myNextPosition = 0;
        private final String myString;
        private final char myDel;

        public MyTokenizerIterator(String string, char del) {
            this.myString = string;
            this.myDel = del;
        }

        @Override
        public boolean hasNext() {
            return this.myNextPosition < this.myString.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int lastIndex = this.myNextPosition;
            while (lastIndex < this.myString.length()) {
                char nextChar = this.myString.charAt(lastIndex);
                if (nextChar == '\\') {
                    if (nextChar == this.myString.length() - 1) {
                        try {
                            String string = this.myString.substring(this.myNextPosition);
                            return string;
                        }
                        finally {
                            this.myNextPosition = lastIndex + 1;
                        }
                    }
                    ++lastIndex;
                    ++lastIndex;
                    continue;
                }
                if (nextChar == this.myDel) {
                    try {
                        String string = this.myString.substring(this.myNextPosition, lastIndex);
                        return string;
                    }
                    finally {
                        this.myNextPosition = lastIndex + 1;
                    }
                }
                ++lastIndex;
            }
            try {
                String string = this.myString.substring(this.myNextPosition);
                return string;
            }
            finally {
                this.myNextPosition = lastIndex + 1;
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported");
        }
    }

    public static interface EscapeInfoProvider2
    extends MapSerializerUtil.EscapeInfoProvider2 {
    }

    @Deprecated
    public static interface EscapeInfoProvider
    extends MapSerializerUtil.EscapeInfoProvider {
    }

    public static interface LineProcessor {
        public boolean processLine(String var1);
    }
}

