/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Iterator;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.ThreadStatImpl;
import jetbrains.buildServer.util.ThreadStatNoOp;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadStat {
    public static final String THREAD_STAT_ENABLED_PROP = "teamcity.diagnostics.threadStatEnabled";
    private static final ThreadStat ourNoOpStat = new ThreadStatNoOp();
    private static final ThreadLocal<ThreadStat> ourThreadStat = new ThreadLocal<ThreadStat>(){

        @Override
        protected ThreadStat initialValue() {
            return ourNoOpStat;
        }
    };

    @NotNull
    public static ThreadStat get() {
        ThreadStat threadStat = ourThreadStat.get();
        if (threadStat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ThreadStat", "get"));
        }
        return threadStat;
    }

    public static void init() {
        ourThreadStat.set(ThreadStat.isEnabled() ? new ThreadStatImpl() : ourNoOpStat);
    }

    public static void reset() {
        ourThreadStat.remove();
    }

    public static boolean isEnabled() {
        return TeamCityProperties.getBoolean(THREAD_STAT_ENABLED_PROP);
    }

    @NotNull
    public abstract Disposable startOperation(@NotNull String var1);

    public abstract Iterator<ThreadOperation> getOperations();

    public static interface ThreadOperation {
        public int getLevel();

        @NotNull
        public String getDescription();

        public long getDurationNanos();
    }
}

