/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import gnu.trove.TLongArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.ThreadStat;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadStatImpl
extends ThreadStat {
    private final TIntArrayList myLevels = new TIntArrayList();
    private final ArrayList<String> myDescriptions = new ArrayList();
    private final TLongArrayList myDurations = new TLongArrayList();
    private int myIndex = 0;
    private int myCurrentLevel = 0;

    @Override
    @NotNull
    public Disposable startOperation(@NotNull String operationDescription) {
        if (operationDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationDescription", "jetbrains/buildServer/util/ThreadStatImpl", "startOperation"));
        }
        this.myLevels.add(this.myCurrentLevel);
        this.myDescriptions.add(operationDescription);
        this.myDurations.add(-System.nanoTime());
        DisposableImpl disposableImpl = new DisposableImpl(this.myIndex++, this.myCurrentLevel++);
        if (disposableImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ThreadStatImpl", "startOperation"));
        }
        return disposableImpl;
    }

    @Override
    public Iterator<ThreadStat.ThreadOperation> getOperations() {
        return new OperationIterator(this.myIndex);
    }

    private class DisposableImpl
    implements Disposable {
        private final int myOperationIndex;
        private final int myOldLevel;

        public DisposableImpl(int operationIndex, int oldLevel) {
            this.myOperationIndex = operationIndex;
            this.myOldLevel = oldLevel;
        }

        public void dispose() {
            ThreadStatImpl.this.myDurations.set(this.myOperationIndex, System.nanoTime() + ThreadStatImpl.this.myDurations.get(this.myOperationIndex));
            if (ThreadStatImpl.this.myCurrentLevel > this.myOldLevel) {
                ThreadStatImpl.this.myCurrentLevel = this.myOldLevel;
            }
        }
    }

    private class ThreadOperationImpl
    implements ThreadStat.ThreadOperation {
        private final int myLevel;
        private final String myDescription;
        private final long myDurationNanos;

        public ThreadOperationImpl(@NotNull int level, String description, long durationNanos) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "jetbrains/buildServer/util/ThreadStatImpl$ThreadOperationImpl", "<init>"));
            }
            this.myLevel = level;
            this.myDescription = description;
            this.myDurationNanos = durationNanos;
        }

        public int getLevel() {
            return this.myLevel;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ThreadStatImpl$ThreadOperationImpl", "getDescription"));
            }
            return string;
        }

        public long getDurationNanos() {
            if (this.myDurationNanos >= 0L) {
                return this.myDurationNanos;
            }
            return System.nanoTime() + this.myDurationNanos;
        }

        public String toString() {
            return "ThreadOperationImpl{level=" + this.myLevel + ", description='" + this.myDescription + '\'' + ", durationNanos=" + this.myDurationNanos + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OperationIterator
    implements Iterator<ThreadStat.ThreadOperation> {
        private final int myMaxIndex;
        private int myIndex = 0;

        public OperationIterator(int maxIndex) {
            this.myMaxIndex = maxIndex;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < this.myMaxIndex;
        }

        @Override
        public ThreadStat.ThreadOperation next() {
            ThreadOperationImpl op = new ThreadOperationImpl(ThreadStatImpl.this.myLevels.get(this.myIndex), (String)ThreadStatImpl.this.myDescriptions.get(this.myIndex), ThreadStatImpl.this.myDurations.get(this.myIndex));
            ++this.myIndex;
            return op;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

