/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Iterator;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.ThreadStat;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadStatNoOp
extends ThreadStat {
    private static final Disposable ourNoOpDisposable = new NoOpDisposable();
    private static final EmptyIterator ourEmptyIterator = new EmptyIterator();

    @Override
    @NotNull
    public Disposable startOperation(@NotNull String operationDescription) {
        if (operationDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationDescription", "jetbrains/buildServer/util/ThreadStatNoOp", "startOperation"));
        }
        Disposable disposable = ourNoOpDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ThreadStatNoOp", "startOperation"));
        }
        return disposable;
    }

    @Override
    public Iterator<ThreadStat.ThreadOperation> getOperations() {
        return ourEmptyIterator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<ThreadStat.ThreadOperation> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ThreadStat.ThreadOperation next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private static class NoOpDisposable
    implements Disposable {
        private NoOpDisposable() {
        }

        public void dispose() {
        }
    }
}

