/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.DiagnosticUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadUtil {
    public static void shutdownNowAndWait(ExecutorService service, String identifier) {
        assert (service != null);
        service.shutdown();
        try {
            if (service instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor poolExecutor = (ThreadPoolExecutor)service;
                poolExecutor.getQueue().clear();
            }
            service.awaitTermination(5L, TimeUnit.SECONDS);
            if (!service.isTerminated()) {
                Loggers.SERVER.warn("Waiting for " + identifier + " to complete");
            }
            service.shutdownNow();
            service.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Loggers.SERVER.warn((Throwable)e);
        }
        if (!service.isTerminated()) {
            Loggers.SERVER.warn("Stopped waiting for " + identifier + " to complete, some of them are still running");
            DiagnosticUtil.threadDumpToLog(service);
        }
    }

    @NotNull
    public static Map<Future, Throwable> waitForTasks(@NotNull Collection<Future> futures) {
        if (futures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "futures", "jetbrains/buildServer/util/ThreadUtil", "waitForTasks"));
        }
        HashMap<Future, Throwable> errors = new HashMap<Future, Throwable>();
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                errors.put(f, e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                errors.put(f, cause);
            }
        }
        HashMap<Future, Throwable> hashMap = errors;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/ThreadUtil", "waitForTasks"));
        }
        return hashMap;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

