/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedExecutor {
    @NotNull
    private final ExecutorService myExecutor;

    @NotNull
    public static TimedExecutor withCachedThreadPool(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/TimedExecutor", "withCachedThreadPool"));
        }
        TimedExecutor timedExecutor = TimedExecutor.withCachedThreadPool(name, 60000L);
        if (timedExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TimedExecutor", "withCachedThreadPool"));
        }
        return timedExecutor;
    }

    @NotNull
    public static TimedExecutor withCachedThreadPool(@NotNull String name, long keepAliveMilliseconds) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/TimedExecutor", "withCachedThreadPool"));
        }
        TimedExecutor timedExecutor = new TimedExecutor(0, Integer.MAX_VALUE, keepAliveMilliseconds, new SynchronousQueue<Runnable>(), name);
        if (timedExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TimedExecutor", "withCachedThreadPool"));
        }
        return timedExecutor;
    }

    @NotNull
    public static TimedExecutor withSingleThreadPool(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/TimedExecutor", "withSingleThreadPool"));
        }
        TimedExecutor timedExecutor = TimedExecutor.withFixedThreadPool(1, name);
        if (timedExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TimedExecutor", "withSingleThreadPool"));
        }
        return timedExecutor;
    }

    @NotNull
    public static TimedExecutor withFixedThreadPool(int threadCount, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/TimedExecutor", "withFixedThreadPool"));
        }
        TimedExecutor timedExecutor = new TimedExecutor(threadCount, threadCount, 0L, new LinkedBlockingQueue<Runnable>(), name);
        if (timedExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TimedExecutor", "withFixedThreadPool"));
        }
        return timedExecutor;
    }

    /*
     * WARNING - void declaration
     */
    private TimedExecutor(int coreThreadCount, int maxThreadCount, long keepAliveMilliseconds, @NotNull BlockingQueue<Runnable> workQueue, @NotNull String string) {
        void name;
        if (workQueue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "jetbrains/buildServer/util/TimedExecutor", "<init>"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workQueue", "jetbrains/buildServer/util/TimedExecutor", "<init>"));
        }
        this.myExecutor = new ThreadPoolExecutor(coreThreadCount, maxThreadCount, keepAliveMilliseconds, TimeUnit.MILLISECONDS, workQueue, new NamedThreadFactory((String)name));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T> T execute(long timeoutMilliseconds, @NotNull Callable<T> callable) {
        void task;
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/buildServer/util/TimedExecutor", "execute"));
        }
        return this.execute(timeoutMilliseconds, (Class)RuntimeException.class, (Callable<T>)task);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T, E extends Throwable> T execute(long timeoutMilliseconds, @NotNull Class<E> exceptionClazz, @NotNull Callable<T> callable) throws E {
        if (exceptionClazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/buildServer/util/TimedExecutor", "execute"));
        }
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClazz", "jetbrains/buildServer/util/TimedExecutor", "execute"));
        }
        Future future = null;
        try {
            void task;
            future = this.myExecutor.submit(task);
            return future.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (exceptionClazz.isInstance(cause)) {
                throw (Throwable)exceptionClazz.cast(cause);
            }
            if (cause != null) {
                ExceptionUtil.rethrowAsRuntimeException(cause);
            }
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            return null;
        }
    }

    public void dispose() {
        this.myExecutor.shutdownNow();
    }
}

