/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.SimpleObjectPool;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final SimpleObjectPool<SAXBuilder> myValidatingSAXBuilder = new SimpleObjectPool<SAXBuilder>(new SimpleObjectPool.ObjectFactory<SAXBuilder>(){

        @Override
        @NotNull
        public SAXBuilder create() {
            SAXBuilder sAXBuilder = XMLParser.createSAXBuilder(true);
            if (sAXBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser$1", "create"));
            }
            return sAXBuilder;
        }
    }, 10);
    private static final SimpleObjectPool<SAXBuilder> myNonValidatingSAXBuilder = new SimpleObjectPool<SAXBuilder>(new SimpleObjectPool.ObjectFactory<SAXBuilder>(){

        @Override
        @NotNull
        public SAXBuilder create() {
            SAXBuilder sAXBuilder = XMLParser.createSAXBuilder(false);
            if (sAXBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser$2", "create"));
            }
            return sAXBuilder;
        }
    }, 10);

    @NotNull
    private static SAXBuilder createSAXBuilder(boolean validate) {
        SAXBuilder builder = new SAXBuilder(validate);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        builder.setFeature("http://xml.org/sax/features/namespaces", true);
        builder.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", validate);
        if (validate) {
            builder.setEntityResolver((EntityResolver)new DefaultHandler(){

                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    InputStream schemaStream;
                    String schemaFileName;
                    int lastSlash = systemId.lastIndexOf(47);
                    if (lastSlash != -1 && ((schemaFileName = systemId.substring(lastSlash + 1)).endsWith(".xsd") || schemaFileName.endsWith(".dtd")) && (schemaStream = this.getClass().getClassLoader().getResourceAsStream(schemaFileName)) != null) {
                        return new InputSource(schemaStream);
                    }
                    if (TeamCityProperties.getBoolean("teamcity.xmlParser.allowFileSystemAccess")) {
                        return super.resolveEntity(publicId, systemId);
                    }
                    return XMLParser.emptyInputSource();
                }
            });
        } else {
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return XMLParser.emptyInputSource();
                }
            });
        }
        SAXBuilder sAXBuilder = builder;
        if (sAXBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser", "createSAXBuilder"));
        }
        return sAXBuilder;
    }

    @NotNull
    private static InputSource emptyInputSource() {
        InputSource inputSource = new InputSource(new CharArrayReader(new char[0]));
        if (inputSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser", "emptyInputSource"));
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Element parseWithSAXBuilder(@NotNull ParserFunc parser, boolean validate) throws JDOMException, IOException {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "jetbrains/buildServer/util/XMLParser", "parseWithSAXBuilder"));
        }
        SimpleObjectPool<SAXBuilder> buildersPool = validate ? myValidatingSAXBuilder : myNonValidatingSAXBuilder;
        SAXBuilder builder = buildersPool.getFromPool();
        Element element = parser.parse(builder);
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser", "parseWithSAXBuilder"));
        }
        return element2;
        finally {
            buildersPool.returnInPool(builder);
        }
    }

    public static interface ParserFunc {
        @NotNull
        public Element parse(@NotNull SAXBuilder var1) throws JDOMException, IOException;
    }
}

