/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.executors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.util.NamedDaemonThreadFactory;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.executors.TeamCityScheduledThreadPoolExecutor;
import jetbrains.buildServer.util.executors.TeamCityThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class ExecutorsFactory {
    @NotNull
    public static ExecutorService newFixedDaemonExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefix", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedDaemonExecutor"));
        }
        ExecutorService executorService = ExecutorsFactory.createFixedThreadPoolExecutor(new NamedDaemonThreadFactory(threadNamePrefix), poolSize);
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedDaemonExecutor"));
        }
        return executorService;
    }

    @NotNull
    public static ExecutorService newFixedExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefix", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedExecutor"));
        }
        ExecutorService executorService = ExecutorsFactory.createFixedThreadPoolExecutor(new NamedThreadFactory(threadNamePrefix), poolSize);
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedExecutor"));
        }
        return executorService;
    }

    @NotNull
    public static ScheduledExecutorService newFixedScheduledDaemonExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefix", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedScheduledDaemonExecutor"));
        }
        TeamCityScheduledThreadPoolExecutor teamCityScheduledThreadPoolExecutor = new TeamCityScheduledThreadPoolExecutor(poolSize, new NamedDaemonThreadFactory(threadNamePrefix));
        if (teamCityScheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedScheduledDaemonExecutor"));
        }
        return teamCityScheduledThreadPoolExecutor;
    }

    @NotNull
    public static ScheduledExecutorService newFixedScheduledExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefix", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedScheduledExecutor"));
        }
        TeamCityScheduledThreadPoolExecutor teamCityScheduledThreadPoolExecutor = new TeamCityScheduledThreadPoolExecutor(poolSize, new NamedThreadFactory(threadNamePrefix));
        if (teamCityScheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newFixedScheduledExecutor"));
        }
        return teamCityScheduledThreadPoolExecutor;
    }

    @NotNull
    public static ExecutorService newDaemonExecutor(@NotNull String threadNamePrefix) {
        if (threadNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefix", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newDaemonExecutor"));
        }
        ExecutorService executorService = ExecutorsFactory.createThreadPoolExecutor(new NamedDaemonThreadFactory(threadNamePrefix));
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newDaemonExecutor"));
        }
        return executorService;
    }

    @NotNull
    public static ExecutorService newExecutor(@NotNull String threadNamePrefix) {
        if (threadNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadNamePrefix", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newExecutor"));
        }
        ExecutorService executorService = ExecutorsFactory.createThreadPoolExecutor(new NamedThreadFactory(threadNamePrefix));
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "newExecutor"));
        }
        return executorService;
    }

    @NotNull
    private static ExecutorService createFixedThreadPoolExecutor(@NotNull ThreadFactory threadFactory, int poolSize) {
        if (threadFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadFactory", "jetbrains/buildServer/util/executors/ExecutorsFactory", "createFixedThreadPoolExecutor"));
        }
        TeamCityThreadPoolExecutor teamCityThreadPoolExecutor = new TeamCityThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        if (teamCityThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "createFixedThreadPoolExecutor"));
        }
        return teamCityThreadPoolExecutor;
    }

    @NotNull
    private static ExecutorService createThreadPoolExecutor(@NotNull ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadFactory", "jetbrains/buildServer/util/executors/ExecutorsFactory", "createThreadPoolExecutor"));
        }
        TeamCityThreadPoolExecutor teamCityThreadPoolExecutor = new TeamCityThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        if (teamCityThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ExecutorsFactory", "createThreadPoolExecutor"));
        }
        return teamCityThreadPoolExecutor;
    }
}

