/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.executors;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.NamedThreadFactory;

public class TeamCityScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final ThreadLocal<Disposable> ourThreadName = new ThreadLocal();

    public TeamCityScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        Disposable newName = NamedThreadFactory.patchThreadName("Task started");
        ourThreadName.set(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            Disposable newName = ourThreadName.get();
            if (newName != null) {
                newName.dispose();
            }
        }
    }
}

